#!/usr/bin/env python

import ConfigParser
import os
import shutil
import hashlib

CONFIGFILENAME = "mythbuntu-bare-client.conf"
CONFIGPATH = "/etc/default/"

CHECKSUMFILE = "/tmp/CHECKSUM"
CONFIGFILE = CONFIGPATH+CONFIGFILENAME
TMPCONFIGFILE = "/tmp/"+CONFIGFILENAME

class Update():

  def update_job(self, ServerIP=None):
    if os.path.isfile(CONFIGFILE):
      NEW = False
      config = ConfigParser.ConfigParser()
      config.read(CONFIGFILE)
      self.Revision = config.get("General", "Revision")
      ServerIP = config.get("General", "ServerIP")
      ServerURL = "http://"+ServerIP+"/mythbuntu-bare/"
    else:
      NEW = True
      self.Revision = 0
      ServerURL = "http://"+ServerIP+"/mythbuntu-bare/"

    ## Check tmp dir for update file
    if os.path.isfile(TMPCONFIGFILE):
      NEW = False
      self.process_updates()
      os.remove(TMPCONFIGFILE)

    ## Download update file from server
    download_successful=False
    try:
      self.check_server(CONFIGFILENAME,ServerURL)
      self.check_server("CHECKSUM",ServerURL)
      download_successful=True
    except:
      print "ERROR: Couldn't update files from server"

    ## If files downloaded from server, get revision and process them
    if download_successful:
      if NEW == False:
        config = ConfigParser.ConfigParser()
        config.read(CONFIGFILE)
        Revision = config.get("General", "Revision")
      else:
        NEW = False
        Revision = 0
      self.process_updates()

    ## Remove temp files
    if os.path.isfile(TMPCONFIGFILE):
      os.remove(TMPCONFIGFILE)
    if os.path.isfile("/tmp/CHECKSUM"):
      os.remove("/tmp/CHECKSUM")

  def check_server(self,file_name,base_url):
    from urllib2 import Request, urlopen, URLError, HTTPError
    #create the url and the request
    url = base_url + file_name
    req = Request(url)
    # Open the url
    f = urlopen(req)
    # Open our local file for writing
    local_file = open("/tmp/"+file_name, "w")
    #Write to our local file
    local_file.write(f.read())
    local_file.close()

  def process_updates(self):
    ## Get revision
    tempconfig = ConfigParser.ConfigParser()
    tempconfig.read(TMPCONFIGFILE)
    tempRevision = tempconfig.get("General", "Revision")
    ## If revision is newer, process. 
    if int(self.Revision) < int(tempRevision):
      ## Calculate checksum
      m = hashlib.md5()
      f = open(TMPCONFIGFILE)
      for line in f:
        m.update(line)
      calcsum = m.hexdigest()
      f.close()
      chksumconfig = ConfigParser.ConfigParser()
      chksumconfig.read(CHECKSUMFILE)
      checksum = chksumconfig.get("Checksum", "md5")
      if calcsum == checksum:
        ## If checksums match, copy file into dir
        shutil.copyfile(TMPCONFIGFILE, CONFIGFILE)
      else:
        print "Error: Checksum failed"

#Update().update_job("192.168.0.41")


