#!/usr/bin/env python

from mythbackup import Backup
import ConfigParser

CONFIGFILENAME = "mythbuntu-bare-client.conf"
CONFIGPATH = "/etc/default/"
CONFIGFILE = CONFIGPATH+CONFIGFILENAME

## Read config file
config = ConfigParser.ConfigParser()
config.read(CONFIGFILE)

## Check if managed and if so, then update
managed = config.get("General", "managed")
if managed:
    pipe = subprocess.Popen(["/usr/share/mythbuntu-bare/update-task.py"], stdout=subprocess.PIPE).communicate()

## Reread config file in case it was updated
config.read(CONFIGFILE)
DB = config.get("Backup", "database")
storagedir = config.get("Backup", "storagedir")

## Run backup job
Backup().backup_job(DB, storagedir)


