#include "active_label.h"

//--------------------------------------------------------------------------------
ActiveLabel::ActiveLabel(const Glib::ustring& text, const sigc::slot<void> &close_callback)
            : _close_callback(close_callback)
            , _label("\342\234\225")
            , _text_label(text)
{
  _evbox.add(_label);
  _evbox.signal_event().connect(sigc::mem_fun(this, &ActiveLabel::handle_event));

  _text_label_eventbox.add(_text_label);

  pack_start(_text_label_eventbox);
  pack_start(_evbox);

  _evbox.show_all();
  _label.show();
  show_all();

  signal_button_press_event().connect(sigc::mem_fun(this, &ActiveLabel::button_press_slot));

  #if GTK_VERSION_GE(2,20)
  _spinner.hide();
  #endif
}

//--------------------------------------------------------------------------------
bool ActiveLabel::handle_event(GdkEvent* e)
{
  switch (e->type)
  {
    case GDK_BUTTON_RELEASE:
      {
        GdkEventButton *evb = (GdkEventButton*)e;
        if (evb->button == 1)
          _close_callback();
        break;
      }
    default:
      break;
  }

  return false;
}

//--------------------------------------------------------------------------------
void ActiveLabel::set_text(const std::string& lbl)
{
  _text_label.set_text(lbl);
}

//--------------------------------------------------------------------------------
bool ActiveLabel::button_press_slot(GdkEventButton* evb)
{
  if (evb->button == 3 && !_menu.empty())
    _menu.popup_at(0, evb->x, evb->y);
  return false;
}

//--------------------------------------------------------------------------------
void ActiveLabel::start_busy()
{
#if GTK_VERSION_GE(2,20)
  _label.hide();
  _evbox.remove();
  _spinner.show();
  _evbox.add(_spinner);
  _spinner.start();
#endif
}

//--------------------------------------------------------------------------------
void ActiveLabel::stop_busy()
{
#if GTK_VERSION_GE(2,20)
  _spinner.hide();
  _evbox.remove();
  _label.show();
  _evbox.add(_label);
  _spinner.stop();
#endif
}
