#!/bin/sh

ECHO="echo"
SED="sed"
WC="wc"

one_of_tests_failed=0

opt_port=0
opt_host="localhost"
opt_user="root"
opt_password=""
opt_ansi_mode=""
opt_path=""
opt_version=""
opt_verbose="0"

while test $# -gt 0; do
  case "$1" in

   --port=*)
     opt_port=`$ECHO "$1" | $SED -e "s;--port=;;"` ;;
   --host=*)
     opt_host=`$ECHO "$1" | $SED -e "s;--host=;;"` ;;
   --path=*)
     opt_path=`$ECHO "$1" | $SED -e "s;--path=;;"` ;;
   --user=*)
     opt_user=`$ECHO "$1" | $SED -e "s;--user=;;"` ;;
   --password=*)
     opt_password=`$ECHO "$1" | $SED -e "s;--password=;;"` ;;
   --ansi-quotas=*)
     opt_ansi_mode=`$ECHO "$1" | $SED -e "s;--ansi-quotas=;;"` ;;

   --use-ready-server-4.0)
     opt_version= "4.0";;
   --use-ready-server-4.1)
     opt_version= "4.1";;
   --use-ready-server-5.0)
     opt_version= "5.0";;

   --verbose)
     opt_verbose="1";;

   --* ) $ECHO "Unknown option: \"$1\""; exit 1 ;;
  esac
  shift
done

path_to_top="../../../../"
path_to_utils="${path_to_top}mysql-gui-common/tests/"

server_40_path=$MYSQL_40_PATH
server_40_host_name="localhost"
server_40_port=3307
server_40_user_name="root"
server_40_password=""
server_40_enabled=true
server_40_version="4.0"
server_40_use_ready_server="0"

server_41_path=$MYSQL_41_PATH
server_41_host_name="localhost"
server_41_port=3308
server_41_user_name="root"
server_41_password=""
server_41_enabled=true
server_41_version="4.1"
server_41_use_ready_server="0"

server_50_path=$MYSQL_50_PATH
server_50_host_name="localhost"
server_50_port=3309
server_50_user_name="root"
server_50_password=""
server_50_enabled=true
server_50_version="5.0"
server_50_use_ready_server="0"

load_members()
{
  this=$1

  var_name="\$${this}_path"
  this_path=`eval echo $var_name`

  var_name="\$${this}_host_name"
  this_host_name=`eval echo $var_name`

  var_name="\$${this}_port"
  this_port=`eval echo $var_name`

  var_name="\$${this}_user_name"
  this_user_name=`eval echo $var_name`

  var_name="\$${this}_password"
  this_password=`eval echo $var_name`
  
  var_name="\$${this}_enabled"
  this_enabled=`eval echo $var_name`

  var_name="\$${this}_version"
  this_version=`eval echo $var_name`

  var_name="\$${this}_use_ready_server"
  this_use_ready_server=`eval echo $var_name`
}

set_member()
{
  this=$1
  name=$2
  value=$3
  var_name="${this}_${name}"
  eval "${var_name}=${value}"
}

server_print_all()
{
  load_members $1
  echo "path=\"$this_path\""
  echo "host_name=\"$this_host_name\""
  echo "port=\"$this_port\""
  echo "user_name=\"$this_user_name\""
  echo "password=\"$this_password\""
  echo "enabled=\"$this_enabled\""
  echo "version=\"$this_version\""
}

server_check_connection()
{
  this=$1
  load_members $this
  if [ "x$this_enabled" = "x0" ]; then
    return 0
  fi
  cmd_line="${path_to_utils}try_to_connect_mysqld.sh"
  cmd_line="$cmd_line ${this_path}"
  cmd_line="$cmd_line ${this_host_name}"
  cmd_line="$cmd_line ${this_port}"
  cmd_line="$cmd_line ${this_user_name}"
  cmd_line="$cmd_line ${this_password}"
  for i in 0 1 2 3 4 5 6 7 8 9
  do
    if [ "x$opt_verbose" != "x0" ]; then
      server_get_open_parameters $this
      echo -n "try to connect to mysqld-${this_version}(${this_open_parameters}) .. "
    fi
    $cmd_line
    res=$?
    if [ "x$opt_verbose" != "x0" ]; then
      if [ "x$res" != "x0" ]; then
        echo "fail"
      else
        echo "ok"
      fi
    fi
    if [ "x$res" = "x$2" ]; then
      return 0
    fi
    sleep 1
  done
  return 1
}

get_connection_options()
{
  host=$1
  port=$2
  user=$3
  pass=$4

  server_connection_options=" --host=$host --port=$port --user=$user --password=$pass"
}

function server_get_connection_options()
{
  this=$1
  load_members $this
  get_connection_options $this_host_name $this_port $this_user_name $this_password
  this_connection_options=$server_connection_options
}

server_get_full_info()
{
  this=$1
  load_members $this
  get_connect_options $this
  server_full_info="\"$this_path\" $this_connection_options"
}

safe_print_disabled()
{
  if [ "x$opt_verbose" != "x0" ]; then
    echo "   .. disabled"
  fi
}

server_start()
{
  this=$1
  load_members $this
  if [ "x$opt_verbose" != "x0" ]; then
    server_get_open_parameters $this
    echo -n "start mysqld-${this_version}(${this_open_parameters})"
  fi
  if [ "x$this_enabled" = "x0" ]; then
    safe_print_disabled    
    return 0
  fi
  if [ "x$opt_verbose" != "x0" ]; then
    echo ""
  fi
  cmd_line="${this_path}libexec/mysqld --port=$this_port"
  $cmd_line > /dev/null 2> /dev/null &
}

server_execute_script()
{
  this=$1
  fname=$2
  load_members $this
  if [ "x$opt_verbose" != "x0" ]; then
    server_get_open_parameters $this
    echo "execute script \"${fname}\" on mysqld-${this_version}(${this_open_parameters})"
  fi 
  if [ "x$this_enabled" = "x0" ]; then
    safe_print_disabled
    return 0
  fi
  server_get_connection_options $this
  cmd_line="${this_path}bin/mysql $this_connect_options"
  $cmd_line < $fname
}

server_mysqldump()
{
  this=$1
  extra_options=$2
  fname=$3
  load_members $this
  if [ "x$this_enabled" = "x0" ]; then
    return 0
  fi
  server_get_connection_options $this
  cmd_line="\"${this_path}/bin/mysqldump\" $this_connect_options $extra_options"
  $cmd_line > $fname
}

server_stop()
{
  this=$1
  load_members $this
  if [ "x$opt_verbose" != "x0" ]; then
    server_get_open_parameters $this
    echo "stop mysqld-${this_version}(${this_open_parameters})"
  fi
  if [ "x$this_enabled" = "x0" ]; then
    safe_print_disabled
    return 0
  fi
  server_get_connection_options $this
  cmd_line="${this_path}bin/mysqladmin --port=$port --user=$this_user_name shutdown"
  $cmd_line
  sleep 1
}

print_server_bad()
{
  this=$1
  text=$2

  echo $text
  server_get_full_info $this
  echo $this_full_info
  set_member $this enabled 1
  one_of_tests_failed=1
}

server_safe_start()
{
  this=$1
  load_members $this
  if [ "x$this_enabled" = "x0" ]; then
    if [ "x$opt_verbose" != "x0" ]; then
      server_get_open_parameters $this
      echo "safe start mysqld-${this_version}(${this_open_parameters}) .. disabled"
    fi
    return 0
  fi
  if [ "x$this_use_ready_server" != "x0" ]; then
    server_check_connection $this 0
    if [ "x$?" != "x0" ]; then
      print_server_bad $this "can't esteblish connection to server..."
      return 1
    fi
  else
    server_check_connection $this 1
    if [ "x$?" != "x0" ]; then
      server_stop $this
      server_check_connection $this 1
      if [ "x$?" != "x0" ]; then
        print_server_bad $this "can't stop server..."
        return 1
      fi
    fi
    server_start $this
    i=0
    server_check_connection $this 0
    while [ "x$?" != "x0" ]; do
      if [ $i -gt 10 ]; then
        break
      fi
      server_start $this
      i=`expr $i+1`
      server_check_connection $this 0
    done      
    if [ $i -gt 10 ]; then
      server_check_connection $this 0
      if [ "x$?" != "x0" ]; then
        print_server_bad $this "can't esteblish connection to server..."
        return 1
      fi
    fi
  fi
}

server_safe_stop()
{
  this=$1
  load_members $this
  if [ "x$this_enabled" = "x0" ]; then
    if [ "x$opt_verbose" != "x0" ]; then
      server_get_open_parameters $this
      echo "safe stop mysqld-${this_version}${this_open_parameters} .. disabled"
    fi
    return 1
  fi
  if [ "x$this_use_ready_server" != "x0" ]; then
    return 1
  fi
  server_stop $this
  return $?
}


server_use_options()
{
  this=$1
  set_member $this path             $opt_path
  set_member $this host_name        $opt_host
  set_member $this port             $opt_port
  set_member $this user_name        $opt_user
  set_member $this password         $opt_password
  set_member $this use_ready_server "1"
}

server_check_path()
{
  this=$1
  load_members $this
  if [ "x$this_path" = "x" ]; then
    set_member $this enabled 0
  else
    server_path="${this_path}libexec/mysqld"
    if [ ! -e $server_path ]; then
      echo "can't find the file \"$server_path\""
      set_member $this enabled 0
    fi
  fi
}

server_prepare_connection_file()
{
  this=$1
  fin=$2
  fout=$3
  load_members $this
  if [ "x$this_use_ready_server" != "x0" -o "x$this_enabled" != "x0" ]; then
    cat $fin | sed -e "s/<hostname>.*<\/hostname>/<hostname>localhost<\/hostname>/" > $fout
  else
    cat $fin | sed -s/<port>.*</port>/<port>$this_port</port>/ > tmp1
    cat tmp1 | sed -s/<hostname>.*</hostname>/<hostname>$this_hostname</hostname>/ > tmp2
    cat tmp2 | sed -s/<password>.*</password>/<password>$this_password</password>/ > tmp1
    cat tmp2 | sed -s/<username>.*</username>/<username>$this_user_name</username>/ > $fout
    rm tmp1
    rm tmp2
  fi
}

server_get_open_parameters()
{
  this=$1
  load_members $this
  this_open_parameters="${this_host_name},${this_port},${this_socket},${this_user_name}"
}

if [ "x$opt_port"="x0"                    ]; then opt_port=3306;           fi
if [ $opt_host==""                        ]; then opt_host="127.0.0.1";    fi
if [ $opt_user==""                        ]; then opt_user="root";         fi
if [ $opt_version=="4.0" -a $opt_path=="" ]; then opt_path=$MYSQL_40_PATH; fi
if [ $opt_version=="4.1" -a $opt_path=="" ]; then opt_path=$MYSQL_41_PATH; fi
if [ $opt_version=="5.0" -a $opt_path=="" ]; then opt_path=$MYSQL_50_PATH; fi
if [ $opt_path==""                        ]; then opt_path=$MYSQL_40_PATH; fi
if [ $opt_path==""                        ]; then opt_path=$MYSQL_41_PATH; fi
if [ $opt_path==""                        ]; then opt_path=$MYSQL_50_PATH; fi

if [ "x$opt_version" = "x4.0" ]; then
  server_use_options server_40
  server_41_enabled=0
  server_50_enabled=0
fi

if [ "x$opt_version" = "x4.1" ]; then
  server_use_options server_41
  server_40_enabled=0
  server_50_enabled=0
fi

if [ "x$opt_version" = "x5.0" ]; then
  server_use_options server_40
  server_40_enabled=0
  server_41_enabled=0
fi

server_check_path server_40
server_check_path server_41
server_check_path server_50

extend_line()
{
 line=$1
 size=$2
 filler=$3
 
 l=`echo "$line" | $WC --chars`
 while [ "$l" -lt "$size" ] ; do
   line="$line$filler"
   l=`echo "$line" | $WC --chars`
 done
 extended_line=$line
}

print_title()
{
  str=$1
  str="--------- $str : "
  extend_line "$str" 80 "-"
  echo $extended_line
}

print_test_res()
{
  str=$1
  fc_result=$2
  line="- $str "
  if [ "x${fc_result}" = "x0" ]; then
    extend_line "$line" 76 " "
    echo "${extended_line}[ok]"
  else
    extend_line "$line" 74 " "
    echo "${extended_line}[fail]"
  fi
}

print_test_skipped()
{
  str=$1
  extend_line "- $str" 71 " "
  echo "${extended_line}[skipped]"
}

discard_volatile_results()
{
  file_src=$1
  file_dst=$2
  if test -e "$file_src" 
  then
    cat $file_src | grep -v Host    > tmp_file1
    cat tmp_file1 | grep -v version > $file_dst
    rm tmp_file1
  else
    echo "" > $file_dst
  fi
  if [ -a $file_src ]; then
    rm $file_src
  fi
}

compare_results()
{
  name_etalon=$1
  name_result=$2
  local_name_diff=$3

  diff --ignore-matching-lines=RE --strip-trailing-cr $name_etalon $name_result > $local_name_diff
  fc_result=$?

  if [ "x${fc_result}" != "x0" ]; then
    one_of_tests_failed=1
  else
    rm $local_name_diff
    rm $name_result
  fi  
  return $fc_result
}

print_footer()
{
  if [ "x$one_of_tests_failed" != "x0" ]; then
    echo "-------------------------------------------------------------------tests-fail!-"
  else
    echo "-------------------------------------------------------------------------------"
  fi
}
