#import "MQueryBrowserController.h"

#import "MQueryBrowser.h"
#import "MQHistory.h"
#import "MQBookmark.h"

#import <MySQLToolsCommon/MConnectionPanel.h>
#import <MySQLToolsCommon/MPreferences.h>
#import <MySQLToolsCommon/MPreferenceEditor.h>


@interface MQueryBrowserController(Private)

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification;
- (void)connectionPanel:(MConnectionPanel*)panel finished:(MYSQL*)mysql info:(MYX_USER_CONNECTION*)info;
- (void)connectionPanel:(MConnectionPanel*)panel aborted:(BOOL)error;

- (void)recentMenuActivate:(id)sender;
- (void)updateRecentMenu;
@end


@implementation MQueryBrowserController(Private)

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
  [self newDocument:nil];
}


- (void)connectionPanel:(MConnectionPanel*)panel finished:(MYSQL*)mysql info:(MYX_USER_CONNECTION*)info
{
  MQueryBrowser *qb;
  qb= [[MQueryBrowser alloc] initWithConnection:mysql info:info];
  if (qb)
  {
    [self addInstance: qb];
    [[qb window] makeKeyAndOrderFront:self];
    [qb release];
  }
  else
    NSLog(@"Main window initialization failed!");
  [panel autorelease];
}

- (void)connectionPanel:(MConnectionPanel*)panel aborted:(BOOL)error
{
  [panel release];
}


- (void)recentMenuActivate:(id)sender
{
  [self openInstanceWithConnectionName:[sender representedObject]];
}


- (void)updateRecentMenu
{
  return;//XXX
  NSMenu *menu= [recentMenu submenu];
  unsigned int i;
  NSArray *array= [[NSUserDefaults standardUserDefaults] arrayForKey:@"RecentConnections"];
  
  while ([menu numberOfItems] > 2)
    [menu removeItemAtIndex:0];
   
  for (i= 0; i < [array count]; i++)
  {
    id item= [menu addItemWithTitle:[array objectAtIndex:i]
                             action:@selector(recentMenuActivate:)
                      keyEquivalent:@""];
    [item setRepresentedObject:[array objectAtIndex:i]];
  }
}

@end


//=======================================================================

@implementation MQueryBrowserController


static MQueryBrowserController *theSharedInstance= nil;


+ (MQueryBrowserController*)sharedDocumentController
{
  if (!theSharedInstance)
    theSharedInstance= [[MQueryBrowserController alloc] init];
  
  return theSharedInstance;
}


- (id)init
{
  NSUserDefaults *defaults= [NSUserDefaults standardUserDefaults];
  NSDictionary *appDefaults = [NSDictionary dictionaryWithObjectsAndKeys: 
    [NSArray array], @"RecentConnections",
	[MPreferences checkDirectory:@"QueryBrowser"], @"QBDirectory",
	nil];

  [defaults registerDefaults:appDefaults];

  [NSApp setDelegate:self];

  self= [super init];
  if (!self)
    return nil;
  
  _instances= [[NSMutableArray alloc] init];

  _history= [[MQHistory alloc] init];
  [_history loadFromFile: [NSString stringWithFormat:@"%@/history.xml",
	[defaults valueForKey:@"QBDirectory"]]];
  
  _bookmarks= [[MQBookmarkList alloc] init];
  [_bookmarks loadFromFile:[NSString stringWithFormat:@"%@/bookmarks.xml",
    [[NSUserDefaults standardUserDefaults] valueForKey:@"QBDirectory"]]];
  
  theSharedInstance= self;

  return self;
}

- (void)awakeFromNib
{
  //[self updateRecentMenu];
}


- (void)dealloc
{
  [_history release];
  [_prefPanel release];
  [_instances release];
  [super dealloc];
}


- (void)newDocument: (id)sender
{
  MConnectionPanel *panel;

  panel= [[MConnectionPanel alloc] initWithConnectionsFile: 
    [[MPreferences preferences] pathForFile:@"mysqlx_user_connections.xml"]];
  [panel setEditsSchema];
  [panel setDelegate:self];
  [panel show];
  [panel setHeaderImage: [[[NSImage alloc] initWithContentsOfFile: 
    [[NSBundle mainBundle] pathForResource:@"connect_header_qb"
                                    ofType:@"png"]] autorelease]];
}


- (void)openInstanceWithConnectionName: (NSString*)connectionName
{
  MConnectionPanel *panel;

  panel= [[MConnectionPanel alloc] initWithConnectionsFile: 
    [[MPreferences preferences] pathForFile:@"mysqlx_user_connections.xml"]];
  [panel setEditsSchema];
  [panel setDelegate:self];
  [panel showAndConnectTo:connectionName];
  [panel setHeaderImage: [[[NSImage alloc] initWithContentsOfFile: 
    [[NSBundle mainBundle] pathForResource:@"connect_header_qb"
                                    ofType:@"png"]] autorelease]];
}


- (void)addInstance: (MQueryBrowser*)instance
{
  [_instances addObject: instance];
  if ([instance serverInfo])
	[self noteNewRecentConnection:[instance serverInfo]];
}


- (void)removeInstance: (MQueryBrowser*)instance
{
  [_instances removeObject: instance];
}


- (void)noteNewRecentConnection: (MYX_USER_CONNECTION*)info
{
  NSString *name;
  NSUserDefaults *defaults= [NSUserDefaults standardUserDefaults];
  NSMutableArray *array= [NSMutableArray arrayWithArray:[defaults objectForKey:@"RecentConnections"]];
  
  name= [MConnectionPanel representationForConnection:info];
  
  [array removeObject:name];
  
  while ([array count] > 9)
  {
    [array removeLastObject];
  }
  
  [array insertObject:name atIndex:0];
  [defaults setObject:array forKey:@"RecentConnections"];
  [self updateRecentMenu];
}


- (IBAction)showAbout:(id)sender
{
  [versionLabel setStringValue:[NSString stringWithFormat:@"Version %@", 
    [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleVersion"]]];

  [aboutPanel makeKeyAndOrderFront:sender];
}


- (IBAction)showPreferences:(id)sender
{
  if (!_prefPanel)
  {
    _prefPanel= [[MPreferenceEditor alloc] initForConnectionsFile:
      [[MPreferences preferences] pathForFile:@"mysqlx_user_connections.xml"]];

    [_prefPanel registerPageNib:@"Preferences" withLabel:@"Query Browser"];
  
    [_prefPanel setReleaseOnClose:NO];
  }
  [_prefPanel show];
}


- (IBAction)clearRecentMenu:(id)sender
{
  [[NSUserDefaults standardUserDefaults] setObject:[NSArray array] forKey:@"RecentConnections"];
  [self updateRecentMenu];
}

- (MQHistory*)history
{
  return _history;
}

- (void)rememberQuery:(NSString*)query
			  catalog:(NSString*)catalog
			   schema:(NSString*)schema
{
  [_history rememberQuery:query catalog:catalog schema:schema];
  _historyNeedsSave= YES;
}

- (MQBookmarkList*)bookmarks
{
  return _bookmarks;
}


- (void)applicationWillTerminate:(NSNotification *)aNotification
{
  if (_historyNeedsSave)
  {
	_historyNeedsSave= NO;
	[_history storeToFile:[NSString stringWithFormat:@"%@/history.xml",
	  [[NSUserDefaults standardUserDefaults] valueForKey:@"QBDirectory"]]];
  }

  [_bookmarks storeToFile:[NSString stringWithFormat:@"%@/bookmarks.xml",
    [[NSUserDefaults standardUserDefaults] valueForKey:@"QBDirectory"]]];
}

@end
