/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.jdbc.exceptions.NotImplemented;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.util.StructuredMem;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public class DataPartVariable
extends DataPart {
    private int fieldCount = 0;
    private int currentArgCount = 0;
    private int currentFieldCount = 0;
    private int currentFieldLen = 0;

    public DataPartVariable(StructuredMem structuredMem, RequestPacket requestPacket) {
        super(structuredMem, requestPacket);
    }

    public DataPartVariable(StructuredMem structuredMem, int n) {
        super(structuredMem, null);
        this.argCount = n;
    }

    public boolean nextRow() {
        if (this.currentArgCount >= this.argCount) {
            return false;
        }
        ++this.currentArgCount;
        this.fieldCount = this.mem.getInt2(this.extent);
        this.extent += 2;
        this.currentFieldCount = 0;
        this.currentFieldLen = 0;
        return true;
    }

    public boolean nextField() {
        if (this.currentFieldCount >= this.fieldCount) {
            return false;
        }
        ++this.currentFieldCount;
        this.extent += this.currentFieldLen;
        this.currentFieldLen = this.getFieldLength(this.extent);
        this.extent += this.currentFieldLen > 250 ? 3 : 1;
        return true;
    }

    public int getCurrentFieldLen() {
        return this.currentFieldLen;
    }

    public int getCurrentOffset() {
        return this.extent;
    }

    public void addArg(int n, int n2) {
        ++this.argCount;
    }

    public void addRow(int n) {
        super.putInt2(n, this.extent);
        this.extent += 2;
    }

    public int getFieldLength(int n) {
        byte by = this.getInt1(n);
        if (by <= 250) {
            return by;
        }
        return this.getInt2(n + 1);
    }

    public int putFieldLength(int n, int n2) {
        if (n <= 250) {
            super.putInt1(n, n2);
            return 1;
        }
        super.putInt1(255, n2);
        super.putInt2(n, n2 + 1);
        return 3;
    }

    public void putDefineByte(int n, int n2) {
    }

    public void putBigUnicode(char[] cArray, int n, int n2) {
        int n3 = cArray.length;
        this.extent += this.putFieldLength(n3, this.extent);
        super.putBigUnicode(cArray, this.extent, n3);
        this.extent += n3;
    }

    public void putBytes(byte[] byArray, int n, int n2) {
        int n3 = byArray.length;
        this.extent += this.putFieldLength(n3, this.extent);
        super.putBytes(byArray, this.extent, n3);
        this.extent += n3;
    }

    public void putBytes(byte[] byArray, int n) {
        int n2 = byArray.length;
        this.extent += this.putFieldLength(n2, this.extent);
        super.putBytes(byArray, this.extent);
        this.extent += n2;
    }

    public void putInt1(int n, int n2) {
        int n3 = 1;
        this.extent += this.putFieldLength(n3, this.extent);
        super.putInt1(n, this.extent);
        this.extent += n3;
    }

    public void putInt2(int n, int n2) {
        int n3 = 2;
        this.extent += this.putFieldLength(n3, this.extent);
        super.putInt2(n, this.extent);
        this.extent += n3;
    }

    public void putInt4(int n, int n2) {
        int n3 = 4;
        this.extent += this.putFieldLength(n3, this.extent);
        super.putInt4(n, this.extent);
        this.extent += n3;
    }

    public void putInt8(long l, int n) {
        int n2 = 8;
        this.extent += this.putFieldLength(n2, this.extent);
        super.putInt8(l, this.extent);
        this.extent += n2;
    }

    public int putString(String string, int n, int n2) {
        int n3 = string.length();
        this.extent += this.putFieldLength(n3, this.extent);
        int n4 = super.putString(string, this.extent, n2);
        this.extent += n3;
        return n4;
    }

    public int putString(String string, int n) {
        int n2 = string.length();
        this.extent += this.putFieldLength(n2, this.extent);
        int n3 = super.putString(string, this.extent, n2);
        this.extent += n2;
        return n3;
    }

    public void putStringBytes(byte[] byArray, int n, int n2) {
        int n3 = byArray.length;
        this.extent += this.putFieldLength(n3, this.extent);
        super.putStringBytes(byArray, this.extent, n3);
        this.extent += n3;
    }

    public void putUnicodeBytes(byte[] byArray, int n, int n2) {
        int n3 = byArray.length;
        this.extent += this.putFieldLength(n3, this.extent);
        super.putUnicodeBytes(byArray, this.extent, n3);
        this.extent += n3;
    }

    public void putNull(int n, int n2) {
        super.putInt1(254, this.extent);
        ++this.extent;
        this.addArg(n, n2);
    }

    public StructuredMem putDescriptor(int n, byte[] byArray) {
        int n2 = this.extent + 1;
        this.putBytes(byArray, this.extent);
        return this.mem.getPointer(n2);
    }

    public boolean fillWithOMSReader(Reader reader, int n) throws SQLException {
        throw new NotImplemented();
    }

    public boolean fillWithProcedureReader(Reader reader, short s) throws SQLException {
        throw new NotImplemented();
    }

    public void fillWithOMSReturnCode(int n) throws SQLExceptionSapDB {
        throw new NotImplemented();
    }

    public boolean fillWithOMSStream(InputStream inputStream, boolean bl) throws SQLException {
        throw new NotImplemented();
    }

    public boolean fillWithProcedureStream(InputStream inputStream, short s) throws SQLException {
        throw new NotImplemented();
    }
}

