#include "MyxSQLTreeItem.h"

MyxSQLTreeItem::SubItemList MyxSQLSimpleTreeItem::_empty_list;

MYX_PUBLIC_FUNC std::ostream& operator << (std::ostream& os, const MyxSQLTreeItem& item)
{
  if(item.get_value()[0] != '\0')
  {
    os << "<elem name='" << item.get_name() << "' value='" << item.get_value() << "'>";
  }
  else
  {
    os << "<elem name='" << item.get_name() << "'>";
  }

  if(item.get_subitems()->size() > 0) 
  {
    for(MyxSQLTreeItem::SubItemList::const_iterator it= item.get_subitems()->begin(); it != item.get_subitems()->end(); it++)
    {
      const MyxSQLTreeItem* p_subitem= *it;
      os << *p_subitem;
    }
  }
  os << "</elem>";
  return os;
}

const MyxSQLTreeItem *MyxSQLTreeItem::get_subitem_by_name(const char *name)
{
  for(MyxSQLTreeItem::SubItemList::const_iterator it = _subitems->begin(); it != _subitems->end(); it++) 
  {
    MyxSQLTreeItem *item = *it;
    if(item->name_equals(name)) 
    {
      return item;
    }
  }
  return NULL;
}

const MyxSQLTreeItem *MyxSQLTreeItem::rget_subitem_by_name(const char *name)
{
  for(MyxSQLTreeItem::SubItemList::reverse_iterator it = _subitems->rbegin(); it != _subitems->rend(); it++) 
  {
    MyxSQLTreeItem *item = *it;
    if(item->name_equals(name)) 
    {
      return item;
    }
  }
  return NULL;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////
// MyxSchemaTreeItemHelperBase members

bool MyxSchemaTreeItemHelperBase::check1word(MyxSQLTreeItem *tree, const char *w1)
{
  return tree->name_equals(w1);
}

bool MyxSchemaTreeItemHelperBase::check2words(MyxSQLTreeItem *tree, const char *w1, const char *w2)
{
  if(!tree->name_equals(w1))
  {
    return false;
  }
  const MyxSQLTreeItem *obj= *tree->get_subitems()->begin();
  if(obj != NULL)
  {
    return obj->name_equals(w2);
  }
  return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////
// MyxCreateTableTreeItem members

bool MyxCreateSchemaTreeItem::check(MyxSQLTreeItem *tree)
{
  return check2words(tree, "create", "database");
}

MyxCreateSchemaTreeItem::MyxCreateSchemaTreeItem(MyxSQLTreeItem *tree)
: _item(tree), schema_name(0)
{
  const MyxSQLTreeItem *ident;
  ident= _item->rget_subitem_by_name("ident");
  if(ident == NULL)
  {
    ident= _item->rget_subitem_by_name("quoted_ident");
  }
  schema_name= ident->get_value();
}

MyxCreateSchemaTreeItem::~MyxCreateSchemaTreeItem()
{
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////
// MyxCreateTableTreeItem members

bool MyxCreateTableTreeItem::check(MyxSQLTreeItem *tree)
{
  return check2words(tree, "create", "table");
}

MyxCreateTableTreeItem::MyxCreateTableTreeItem(MyxSQLTreeItem *tree)
: _item(tree), schema_name(0), table_name(0), table_engine(0), row_format(0), next_auto_inc(0), def_collation(0), delay_key_write(0), comment(0), temporary(false)
{
  const MyxSQLTreeItem *table_ident= _item->rget_subitem_by_name("table_ident");
  if(table_ident->get_subitems()->size() == 3)   // ident.ident
  {
    schema_name= (*table_ident->get_subitems()->begin())->get_value();
  } 
  table_name= (*table_ident->get_subitems()->rbegin())->get_value();

  const MyxSQLTreeItem *options= _item->rget_subitem_by_name("create_table_options");
  for(MyxSQLTreeItem::SubItemList::const_iterator it = options->get_subitems()->begin(); it != options->get_subitems()->end(); it++)
  {
    const MyxSQLTreeItem *option= *it;
    MyxSQLTreeItem::SubItemList::const_iterator parts= option->get_subitems()->begin();
    const MyxSQLTreeItem *option1= *parts++;
    const MyxSQLTreeItem *option2= *parts++;

    if(option1->name_equals("engine") || option1->name_equals("type"))
    {
      table_engine= (*option->get_subitems()->rbegin())->get_value();
      continue;
    }
    if(option1->name_equals("row_format")) 
    {
      row_format= (*option->get_subitems()->rbegin())->get_value();
      continue;
    }
    if(option1->name_equals("auto_increment")) 
    {
      next_auto_inc= (*option->get_subitems()->rbegin())->get_value();
      continue;
    }
    if(option1->name_equals("default") && option2->name_equals("collation")) 
    {
      def_collation= (*option->get_subitems()->rbegin())->get_value();
      continue;
    }
    if(option1->name_equals("delay_key_write")) 
    {
      delay_key_write= (*option->get_subitems()->rbegin())->get_value();
      continue;
    }
    if(option1->name_equals("comment")) 
    {
      comment= (*option->get_subitems()->rbegin())->get_value();
      continue;
    }
  }
}

MyxCreateTableTreeItem::~MyxCreateTableTreeItem()
{
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////
// MyxUseSchemaTreeItem members

bool MyxUseSchemaTreeItem::check(MyxSQLTreeItem *tree)
{
  return check1word(tree, "use");
}

MyxUseSchemaTreeItem::MyxUseSchemaTreeItem(MyxSQLTreeItem *tree)
: _item(tree), schema_name(0)
{
  const MyxSQLTreeItem *ident;
  ident= _item->rget_subitem_by_name("ident");
  if(ident == NULL)
  {
    ident= _item->rget_subitem_by_name("quoted_ident");
  }
  schema_name= ident->get_value();
}

MyxUseSchemaTreeItem::~MyxUseSchemaTreeItem()
{
}

extern "C" 
{

void *new_simple_tree_item(const void *name, const void *value)
{
  return new MyxSQLSimpleTreeItem(static_cast<const char *>(name), static_cast<const char *>(value));
}

void *new_tree_item(const void *name, const void *value, void *list)
{
  return new MyxSQLTreeItem(static_cast<const char *>(name), static_cast<const char *>(value), static_cast<MyxSQLTreeItem::SubItemList *>(list));
}

void *new_tree_item_list()
{
  return new MyxSQLTreeItem::SubItemList;
}

extern void delete_tree_item(void *tree_item)
{
  MyxSQLTreeItem* item= static_cast<MyxSQLTreeItem *>(tree_item);
  delete item;
}

void tree_item_list_add(void *tree_item_list, void *tree_item)
{
  if(tree_item == 0)
  {
    return;
  }
  MyxSQLTreeItem::SubItemList *list= static_cast<MyxSQLTreeItem::SubItemList *>(tree_item_list);
  MyxSQLTreeItem* item= static_cast<MyxSQLTreeItem *>(tree_item);
  list->push_back(item);
}

void *new_tree_item_list_reuse(void *tree_item_from)
{
  MyxSQLTreeItem* item_from= static_cast<MyxSQLTreeItem *>(tree_item_from);
  item_from->del_list(false);
  return const_cast<MyxSQLTreeItem::SubItemList *>(item_from->get_subitems());
}

void tree_item_list_add_all(void *tree_item_list, void *tree_item)
{
  MyxSQLTreeItem::SubItemList *list= static_cast<MyxSQLTreeItem::SubItemList *>(tree_item_list);
  MyxSQLTreeItem* item_from= static_cast<MyxSQLTreeItem *>(tree_item);
  item_from->del_list(false);
  list->insert(list->end(), item_from->get_subitems()->begin(), item_from->get_subitems()->end());
}

} // extern "C"

