#pragma once

class GraphNode
{
  int _left, _top, _width, _height;
  int _newleft, _newtop;

public:

  enum Coord { CX, CY };

  GraphNode(const GraphNode& n) : _left(n._left), _top(n._top), _width(n._width), _height(n._height), _newleft(n._newleft), _newtop(n._newtop) {}
  GraphNode(int l, int t, int w = 50, int h = 50) : _left(l), _top(t), _width(w), _height(h), _newleft(l), _newtop(t) {}

  int centerx() const { return _left + (_width >> 1); }
  int centery() const { return _top + (_height >> 1); }

  int left() const { return _left; }
  int top() const { return _top; }
  int width() const { return _width; }
  int height() const { return _height; }

  void setnewleft(int l) { _newleft = l; }
  void setnewtop(int t) { _newtop = t; }

  int newleft() const { return _newleft; }
  int newtop() const { return _newtop; }

  //void setx(int x) { _x = x; }
  //void sety(int y) { _y = y; }
  int coord(Coord c) const { return c == CX ? _left : _top; }
  
  void apply() { _left= _newleft; _top= _newtop; }

  friend bool operator == (const GraphNode& n1, const GraphNode& n2);
  static double distance(const GraphNode& n1, const GraphNode& n2);
};

class GraphEdge
{
  GraphNode& _n1;
  GraphNode& _n2;

public:

  GraphEdge(GraphNode& n1, GraphNode &n2) : _n1(n1), _n2(n2) {}

  bool contains(const GraphNode& n) const { return (n == _n1) || (n == _n2); }
  GraphNode& get_first() const { return _n1; }
  GraphNode& get_other(const GraphNode& n) const { return (n == _n1) ? _n2 : _n1; }
};

class GraphRenderer
{
public:
  typedef std::list<GraphNode *> GraphNodeRefList;
  //typedef std::list<GraphNode> GraphNodeList;
  typedef std::list<GraphEdge> GraphEdgeList;

private:
 
  typedef std::pair<int, int> CoordPair;
  typedef std::set<CoordPair> CoordSet;

  //static const int L = 50;
  static const int K1F = 1;
  static const int K1N = 10;
  static const int K2 = 1000;
  static const int K3 = 1000;

  int _length;  // current zero-resistance edge length
  double _density_ratio, _avg_dist;
  int _left, _top, _right, _bottom; // enclosing rect
  GraphEdgeList _alledges;
  GraphNodeRefList _allnodes;
  GraphNodeRefList _framenodes;  // all frame nodes
  GraphNodeRefList _focusnodes;  // frame focus nodes

  void get_neighbours(const GraphNode& node, GraphNodeRefList& to) const;
  int get_delta(const GraphNode& node, GraphNode::Coord coord) const;

  bool is_focus_node(const GraphNode& node, const GraphNodeRefList& neighbours) const;
  bool is_in_focus_list(const GraphNode& node) const { return std::find(_focusnodes.begin(), _focusnodes.end(), &node) != _focusnodes.end(); }

  void recalc_length(); // edge zero-resistance length 
  void recalc_positions();  // main function to position nodes
  void recalc_outer_rect();
  void rotate_point(int *x, int *y, double matrix[2][2]);
  void rotate();  // make a rotation step after calculating positions, based on total mean square deviation of points relative to a baseline

public:
  GraphRenderer();
  ~GraphRenderer();

  void add_node(GraphNode& node);
  void add_edge(GraphEdge& edge);

  const GraphNodeRefList& get_all_nodes() const { return _allnodes; }
  GraphNodeRefList& get_all_nodes() { return _allnodes; }
  const GraphEdgeList& get_all_edges() const { return _alledges; }

  void move(int dx, int dy);
  void recalc();
  void get_outer_rect(int *left, int *top, int *right, int *bottom);

  // stats
  double get_density_ratio() const { return _density_ratio; }
  int get_length() const { return _length; }
};

