//
//  MAServerInformation.m
//  MySQL Administrator
//
//  Created by Alfredo Kojima on Thu Jun 24 2004.
//  Copyright (c) 2004 MySQL AB. All rights reserved.
//

#import "MAServerInformation.h"

#import "MAdministrator.h"

@implementation MAServerInformation

+ (NSImage*)icon
{
  return [[[NSImage alloc] initWithContentsOfFile: 
    [[NSBundle mainBundle] pathForResource:@"server_info"
                                    ofType:@"png"]] autorelease];
}

+ (NSString*)label
{
  return @"Information";
}

+ (NSString*)toolTip
{
  return @"Information about the connected MySQL server instance.";
}

- (id)initWithOwner: (MAdministrator*)owner
{
  self= [super initWithNibFile: @"ServerInformation" panelOwner: owner];
  
  _defaultFrame= [[self topView] frame];

  return self;
}

- (void)didShow
{
  [self updateStatus];
}
  
  
- (void)updateStatus
{
  NSImage *image;
  NSString *status;
  MYSQL *mysql;
  MYX_USER_CONNECTION *conn;
  
  switch ([_owner serverStatus])
  {
    case 0:
      image= [self loadImage: @"service_status_stopped"];
      status= @"Server is Stopped";
      break;
    case 1:
      image= [self loadImage: @"service_status_running"];
      status= @"Server is Running";
      break;
    default:
      image= [self loadImage: @"service_status_unknown"];
      status= @"Cannot determine server status";
      break;
  }

  [statusImage setImage: image];
  [statusLabel setStringValue: status];
  
  conn= [_owner serverInfo];
  
  if ((mysql= [_owner mysql]))
  {
    MYX_MACHINE_INFO *info;
    
    info= myx_get_server_info(conn, mysql);
    if (info)
    {      
      [serverInfoLabel setStringValue:
        [NSString stringWithFormat:@"%s\r%s\r%s\r%s",
                    info->version?:"", info->network_name?:"", info->IP?:""]];
      myx_free_pc_info(info);
    }
    
    info= myx_get_client_info(mysql);
    if (info)
    {
      [clientInfoLabel setStringValue:
        [NSString stringWithFormat:@"%s\r%s\r%s\r%s\r%s",
                    info->version?:"", info->network_name?:"", 
                         info->IP?:"", info->OS?:"", info->hardware?:""]];
      //XXX check how to retrieve hw info
      myx_free_pc_info(info);
    }

    if (mysql->unix_socket)
    {
      [instanceInfoCaption setStringValue: @"User:\rHost:\rSocket:"];
      [instanceInfoLabel setStringValue: 
        [NSString stringWithFormat:@"%s\r%s\r%i",
                   conn->username?:"", conn->hostname?:"", mysql->unix_socket]];      
    }
    else
    {
      [instanceInfoCaption setStringValue: @"User:\rHost:\rPort:"];
      [instanceInfoLabel setStringValue: 
        [NSString stringWithFormat:@"%s\r%s\r%i",
                   conn->username?:"", conn->hostname?:"", conn->port]];
    }
  }
  else
  {
    [instanceInfoLabel setStringValue: @""];
    [serverInfoLabel setStringValue:@""];
    [clientInfoLabel setStringValue:@""];
  }
}

@end
