//
//  MAHealthGraph.h
//  MySQL Administrator
//
//  Created by Alfredo Kojima on Thu Jul 22 2004.
//  Copyright (c) 2004 MySQL AB. All rights reserved.
//

#import <Foundation/Foundation.h>
#include "myx_admin_public_interface.h"

@class MATimeGraph;

@interface MAHealthGraph : NSObject 
{
@protected  
  MYX_HEALTH_GRAPH *_graphSpec;
  NSString *_exprSrc;
  MYX_COMPILED_EXPRESSION *_expr;
  MYX_VARIABLES *_oldValues;
  MYX_VARIABLES *_values;
  MYX_VARIABLES *_serverValues;
  BOOL _serverValuesChanged;
}

- (id)initWithGraph:(MYX_HEALTH_GRAPH*)graph;

- (void)updateServerVariables:(MYX_VARIABLES*)vars;
- (void)updateValues:(MYX_VARIABLES*)vars;

- (NSView*)view;

- (double)evaluate:(NSString*)s;

- (NSString*)prepareExpression:(NSString*)expr
           serverVariablesOnly:(BOOL)serverOnly;
@end

@class MAMeterGraph;

@interface MALineHealthGraph : MAHealthGraph
{
  NSView *_base;
  MATimeGraph *_graph;
  NSMatrix *_infoMatrix;
  float _min, _max;
  
  NSCell *_cells[4];
  
  MAMeterGraph *_meter;
}

- (id)initWithGraph:(MYX_HEALTH_GRAPH*)graph;
- (void)setGraphAttributes:(MYX_HEALTH_GRAPH*)graph;
- (void)setMeterImage:(NSImage*)image;

- (NSView*)view;
@end


@interface MABarHealthGraph : MAHealthGraph
{
}


@end
