/***********************************************************************
 tquery2.cpp - Same as tquery1.cpp, except that it passes the template
    query parameters in a SQLQueryParms object, instead of separately.
	This is useful when the calling code doesn't know in advance how
	many parameters there will be.  This is most likely because the
	templates are coming from somewhere else, or being generated.

 Copyright (c) 1998 by Kevin Atkinson, (c) 1999-2001 by MySQL AB, and
 (c) 2004-2008 by Educational Technology Resources, Inc.  Others may
 also hold copyrights on code in this file.  See the CREDITS file in
 the top directory of the distribution for details.

 This file is part of MySQL++.

 MySQL++ is free software; you can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published
 by the Free Software Foundation; either version 2.1 of the License, or
 (at your option) any later version.

 MySQL++ is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with MySQL++; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301
 USA
***********************************************************************/

#include "cmdline.h"
#include "printdata.h"

#include <iostream>

using namespace std;

int
main(int argc, char *argv[])
{
	// Get database access parameters from command line
    const char* db = 0, *server = 0, *user = 0, *pass = "";
	if (!parse_command_line(argc, argv, &db, &server, &user, &pass)) {
		return 1;
	}

	try {
		// Establish the connection to the database server.
		mysqlpp::Connection con(db, server, user, pass);

		// Build a template query to retrieve a stock item given by
		// item name.
		mysqlpp::Query query = con.query(
				"select * from stock where item = %0q");
		query.parse();

		// Retrieve an item added by resetdb; it won't be there if
		// tquery* or ssqls3 is run since resetdb.
		mysqlpp::SQLQueryParms sqp;
		sqp << "Nürnberger Brats";
		mysqlpp::StoreQueryResult res1 = query.store(sqp);
		if (res1.empty()) {
			throw mysqlpp::BadQuery("UTF-8 bratwurst item not found in "
					"table, run resetdb");
		}

		// Replace the proper German name with a 7-bit ASCII
		// approximation using a different template query.
		query.reset();		// forget previous template query info
		query << "update stock set item = %0q where item = %1q";
		query.parse();
		sqp.clear();
		sqp << "Nuerenberger Bratwurst" << res1[0][0].c_str();
		mysqlpp::SimpleResult res2 = query.execute(sqp);

		// Print the new table contents.
		print_stock_table(query);
	}
	catch (const mysqlpp::BadQuery& er) {
		// Handle any query errors
		cerr << "Query error: " << er.what() << endl;
		return -1;
	}
	catch (const mysqlpp::BadConversion& er) {
		// Handle bad conversions
		cerr << "Conversion error: " << er.what() << endl <<
				"\tretrieved data size: " << er.retrieved <<
				", actual size: " << er.actual_size << endl;
		return -1;
	}
	catch (const mysqlpp::Exception& er) {
		// Catch-all for any other MySQL++ exceptions
		cerr << "Error: " << er.what() << endl;
		return -1;
	}

	return 0;
}
