<?  ##############################################
   ### MySource ------------------------------###
  ##- Include Files ------ PHP4 --------------##
 #-- Copyright Squiz.net ---------------------#
##############################################
## This file is subject to version 1.0 of the
## MySource License, that is bundled with
## this package in the file LICENSE, and is
## available at through the world-wide-web at
## http://mysource.squiz.net/
## If you did not receive a copy of the MySource
## license and are unable to obtain it through
## the world-wide-web, please contact us at
## mysource@squiz.net so we can mail you a copy
## immediately.
##
## File: include/report.inc
## Desc: A wizard that updates all the virtual paths
## $Source: /home/cvsroot/xtras/wizards/update_virtual_paths/update_virtual_paths.inc,v $
## $Revision: 1.1.2.3 $
## $Author: gsherwood $
## $Date: 2002/11/14 04:50:45 $
#######################################################################
global $INCLUDE_PATH;
include_once("$INCLUDE_PATH/wizard.inc");
#---------------------------------------------------------------------#

/**
* Update Virtual Paths Wizard
* A wizard that updates all the virtual paths to be either the page short name
* or the page name. This wizard works on a web system, site, or page
* level.
*
* @access public
* @package Wizards
*/
class Update_virtual_paths extends Wizard {
	
	/**
	* The description of the wizard
	* @var string
	*/
	var $report_desc = 'Automatically set virtual paths';

	/**
	* An array of levels that the wizard is compatible with
	* @var array
	*/
	var $compatible_with = array('site','page','web');

	/**
	* An array of default parameter set options for the wizard
	* @var array
	*/
	var $parameters = array('source' => 'short_name');

	
	/**
	* Constructor
	* @param	object &$asset This is the current asset
	* @returns	object Update_virtual_paths
	* @access	public
	*/
	function Update_virtual_paths (&$asset) {	
		Wizard::Wizard($asset);
	}


	/**
	* This function does all the processing
	* @param  object &$backend A reference to the wizard backend object
	* @access public
	*/
	function process_wizard(&$backend) {

		$web_system = &$this->get_web_system();

		if ($this->asset_type == 'web') {
			# we need to do this for all sites
			$sites = &$web_system->get_editable_sites();
			$page_index = array();
			foreach ($sites as $siteid => $name) {
				$site = $web_system->get_site($siteid);
				$page_index = array_merge($page_index,array_keys($site->get_page_index()));
			}
		} else if ($this->asset_type == 'page') {
			$page_index = &$this->caller->get_all_subpageids();
			array_push($page_index,(int)$this->caller->id);
		} else {
			$page_index = &$this->caller->get_page_index();
			$page_index = array_keys($page_index);
		}
	
		$this->process_paths($this->parameters['source'], $page_index);
	}


	/**
	* This function does the actual updating of virtual paths for the given pageids
	*
	* The number of pages that have been checked are returned
	*
	* @param	string	$type		Defines whether the page name or short 
	*								name is used for the updating of the virtual path
	* @param	array	$page_index An array of pageid's that we want to update the 
	*								virtual paths for
	* @return	int
	* @access	public
	*/
	function process_paths($type, $page_index){
		$web_system = &$this->get_web_system();

		$counter = 0;
		foreach ($page_index as $pageid){
			# stopping weird bug 
			if ($pageid == 0) { continue; }

			$page = &$web_system->get_page($pageid);

			# get the name that we want to use to convert the virtual path
			switch ($type){
				case 'name':
					$name = $page->name;
					if ($name == '') $name = $page->short_name;
					if ($name == ''){
						?><p>The virtual path could not be set for page: <?=$pageid;?> as there is no name to apply.</p><?
						continue;
					}
					break;

				default:
					$name = $page->short_name;
					if ($name == '') $name = $page->name;
					if ($name == ''){
						?><p>The virtual path could not be set for page: <?=$pageid;?> as there is no name to apply.</p><?
						continue;
					}
			}
			
			$dirs_list = array($this->clean_up_path($name));
			$page->update_dirs($dirs_list);

			$counter++;
		}
		?><b>Pages checked: <?=$counter;?></b><?
		return $counter;
	}

	/**
	* Cleans up the sting that is going to be the virtual path
	*
	* The function cleans the string by removing leading and trailing
	* whitespace and converting any interior spaces to '_'s
	*
	* @param	string $name The string we want to clean up
	* @return	string
	* @access	public
	*/
	function clean_up_path($name){
		$name = trim($name);
		$name = str_replace(' ', '_', $name);
		$name = strtolower($name);

		return $name;
	}
}

?>