<?php
error_reporting(0);
set_time_limit(90);

$PHP_VERSION = "4.2.0";

$DEFAULT_CONFIG = array (
	"DefaultFrontendLanguage"	=> "en",
	"DefaultCharacterSet"		=> "iso-8859-1",
	"MaxLoginAttempts"		=> "3",
	"MaxIdleTime"			=> "6000",
	"SuperUsers"			=> "root",
	"WebMasters"			=> "root",
	"AuthenticationType"	=> "mysql include/user.inc"
);

$ALLOWED_BLANK = array (
	"WebDatabase" => array (
		"password"
	),
	"UserDatabase" => array (
		"password"
	)
);

function gpc_stripslashes($var) {
	if (get_magic_quotes_gpc()) {
		$var = stripslashes($var);
	}
	return $var;
}

/*
	Check the PHP Version, and the INI file settings before continuing. Not much point unless they are right. :)
*/

if (!minimum_version($PHP_VERSION)) {
	echo "We need PHP Version ".$PHP_VERSION." or higher to use MySource. Download a newer version from <a href=\"http://www.php.net/\">http://www.php.net/</a>, install that, and try again.<br>";
	exit;
}
if (!check_ini_file()) {
	echo "MySource uses both Short Tags and Register Globals. These need to be activated before running MySource. Please edit your php.ini (usually located either in /etc/php.ini, /usr/local/apache/etc/php.ini, or c:\&lt;windows path&gt;\php.ini (windows path can be windows, winnt, win2k etc).<br>";
	exit;
}

function check_ini_file() {
	$reg_globals = ini_get("register_globals");
	$short_tag = ini_get("short_open_tag");
	if ($reg_globals == 0 || $short_tag == 0) {
		return false;
	} else {
		return true;
	}
}

function minimum_version($vercheck) {
	$minver = explode(".", $vercheck);
	$curver = explode(".", phpversion());
	if (($curver[0] < $minver[0]) || (($curver[0] == $minver[0]) && ($curver[1] < $minver[1])) || (($curver[0] == $minver[0]) && ($curver[1] == $minver[1]) && ($curver[2][0] < $minver[2][0]))) {
		return false;
	} else {
		return true;
	}
}

function find_sql($dir,$file) {
	# find files from a specified directory.
	if(file_exists("$dir/$file")) {
		return "$dir/$file";
	}
	if(!$d = opendir($dir)) {
		echo "Unable to open Directory: $dir".__FILE__.__LINE__."<br>";
		return false;
	}

	$result = array();
	while($f = readdir($d)) {
		if (is_dir("$dir/$f") && $f[0] != "." && $f != "CVS") {
			$result[$f] = find_sql("$dir/$f",$file);
		}
	}
	closedir($d);
	return $result;
}

function show_break() {
?>
	<tr>
		<td colspan="2">
			<hr width="95%" size="1" noshade>
		</td>
	</tr>
<?php
} # end show_break

function config_form($msg="Configure MySource") {
?>
<form name="configmysource" method="post" action="<?php echo $_SERVER['PHP_SELF']?>?action=configure">
	<table border="0" cellspacing="0" cellpadding="5">
		<tr>
			<td colspan="2" align="left">
				<?php echo $msg?>
			</td>
		</tr>
		<tr>
			<td valign="top">
				1. Where is MySource installed on this system?&nbsp;
			</td>
			<td valign="top">
				<input type="text" name="MySource_Install_Location" size="30" value="<?php echo gpc_stripslashes($_POST['MySource_Install_Location'])?>">
			</td>
		</tr>
		<tr>
			<td valign="top">
				2. Please enter a System Name:&nbsp;
			</td>
			<td valign="top">
				<input type="text" name="System_Name" size="30" value="<?php echo gpc_stripslashes($_POST['System_Name'])?>">
			</td>
		</tr>
		<? show_break(); ?>
		<tr>
			<td valign="top">
				3. Please enter a Web Database Name:&nbsp;
			</td>
			<td valign="top">
				<input type="text" name="Web_Data_base[db]" size="30" value="<?php echo (!$_POST['Web_Data_base']['db']) ? "mysource" : gpc_stripslashes($_POST['Web_Data_base']['db']) ?>">
			</td>
		</tr>
		<tr>
			<td valign="top">
				4. Please enter a Web Database Host:&nbsp;
			</td>
			<td valign="top">
				<input type="text" name="Web_Data_base[host]" size="30" value="<?php echo (!$_POST['Web_Data_base']['host']) ? "localhost" : gpc_stripslashes($_POST['Web_Data_base']['host']) ?>">
			</td>
		</tr>
		<tr>
			<td valign="top">
				5. Please enter a Web Database Username:&nbsp;
			</td>
			<td valign="top">
				<input type="text" name="Web_Data_base[user]" size="30" value="<?php echo gpc_stripslashes($_POST['Web_Data_base']['user']) ?>">
			</td>
		</tr>
		<tr>
			<td valign="top">
				6. Please enter your Web Database Password:&nbsp;
			</td>
			<td valign="top">
				<input type="password" name="Web_Data_base[password]" size="30" value=""><br>
			</td>
		</tr>
		<? show_break(); ?>
		<tr>
			<td valign="top">
				7. Please enter a User Database Name:<br>This can be the same as the Web Database Name.&nbsp;
			</td>
			<td valign="top">
				<input type="text" name="User_Data_base[db]" size="30" value="<?php echo (!$_POST['User_Data_base']['db']) ? "mysource" : gpc_stripslashes($_POST['User_Data_base']['db']) ?>">
			</td>
		</tr>
		<tr>
			<td valign="top">
				8. Please enter a User Database Host:&nbsp;
			</td>
			<td valign="top">
				<input type="text" name="User_Data_base[host]" size="30" value="<?php echo (!$_POST['User_Data_base']['host']) ? "localhost" : gpc_stripslashes($_POST['User_Data_base']['host']) ?>">
			</td>
		</tr>
		<tr>
			<td valign="top">
				9. Please enter a User Database Username:&nbsp;
			</td>
			<td valign="top">
				<input type="text" name="User_Data_base[user]" size="30" value="<?php echo gpc_stripslashes($_POST['User_Data_base']['user']) ?>">
			</td>
		</tr>
		<tr>
			<td valign="top">
				10. Please enter your User Database Password:&nbsp;
			</td>
			<td valign="top">
				<input type="password" name="User_Data_base[password]" size="30" value=""><br>
			</td>
		</tr>
		<? show_break(); ?>
		<tr>
			<td valign="top">
				11. Please enter a MySource Web Master Email Address:&nbsp;
			</td>
			<td valign="top">
				<input type="text" name="Web_Master_Email" size="30" value="<?php echo gpc_stripslashes($_POST['Web_Master_Email']) ?>">
			</td>
		</tr>
		<tr>
			<td valign="top">
				12. Please enter a MySource Root Password:&nbsp;
				<p align="center">(Confirm):</p>
			</td>
			<td valign="top">
				<input type="password" name="Root[password]" size="30" value=""><br>
				<input type="password" name="Root[password_confirmation]" size="30" value="">
			</td>
		</tr>
		<tr>
			<td colspan="2" align="center">
				<input type="submit" value=" Submit ">&nbsp;&nbsp;<input type="reset" value=" Clear ">
			</td>
		</tr>
	</table>
</form>
<?php
} # end function config_form()

function generate_config($location) {
	global $DEFAULT_CONFIG;
	$config_file = "";
	$FIELDS_NOT_IN_CONFIG = array ("MySource_Install_Location","Root");
	reset($_POST);
	while(list($key,$data) = each($_POST)) {
		if (!in_array($key,$FIELDS_NOT_IN_CONFIG)) {
			if (!is_array($data)) {
				$config_file .= gpc_stripslashes(str_replace("_","",$key)." ".$data."\n");
			} else {
				$config_file .= gpc_stripslashes(str_replace("_","",$key));
				reset($data);
				while(list($subk,$subdata) = each($data)) {
					if (!preg_match("/confirmation/",$subk)) {
						$config_file .= gpc_stripslashes(" ".$subdata);
					}
				}
				$config_file .= "\n";
			}
		}
	}
	reset($DEFAULT_CONFIG);
	while(list($key,$data) = each($DEFAULT_CONFIG)) {
		$config_file .= gpc_stripslashes($key." ".$data."\n");
	}

	$config_path = $location."conf/mysource.conf";
	if (is_file($config_path)) {
		rename($config_path,$location."conf/mysource.conf.old");
	}
	$fp = fopen($config_path,"w");
	fputs($fp,$config_file);
	fclose($fp);
	$location = str_replace("\/\/","\/",$location);
	global $SERVER_ADDR, $SERVER_NAME;
	$apache_config = "<VirtualHost ".$SERVER_ADDR.">\n";
	$apache_config .= "\tPort 80\n";
	$apache_config .= "\tServerAdmin ".$_POST['Web_Master_Email']."\n";
	$apache_config .= "\tDocumentRoot \"".$location."web\"\n";
	$apache_config .= "\tServerName ".$SERVER_NAME."\n";
	$apache_config .= "\t<Directory \"".$location."web\">\n";
	$apache_config .= "\t\tAllowOverride All\n";
	$apache_config .= "\t\tOrder allow,deny\n";
	$apache_config .= "\t\tAllow from all\n";
	$apache_config .= "\t</Directory>\n";
	$apache_config .= "\t<Directory \"".$location."squizlib\">\n";
	$apache_config .= "\t\tAllowOverride All\n";
	$apache_config .= "\t\tOrder allow,deny\n";
	$apache_config .= "\t\tAllow from all\n";
	$apache_config .= "\t</Directory>\n";
	$apache_config .= "\t<Directory \"".$location."data/unrestricted\">\n";
	$apache_config .= "\t\tAllowOverride All\n";
	$apache_config .= "\t\tOrder allow,deny\n";
	$apache_config .= "\t\tAllow from all\n";
	$apache_config .= "\t</Directory>\n";
	$apache_config .= "\tAliasMatch \"^(/.*)?/__lib(.*)$\"       \"".$location."web/__lib\$2\"\n";
	$apache_config .= "\tAliasMatch \"^(/.*)?/__squizlib(.*)$\"  \"".$location."squizlib\$2\"\n";
	$apache_config .= "\tAliasMatch \"^(/.*)?/__data(.*)$\"      \"".$location."data/unrestricted\$2\"\n";
	$apache_config .= "\t# Any HTTP request made at this domain followed by '/_edit'\n";
	$apache_config .= "\t# will open the editing interface for that site, page etc.\n";
	$apache_config .= "\tAliasMatch \"^(/.*)?/_edit(.*)$\"       \"".$location."web/edit\$2\"\n";
	$apache_config .= "\t# Any *other* HTTP request made at this domain gets handled\n";
	$apache_config .= "\t# by the MySource web frontend controller script.\n";
	$apache_config .= "\tAliasMatch \"^(/.*)?$\"                 \"".$location."web/index.php\"\n\n";
	$apache_config .= "\t# Example alternative at a particular subdirecory of this domain:\n";
	$apache_config .= "\t#AliasMatch \"^/path/to/mysource/section(/.*)?/__lib(.*)$\"       \"".$location."web/__lib\$2\"\n";
	$apache_config .= "\t#AliasMatch \"^/path/to/mysource/section(/.*)?/__squizlib(.*)$\"  \"".$location."squizlib\$2\"\n";
	$apache_config .= "\t#AliasMatch \"^/path/to/mysource/section(/.*)?/__data(.*)$\"      \"".$location."data/unrestricted\$2\"\n";
	$apache_config .= "\t#AliasMatch \"^/path/to/mysource/section(/.*)?/_edit(.*)$\"       \"".$location."web/edit\$2\"\n";
	$apache_config .= "\t#AliasMatch \"^/path/to/mysource/section(/.*)?$\"                 \"".$location."web/index.php\"\n";
	$apache_config .= "\t</VirtualHost>";
	echo "Configuration generated successfully.<br>";
	echo "Please check & add the following to your apache configuration file, and restart the apache server:<br><br>";
	echo nl2br(htmlspecialchars($apache_config));
}

function check_mysource_location($location) {
	if (!is_dir($location)) {
		return "This base directory doesn't exist<br>";
	}
	if (!is_dir($location."cache")) {
		if (!mkdir($location."cache",0775)) {
			return "Couldn't create the cache directory<br>";
		}
	}
	if (!is_dir($location."data")) {
		if (!mkdir($location."data",0775)) {
			return "Couldn't create the data directory<br>";
		}
	}
	$LINKS_TO_MAKE = array (
		"restricted/web",
		"restricted/site/design",
		"restricted/page",
		"restricted/users",
		"restricted/user",
		"unrestricted/web",
		"unrestricted/site/design",
		"unrestricted/page",
		"unrestricted/users",
		"unrestricted/user",
	);
	reset($LINKS_TO_MAKE);
	while(list($k,$link) = each($LINKS_TO_MAKE)) {
		make_directory($location."data/".$link);
	}

	$ob_file = $location."squizlib/object/object.inc";
	$db_file = $location."squizlib/db/db.inc";

	if (is_file($ob_file) && is_file($db_file)) {
		include_once($ob_file);
		include_once($db_file);
	} else {
		return "Couldn't find the SquizLib directory.<br>";
	}
	return true;
}

function db_connect($dbase,$user,$host,$pw) {
	$db = new Db();
	$db->error_reporting(0);
	$db->connect($dbase,$user,$pw,$host);
	return $db;
}

function db_check($dbase,$user,$host,$pw) {
	$db = db_connect("mysql",$user,$host,$pw);
	if (!$db->ptr) {
		return $db->error_msg;
	} else {
		$db_check = $db->select("USE $dbase");
		if (!preg_match("/unknown database '$dbase'/i",$db_check)) {
			$db->select("CREATE DATABASE $dbase");
			return true;
		} else {
			return $db->error_msg;
		}
	}
}

function import_sql($db,$array) {
	# this was needed for the NT version, on mine, was very slow.
	set_time_limit(90);
	reset($array);
	while(list($k,$value) = each($array)) {
		if (is_array($value)) {
			import_sql($db,$value);
		}
		if ($value != "" && (!is_array($value))) {
			if (!$fp = fopen($value,"r")) {
				return false;
			}

			$db->error_reporting(0);
			$fcontents = file ($value);
			while (list ($line_num, $line) = each ($fcontents)) {
				$sql .= $line;
			}
			$queries = explode(";",$sql);
			while (list ($qid,$query) = each($queries)) {
				$db->select($query);
			}
		}
	}
}

function make_directory($dirname) {
	$subdirs=explode("/",$dirname);
	# element 0 is empty IF it's a location like "/home/mysource/.."
	# If it's something like "c:\mysource" for a windows installation,
	# element 0 is "c:". so we add it anyway since 9/10 times it will be blank.
	reset($subdirs);
	while(list($k,$subd) = each($subdirs)) {
		if ($k == 1) {
			$base = $subdirs[0] . "/";
		}
		$base .= $subd . "/";
		if (!is_dir($base)) {
			mkdir($base,0775);
		}
	}
}

?>
<html>
	<head>
		<title>Configure MySource</title>
		<style>
			p,body,td{
				font-family: verdana,arial;
				font-size: 12px;
			}
		</style>
	</head>
	<body background="" bgcolor="#FFFFFF">

	<?php
	switch ($action) {
		case "configure":
			$error_messages = array();
			reset($_POST);
			while(list($k,$data) = each($_POST)) {
				if (is_array($data)) {
					reset($data);
					while(list($subk,$subdata) = each($data)) {
						$blank_key = $ALLOWED_BLANK[str_replace("_","",$k)];
						if ( ($subdata == "") && (!in_array($subk,$blank_key)) ) {
							$error_messages[] = str_replace("_"," ",$k)." ".str_replace("_"," ",$subk);
						} else {
							if (preg_match("/confirmation/i",$subk)) {
								if ($data['password'] != $data['password_confirmation']) {
									$error_messages[] = "Passwords for ".str_replace("_"," ",$k)." do not match.";
								} # end password check.
							} # end if
						} # end if data blank or data == password.
					} # end while
				} else {
					if ($data == "" && (!in_array($k,$ALLOWED_BLANK))) {
						$error_messages[] = str_replace("_"," ",$k);
					} # end if
				} # end if data not an array
			} # end while
			if ($error_messages[0] != "") {
				$error_message = "You must fill in or check:<br>";
				reset($error_messages);
				while(list($eid,$error) = each($error_messages)) {
					$error_message .= " - ".$error."<br>";
				}
				config_form($error_message);
				exit;
			} else {
				$location = gpc_stripslashes(str_replace("\\","/",$_POST['MySource_Install_Location']));
				# If there are no other errors, we check that the mysource_install_location actually exists, and is available to us..
				if (substr($location,-1) != "/") {
					$location .= "/";
				}
				$check_location = check_mysource_location($location);
				if ($check_location != 1) {
					config_form($check_location);
					exit;
				}
				$web_db = $_POST['Web_Data_base']['db'];
				$web_user = $_POST['Web_Data_base']['user'];
				$web_host = $_POST['Web_Data_base']['host'];
				$web_pw = $_POST['Web_Data_base']['password'];
				$user_db = $_POST['User_Data_base']['db'];
				$user_user = $_POST['User_Data_base']['user'];
				$user_host = $_POST['User_Data_base']['host'];
				$user_pw = $_POST['User_Data_base']['password'];

				$web_db_check = db_check($web_db,$web_user,$web_host,$web_pw);
				if ($web_db_check != 1) {
					$error_message .= "Couldn't create the Web Database.<br>Please check the error message below:<br>";
					$error_message .= "&nbsp;&nbsp;".$web_db_check."<br>";
				} else {
					$WEB_DB = db_connect($web_db,$web_user,$web_host,$web_pw);
				}

				if ($user_db != $web_db) {
					$user_db_check = db_check($user_db,$user_user,$user_host,$user_pw);
					 if ($user_db_check != 1) {
						$error_message .= "Couldn't create the User Database.<br>Please check the error message below:<br>";
						$error_message .= "&nbsp;&nbsp;".$user_db_check."<br>";
					 } else {
						$USER_DB = db_connect($user_db,$user_user,$user_host,$user_pw);
					 }
				} else {
					$USER_DB = $WEB_DB;
				}

				if ($error_message) {
					config_form($error_message);
					exit;
				} else {
					# Now we import the data, and generate the apache config.
					$sql_files = find_sql($location,"mysql_web.sql");
					import_sql($WEB_DB,$sql_files);
					$sql_files = find_sql($location,"mysql_users.sql");
					import_sql($USER_DB,$sql_files);
					$root_user_sql = "INSERT INTO user (userid, login, password, firstname) VALUES (1, 'root', password('".$_POST['Root']['password']."'), 'root')";
					$USER_DB->insert($root_user_sql);

					$sql_files = find_sql($location,"mysql_web_populate.sql");
					import_sql($WEB_DB,$sql_files);
					$sql_files = find_sql($location,"mysql_users_populate.sql");
					import_sql($USER_DB,$sql_files);
					generate_config($location);
				}
			}

		break;
		default:
			config_form();
	} # end switch
	?>

	</body>
</html>
