<?  ##############################################
   ### MySource ------------------------------###
  ##- Include Files ------ PHP4 --------------##
 #-- Copyright Squiz.net ---------------------#
##############################################
## This file is subject to version 1.0 of the
## MySource License, that is bundled with
## this package in the file LICENSE, and is
## available at through the world-wide-web at
## http://mysource.squiz.net/
## If you did not receive a copy of the MySource
## license and are unable to obtain it through
## the world-wide-web, please contact us at
## mysource@squiz.net so we can mail you a copy
## immediately.
##
## File: include/user.inc
## Desc: An individual user
## $Source: /home/cvsroot/mysource/include/user.inc,v $
## $Revision: 2.9.2.14 $
## $Author: gsherwood $
## $Date: 2003/01/06 03:40:29 $
#######################################################################
#---------------------------------------------------------------------#


class User extends UsersObject {

	# Static
	var $web_statii = array("A" => "Active", "L" => "Locked", "E" => "Account Expired", "P" => "Pending Approval");

	var $data_path; # Path to a directory where a user's stuff can be stored

	var $id;
	var $login;
	var $password; # Encrypted
	var $firstname;
	var $surname;
	var $email;
	var $mobile_no;
	var $created_date;
	var $expiry_date;
	var $web_status;
	var $comments;

	var $affiliations; # An array of links to organisations
	var $placements;   # An array of links to locatinos

	 ##############################
	# Constructor
	function User($userid='') {

		UsersObject::UsersObject();

		 #################################################
		# Load the user information if an id is specified
		if ($userid) {
			return $this->load($userid);
		}
	}



	 ######################################################################
	# Create a new user record in the database and load it into this object
	function create($login='',$organisationid=0, $title='', $blank_password='') {
		$db = &$this->users_system->db;
		$login = strtolower(eregi_replace("[^a-z0-9\_]+","",$login));
		if (strlen($login) < 2) {
			return "Unable to create user: New login must be at least two characters: '$login'";
		} elseif ($name = $db->single_element("SELECT concat(firstname,' ',surname) FROM user WHERE login='".addslashes($login)."'")) {
			return "Unable to create user: login already exists";
		} else {
			if(!$blank_password) $password = random_password(8);
			else $password = '';
			$userid = $db->insert("INSERT INTO user (login,password,firstname,web_status,created_date) VALUES ('".addslashes($login)."',password('".addslashes($password)."'),'".addslashes($login)."','A',now())");
			$message = "New user \"$login\" created.\n\nIMPORTANT\nNew Password is:  $password\n\nThis can, however, be changed.\n\nMake sure to set the user's correct email address.";
			$this->load($userid);

			# Make directory for this user's account.
			$old_umask = umask(0);
			if (!create_directory($this->data_path)) {
				$this->delete();
				return "Unable to create user directory.";
			}

			if ($organisationid && $title) {
				$message .= "\n\n".$this->add_affiliation($organisationid,$title);
			}
			return $message;
		}
	}


	 ################################################
	# Loads the user details, from cache or database
	function load($userid='') {

		if ($userid <= 0 && !($userid = $this->id)) { # Tries "re"loading
			$this->_set_error("Attempt to load user information without a valid userid.",__FILE__,__LINE__);
			$this = new User();
			return false;
		}

		 ###############################################
		# Check the cache - but remember where mum is !
		if ($this->load_from_cache($userid)) {
			return $userid;
		}

		 #################
		# Check the cache
		if ($this->load_from_cache($userid)) {
			$this->data_path = get_data_path(true, "user/$this->id");
			return $userid;
		}

		 ########################
		# Load from the database
		$query = "SELECT userid,login,password,firstname,surname,email,mobile_no,created_date,expiry_date,web_status,comments FROM user WHERE userid='$userid'";
		list(
			$this->id,
			$this->login,
			$this->password,
			$this->firstname,
			$this->surname,
			$this->email,
			$this->mobile_no,
			$this->created_date,
			$this->expiry_date,
			$this->web_status,
			$this->comments
			) = $this->users_system->db->single_row($query);

		if (!$this->id) { # EEk! Clear.
			$this = new User();
			return false;
		}

		/*
			if we're the logged in person, reset *some* of the session variables.
			bulkmail and other user extensions use the session variables,
			but if we've just changed our details they still have the old ones!
			only these are being reset because
				(a) changing password will log you out :P
				(b) other extensions might put extra info in here somewhere
		*/
		$session = &get_mysource_session();
		if ($this->id == $session->user->id) {
			$session->user->firstname = $this->firstname;
			$session->user->surname = $this->surname;
			$session->user->email = $this->email;
		}

		 ##############################
		# Remember where we put things
		$this->data_path = get_data_path(true, "user/$this->id");

		$query = "SELECT a.organisationid, a.title, a.answers FROM affiliation a, organisation o LEFT JOIN organisation o2 ON o.parentid=o2.organisationid WHERE o.organisationid=a.organisationid AND a.userid='$userid' ORDER BY o.name, o2.name";

		$this->affiliations = $this->users_system->db->associative_array($query);

		$query = "SELECT wa.locationid, concat(l.s_address,'\n',l.s_suburb,' ',l.s_state,' ',l.s_postcode) AS address, l.s_countryid as countryid, wa.direct_phone, wa.direct_fax FROM placement wa, location l WHERE l.locationid=wa.locationid AND wa.userid='$userid' ORDER BY l.s_countryid,l.s_state";

		$this->placements = $this->users_system->db->associative_array($query);

		 ############################
		# Save to the cache
		$this->save_to_cache($userid);

		return $userid;
	}

	 ###################################################################################
	# Takes a login and password, does a verification, and loads the user if successful
	function load_with_login($login='', $password='') {
		if($login == 'root') {
			$userid = $this->users_system->db->single_element("SELECT userid FROM user WHERE login='root' AND password=password('".addslashes($password)."')");
		} else {
			$authentication = &$this->users_system->get_authentication();
			$userid = $authentication->get_userid($login,$password);
		}

		if ($userid <= 0 || !$this->load($userid)) {
			return false;
		} else if (!user_root($this->id) && $this->web_status != 'A') {
			return false;
		} else {
			return true;
		}
	}


	 ######################################################
	# Does the currently logged in user have write access?
	function write_access() {
		$managed_organisationids = &$this->users_system->get_managed_organisationids();
		return (
				superuser("user") ||
				count(
					array_intersect(
						array_keys($this->affiliations),
						$managed_organisationids
					)
				)
			);
	}

	 ###################################################
	# May the currently logged in user delete this user?
	# Only if they manage all the organisations they belong to
	function delete_access() {
		$session = &get_mysource_session();
		if($session->user->id == $this->id) return false;
		if($this->id == 1) return false;
		if (superuser('user')) return true;
		if (!empty($this->affiliations)) { # You'd better manage all their affiliations
			$managed_organisationids = &$this->users_system->get_managed_organisationids();
			foreach($this->affiliations as $orgid => $data) {
				if (!in_array($orgid,$managed_organisationids)) return false; # Fail
			}
			return true; # Pass
		}
		return false; # A lone user - no affiliations !  you have to be a superuser
	}


	 ########################################
	# Change the expiry date of this user
	function set_web_status($web_status='') {
		if($web_status == $this->web_status) return "";
		if(!ereg("[ALEP]",$web_status)) {
			return "Web Status may only be either A, L, or E.";
		}
		# if account has been unlocked send an email to admin and to the user informing them of this
		/*
		if($this->web_status=='L' && $web_status =='A') {
			$system_config = &get_system_config();
			$string = "The web account '$this->login' and (ID: $this->id) has been unlocked.";
			$string2 = "The System Administrator has UNLOCKED your web account.";
			mail($system_config->webmaster_email, "$system_config->system_name web account $this->login unlocked", $string,  "From:$system_config->webmaster_email");
			if($email) {
				mail($email, "$system_config->system_name web account $this->login unlocked", $string2, "From: $system_config->webmaster_email");
			}
		}
		*/
		$this->web_status = $web_status;
		$this->users_system->db->update("UPDATE user SET web_status='$this->web_status' WHERE userid='$this->id'");
		$this->clear_cache($this->id);
		return "Web Status set to {$this->web_statii[$web_status]}.";
	}

	 ########################################
	# Change the expiry date of this user
	function set_expiry_date($expiry_date='') {
		if ($expiry_date == $this->expiry_date) return "";
		$now = date("Y-m-d");
		if($now >= $expiry_date && $expiry_date != '0000-00-00' && $this->web_status == 'A') {
			$system_config = &get_system_config();
			$message = $this->set_web_status("E")."\n";
			$string = "Your $system_config->system_name web account with login $this->login has expired. Please reply to this email if there is any reason this account must stay active.";
			mail($this->email, "$system_config->system_name web account $login expired", $string, "From: $system_config->webmaster_email");
		} else if($this->web_status =='E' && ($now < $expiry_date || $expiry_date=='0000-00-00')) {
			$expiry_date = $now;
		}
		$this->expiry_date = $expiry_date;
		$this->users_system->db->update("UPDATE user SET expiry_date='$this->expiry_date' WHERE userid='$this->id'");
		$this->clear_cache($this->id);
		if($expiry_date == "0000-00-00") $expiry_date = "never";
		return $message."Expiry date set to $expiry_date";
	}


	 ########################################
	# Change the name of the user
	function set_name($firstname='', $surname='') {
		if ($firstname == $this->firstname && $surname == $this->surname) return "";
		if ($firstname == '' && $surname == '') $firstname = $this->login;
		$this->firstname = $firstname;
		$this->surname = $surname;
		$this->users_system->db->update("UPDATE user SET firstname='".addslashes($this->firstname)."', surname='".addslashes($this->surname)."' WHERE userid='$this->id'");
		$this->clear_cache($this->id);
		return "Name changed to ".$this->name();
	}

	 ########################################
	# Change the mobile number of the user
	function set_mobile_no($mobile_no='') {
		if ($mobile_no == $this->mobile_no) return "";
		$this->mobile_no = $mobile_no;
		$this->users_system->db->update("UPDATE user SET mobile_no='".addslashes($this->mobile_no)."' WHERE userid='$this->id'");
		$this->clear_cache($this->id);
		return "Mobile no changed to $mobile_no";
	}

	 ########################################
	# Change the login of the user
	function set_login($login='') {
		$login = strtolower(eregi_replace("[^a-z0-9\_]+","",$login));
		if ($login == $this->login) return "";
		if($this->id == 1) return "Cannot change root's login.";
		if(strlen($login) < 2)  return "Login too short, remains unchanged.";
		if(strlen($login) > 64) return "Login too long, remains unchanged.";
		if ($name = $this->users_system->db->single_element("SELECT concat(firstname,' ',surname) FROM user WHERE login='".addslashes($login)."'")) {
			return "Somebody already has this login, login remains unchanged.";
		}
		# if the user is a superuser, web master or user master, we need to remove their
		# old login and add there new one in
		$system_config = &get_system_config();
		$superuser = false;
		$superuser_web = false;
		$superuser_user = false;
		if (in_array($this->login,$system_config->superusers['all'])) {
			$superuser = true;
			$system_config->delete_superuser($this->login);
		}
		if (in_array($this->login,$system_config->superusers['web'])) {
			$superuser_web = true;
			$system_config->delete_web_master($this->login);
		}
		if (in_array($this->login,$system_config->superusers['user'])) {
			$superuser_user = true;
			$system_config->delete_user_master($this->login);
		}

		$this->login = $login;
		$this->users_system->db->update("UPDATE user SET login='".addslashes($this->login)."' WHERE userid='$this->id'");
		$this->clear_cache($this->id);

		if ($superuser) $system_config->add_superuser($this->login);
		if ($superuser_web) $system_config->add_web_master($this->login);
		if ($superuser_user) $system_config->add_user_master($this->login);

		$system_config->conf_updated();
		return "Login changed to '$login'.";
	}

	 ########################################
	# Change the login of the user
	function set_email($email='') {
		if ($email == $this->email) return "";
		$email = trim($email);
		if(!valid_email($email)) {
			return "Email remains unchanged: invalid email address.";
		}
		$this->email = $email;
		$this->users_system->db->update("UPDATE user SET email='".addslashes($this->email)."' WHERE userid='$this->id'");
		$this->clear_cache($this->id);
		return "Email address changed to $email";
	}


	 ########################################
	# Change the login of the user
	function set_password($password='',$verification='') {
		if(!$password) return "";
		if($verification && $password != $verification) return "Password remains unchanged: password and verification do not match.";
		# Encrypt
		if (strlen($password) < 1) {
			return "Password remains unchanged: must be at least 1 character long.";
		} elseif(strlen($password) > 128) {
			return "Password remains unchanged: must be less than 128 characters long.";
		}
		$password = $this->users_system->db->single_element("SELECT password('".addslashes($password)."')");
		if($password == $this->password) return "";
		$this->password = $password;
		$this->users_system->db->update("UPDATE user SET password='".addslashes($this->password)."' WHERE userid='$this->id'");
		$this->clear_cache($this->id);
		return "Password changed.";
	}


	 ##########################################################
	# Given a password, verifies this is correct for the user
	function verify_password($password='') {
		return $this->users_system->db->single_element("SELECT 1 FROM user WHERE userid='$this->id' AND password=password('".addslashes($password)."')");
	}


	 ########################################
	# Change the users comments
	function set_comments($comments='') {
		if ($comments == $this->comments) return "";
		$this->comments = $comments;
		$this->users_system->db->update("UPDATE user SET comments='".addslashes($this->comments)."' WHERE userid='$this->id'");
		$this->clear_cache($this->id);
		return "User comments changed";
	}

	 #####################
	# Delete this bastard
	function delete() {
		$del_users = $this->users_system->db->delete("DELETE FROM user WHERE userid='$this->id'");
		if ($del_users) {

			 ###############################
			# Delete our superuser status
			$system_config = &get_system_config();
			if (in_array($this->login,$system_config->superusers['all'])) $system_config->delete_superuser($this->login);
			if (in_array($this->login,$system_config->superusers['web'])) $system_config->delete_web_master($this->login);
			if (in_array($this->login,$system_config->superusers['user'])) $system_config->delete_user_master($this->login);
			$system_config->conf_updated();

			$this->clear_cache($this->id);
			global $CACHE;
			$del_orgs = $this->users_system->db->delete("DELETE FROM affiliation WHERE userid='$this->id'");
			foreach($this->affiliations as $id => $data) $CACHE->clear($id,"organisation");
			$del_locs = $this->users_system->db->delete("DELETE FROM placement WHERE userid='$this->id'");
			foreach($this->placements as $id => $data) {
				$CACHE->clear($id,"location");
				$location = &$this->users_system->get_location($id);
				$message .= $location->check_tenency()."\n";
			}

			 ####################################
			# Okay, lets fuck our directory off
			delete_directory($this->data_path);

			$this = new User(0);

			return "$message\nDeleted $del_users user. ($del_orgs affiliations / $del_locs placements).";
		}
		return "Unable to delete user.";
	}

	 #################################
	# Adds an affiliation to the user
	function add_affiliation($new_organisationid=0,$new_title='') {
		$org_tree = &$this->users_system->get_organisation_tree();
		if(!isset($org_tree[$new_organisationid])) return "Unable to create affiliation: organisation does not exist.";
		if(!$new_organisationid || !$new_title) return "";
		$query = "INSERT INTO affiliation (userid,organisationid,title) VALUES ('$this->id','$new_organisationid','".addslashes($new_title)."')";
		if($this->users_system->db->insert($query)) {
			$this->affiliations[$new_organisationid]["title"] = $new_title;
			$this->clear_cache($this->id);
			global $CACHE;
			$CACHE->clear($new_organisationid,"organisation");
			return "Affiliation created with {$org_tree[$new_organisationid][name]} under the title of $new_title";
		}
		return "Unable to create affiliation with organisation: {$org_tree[$new_organisationid][name]}";
	}

	 #################################
	# Updates affiliation answers
	function update_affiliation_answers($organisationid=0,&$answers) {
		# Affiliations must have a title, even if its a trivial thing. Why? BECAUSE I SAID SO.
		if(!$organisationid || $this->affiliations[$organisationid]["answers"] == $answers) return "";
		if(!isset($this->affiliations[$organisationid])) return;
		$query = "UPDATE affiliation SET answers='".addslashes($answers)."' WHERE organisationid='$organisationid' AND userid='$this->id'";
		if($this->users_system->db->update($query)) {
			$this->affiliations[$organisationid]["answers"] = $answers;
			$this->clear_cache($this->id);
			global $CACHE;
			$CACHE->clear($organisationid,"organisation");
			$org_tree = &$this->users_system->get_organisation_tree();
			return "Affiliation with {$org_tree[$organisationid][name]} updated";
		}
		return "";
	}

	 #################################
	# Updates affiliation title
	function update_affiliation_title($organisationid=0,$new_title='') {
		# Affiliations must have a title, even if its a trivial thing. Why? BECAUSE I SAID SO.
		if(!$organisationid || !$new_title || $this->affiliations[$organisationid]["title"] == $new_title) return "";
		if(!isset($this->affiliations[$organisationid])) return $this->add_affiliation($organisationid,$new_title);
		$query = "UPDATE affiliation SET title='".addslashes($new_title)."' WHERE organisationid='$organisationid' AND userid='$this->id'";
		if($this->users_system->db->update($query)) {
			$this->affiliations[$organisationid]["title"] = $new_title;
			$this->clear_cache($this->id);
			global $CACHE;
			$CACHE->clear($organisationid,"organisation");
			$org_tree = &$this->users_system->get_organisation_tree();
			return "Affiliation with {$org_tree[$organisationid][name]} updated:  $new_title";
		}
		return "";
	}

	 #################################
	# Adds an affiliation to the user
	function delete_affiliation($organisationid=0) {
		if(!$organisationid) return "";
		$query = "DELETE FROM affiliation  WHERE organisationid='$organisationid' AND userid='$this->id'";
		$org_tree = &$this->users_system->get_organisation_tree();
		if($this->users_system->db->delete($query)) {
			unset($this->affiliations[$organisationid]);
			$this->clear_cache($this->id);
			global $CACHE;
			$CACHE->clear($organisationid,"organisation");
			return "Affiliation with {$org_tree[$organisationid][name]} deleted.";
		}
		return "Unable to delete affiliation with organisation: {$org_tree[$organisationid][name]}";
	}


	 #################################
	# Adds an placement to the user
	function add_placement($new_locationid=0,$new_direct_phone='',$new_direct_fax='') {
		if(!$new_locationid) return "";
		$address = $this->users_system->location_address($new_locationid);
		$query = "INSERT INTO placement (userid,locationid,direct_phone,direct_fax) VALUES ('$this->id','$new_locationid','".addslashes($new_direct_phone)."','".addslashes($new_direct_fax)."')";
		if($this->users_system->db->insert($query)) {
			$this->placements[$new_locationid]['direct_phone'] = $new_direct_phone;
			$this->placements[$new_locationid]['direct_fax']   = $new_direct_fax;
			$this->clear_cache($this->id);
			global $CACHE;
			$CACHE->clear($new_locationid,"location");
			return "Placement created at $address (Ph: $new_direct_phone | Fx: $new_direct_fax)";
		}
		return "Unable to create placement at location: $address";
	}

	 #################################
	# Adds an placement to the user
	function update_placement($locationid=0,$new_direct_phone='',$new_direct_fax='') {
		# placements must have a title, even if its a trivial thing. Why? BECAUSE I SAID SO.
		if(!isset($this->placements[$locationid]) && $new_direct_phone) return $this->add_placement($locationid,$new_direct_phone,$new_direct_fax);
		if(!$locationid || ($this->placements[$locationid]['direct_phone'] == $new_direct_phone && $this->placements[$locationid]['direct_fax'] == $new_direct_fax)) return "";
		$address = $this->users_system->location_address($locationid);
		$query = "UPDATE placement SET direct_phone='".addslashes($new_direct_phone)."', direct_fax='".addslashes($new_direct_fax)."' WHERE locationid='$locationid' AND userid='$this->id'";
		if($this->users_system->db->update($query)) {
			$this->placements[$locationid]['direct_phone'] = $new_direct_phone;
			$this->placements[$locationid]['direct_fax']   = $new_direct_fax;
			$this->clear_cache($this->id);
			global $CACHE;
			$CACHE->clear($locationid,"location");
			return "Placement updated at $address (Ph: $new_direct_phone | Fx: $new_direct_fax)";
		}
		return "";
	}

	 #################################
	# Adds an placement to the user
	function delete_placement($locationid=0) {
		if(!$locationid) return "";
		$address = $this->users_system->location_address($locationid);
		$query = "DELETE FROM placement  WHERE locationid='$locationid' AND userid='$this->id'";
		if($this->users_system->db->delete($query)) {
			unset($this->placements[$locationid]);
			$this->clear_cache($this->id);
			global $CACHE;
			$CACHE->clear($locationid,"location");
			$location = &$this->users_system->get_location($locationid);
			$message .= $location->check_tenency()."\n";
			return "$message\nPlacement at $address deleted.";
		}
		return "Unable to delete placement at location: $address";
	}


	#########################################################################
	# Returns a href to a file associated with this site (e.g. a custom image)
	function get_file_href($filename='') {
		return data_href("user/$this->id/$filename");
	}


	############################################################
	# Returns the current URL that the browser happens to be at
	function current_url() {
		return $_SERVER['HTTP_HOST'].str_replace("index.php", "", $_SERVER['PHP_SELF']);
	}



	 ##########################################################
	# Prints the backend for the user
	function print_backend() {
		$system_config = &get_system_config();
		$session = &get_mysource_session();
		 ###################################
		# Setup the backend a little
		$backend = &$this->users_system->setup_backend(); # Backend refrence
		$backend->set_title($this->name()." - Edit User");

		 ###############################
		# More aliases
		$org_tree = &$this->users_system->get_organisation_tree();
		$managed_organisationids = &$this->users_system->get_managed_organisationids();

		 ####################################################################
		# SECUIRTY - Only let in those who have permission to work on a site
		if (!$session->logged_in()) {
			$session->login_screen($backend->title,"You must be logged in and have permission to edit <i>$system_config->system_name</i> user records in order to proceed.");
		}

		 ######################################################################
		# This particular user must be affiliated with an managed organisation
		if (!$this->write_access()) {
			$session->login_screen($backend->title,'You are not a designated manager of any organisations that this user belongs to.');
		}

		 ######################################################################
		# Only Root can edit herself
		if ($this->id == 1 && !user_root()) {
			$session->login_screen($backend->title,'You have to be root if you want to edit root.');
		}

		$backend->set_tab('user',"user.php?userid=$this->id",'General','Edit this user','user');
		foreach($this->affiliations as $organisationid => $data) {
			$organisation = &$this->users_system->get_organisation($organisationid);
			if(!$organisation->form) continue;
			$backend->set_tab($organisation->name,"user.php?userid=$this->id&edit_am_section=Form&form_organisationid=$organisation->id",$organisation->name.' Special User Data','Edit this users special data fields','page');
		}
		$backend->set_heading('Edit User','user');
		$backend->set_name($this->name());
		$backend->set_id_string($this->id);

		$backend->set_hidden_field('action');
		$backend->set_hidden_field('userid',$this->id);
		$backend->set_hidden_field('organisationid');
		$backend->set_hidden_field('locationid');
		$backend->set_hidden_field('new_organisationid',$session->get_var('active_organisationid'));
		$backend->set_hidden_field('new_locationid',$session->get_var('active_locationid'));

		$edit_am_section = $_REQUEST['edit_am_section'];
		$backend->set_hidden_field('edit_am_section',$edit_am_section);
		switch($edit_am_section) {
			case 'Form':
				$this->print_form_backend();
				return;
		}

		$backend->set_active_tab('user');

		 #########################################
		# Process a submitted form
		$action = $_POST['action'];
		switch($action) {

		 ###################################
		# Commiting changes to the database
		case 'Commit':
			$expiry_date = $_POST['expiry_date'];
			$firstname = $_POST['firstname'];
			$surname = $_POST['surname'];
			$login = $_POST['login'];
			$password = $_POST['password'];
			$email = $_POST['email'];
			$web_status = $_POST['web_status'];
			$mobile_no = $_POST['mobile_no'];
			$comments = $_POST['comments'];
			if($this->write_access()) {
				$backend->add_message($this->set_name(gpc_stripslashes($firstname), gpc_stripslashes($surname)));
				$backend->add_message($this->set_email(gpc_stripslashes($email)));
				$backend->add_message($this->set_login(gpc_stripslashes($login)));
				$backend->add_message($this->set_password(gpc_stripslashes($password[0]), gpc_stripslashes($password[1])));
				$backend->add_message($this->set_mobile_no(gpc_stripslashes($mobile_no)));
				$backend->add_message($this->set_web_status(gpc_stripslashes($web_status)));
				$backend->add_message($this->set_expiry_date(gpc_stripslashes($expiry_date)));
				$backend->add_message($this->set_comments(gpc_stripslashes($comments)));
				$upload_result = process_image_upload('userimage', $this->data_path.'/userimage', false);
				$backend->add_message($upload_result['message']);
			}

			 #########################
			# Update affiliations
			$title = $_POST['title'];
			if (is_array($title)) {
				foreach($title as $orgid => $new_title) {
					if (in_array($orgid,$managed_organisationids)) {
						$backend->add_message($this->update_affiliation_title($orgid,$new_title));
					}
				}
			}

			 #######################
			# New affiliation
			$new_title = $_POST['new_title'];
			$new_organisationid = $_POST['new_organisationid'];
			$manager = $_POST['manager'];
			if(in_array($new_organisationid,$managed_organisationids)) {
				$backend->add_message($this->update_affiliation_title($new_organisationid,gpc_stripslashes($new_title)));
				if($manager) {
					if($this->users_system->higher_manager($session->user->id,$new_organisationid)) {
						$this->users_system->db->update("UPDATE affiliation SET manager='Y' WHERE organisationid='$new_organisationid' AND userid='$this->id'");
					} else {
						$backend->add_message('Permission denied.');
					}
				}
			}


			 ###########################
			# Delete affiliations
			$delete_affiliations = $_POST['delete_affiliations'];
			$deletables = (!is_array($delete_affiliations)) ? array() : array_keys($delete_affiliations);
			foreach($deletables as $orgid) {
				 # Must be a manager
				if (in_array($orgid,$managed_organisationids)) {
					# Not allowed to "orphan" a user, even if you mange all their organisations
					$managed_affiliations = array_intersect(array_keys($this->affiliations),$managed_organisationids);
					array_remove_element($orgid,$managed_affiliations);
					if(superuser("user") ||	count($managed_affiliations) > 0) {
						# If this user is a manager of this organisation
						$user_managed_organisationids = &$this->users_system->get_managed_organisationids($this->id);
						if(in_array($orgid,$user_managed_organisationids)) {
							# Then we can only delete if we are a manager of a higher organisation
							if(!$this->users_system->higher_manager($session->user->id,$orgid)) {
								$fail = true;
							}
						}
						if($fail) {
							$backend->add_message("Permission denied: this user is a manager!");
						} else {
							$backend->add_message($this->delete_affiliation($orgid));
						}
					} else {
						$backend->add_message("Permission denied to delete affiliation: you would lose your user!");
					}
				}
			}

			if($this->write_access()) {
				 #########################
				# Update placements
				$direct_phone = $_POST['direct_phone'];
				$direct_fax = $_POST['direct_fax'];
				if (is_array($direct_phone)) {
					foreach($direct_phone as $locid => $new_direct_phone) {
						$new_direct_fax = $direct_fax[$locid];
						$backend->add_message($this->update_placement($locid, gpc_stripslashes($new_direct_phone), gpc_stripslashes($new_direct_fax)));
					}
				}

				 ###########################
				# Delete placesments
				$delete_placements = $_POST['delete_placements'];
				$deletables = (is_array($delete_placements)) ? array_keys($delete_placements) : array();
				if (is_array($deletables)) {
					foreach($deletables as $locid) {
						$backend->add_message($this->delete_placement($locid));
					}
				}
			}
			break;


		 ###################################
		# Delete a user from the database
		case 'Delete':
			if($this->delete_access()) {
				$blank = '';
				$session->set_var('active_userid',$blank);
				$backend->add_message($this->delete());
				$backend->set_relocation('users.php');
				$backend->print_header();
				unset($this);
				exit();
			} else {
				$backend->add_message('Permission Denied.');
			}
			break;

		}#end switch

		 #######################
		# Die on no ID
		if(!$this->id) {
			return '';
		}

		 ########################################
		# Refresh the information - just in case
		if ($action) {
			$this->clear_cache($this->id);
			$this->load();
		}

		$backend->set_toolbar_button("find","javascript: var user_search; if ((user_search = prompt('Enter the name, login or email address of a user you\'d like to find?','$this->login')) != null && user_search != 'null') {location='users.php?action=Search+Users&user_search='+escape(user_search);}","Find a different user","find");

		if($this->delete_access()) {
			$backend->set_toolbar_button("delete","javascript: if (confirm('Are you sure you want to delete this user?') && confirm('Really sure? This is irreversible.')) {document.edit.action.value='Delete';document.edit.submit()}","Delete this user","delete");
		}


		$backend->print_header();

		$authentication = &$this->users_system->get_authentication();
		if($authentication->codename != 'default') {
			$backend->open_section("Note");
			$backend->open_field('','top');
			echo("<b>WARNING:</b> This MySource system is not using the default MySource user database for authentication. It is using $authentication->name. The password field below will not be used for authentication.");
		}


		$backend->open_section("Attributes");

		$backend->open_field("Firstname");
		echo text_box(firstname,$this->firstname,20,128,"class=data");

		$backend->open_field("Surname");
		echo text_box(surname,$this->surname,20,128,"class=data");

		$backend->open_field("Login");
		echo text_box(login,$this->login,10,64,"class=data");

		$backend->open_field("Change Password");
		?><input type="password" name="password[0]" value="" size=12 maxlength=16 class=data><?
		$backend->open_field("(Verify)");
		?><input type="password" name="password[1]" value="" size=12 maxlength=16 class=data><?

		$backend->open_field("Email");
		echo text_box(email,$this->email,40,128,"class=data");

		$backend->open_field("Mobile");
		echo text_box(mobile_no,$this->mobile_no,16,32,"class=data");

		$backend->open_field("Account Expiry");
		echo date_box("expiry_date",(($this->expiry_date) ? $this->expiry_date : ""),"edit");

		$backend->open_field("Web Status");
		echo combo_box("web_status",$this->web_statii,$this->web_status,"",20,"class=data");

		$backend->open_field("User Picture");
		echo image_upload('userimage', $this->data_path.'/userimage', $this->get_file_href(), '', 0, 0, true);

		$backend->open_field("Comments","top");
		echo text_area("comments",$this->comments,40,8,2000,"class=data");

		$backend->open_section("Affiliated Organisations","organisation");

		if(count($this->affiliations) == 0) {
			$backend->open_field();
			echo "None.";
		}
		$i = 1;
		if (is_array($this->affiliations)) {
			foreach($this->affiliations as $organisationid=>$data) {
				$organisation = &$org_tree[$organisationid];
				$parent       = &$org_tree[$organisation['parentid']];
				$backend->open_field($i++,"top");
				$managed = in_array($organisationid,$managed_organisationids);
				echo (($managed)?text_box("title[$organisationid]",$data["title"],30,128,"class=data"):$data["title"]);
				$user_managed_organisationids = &$this->users_system->get_managed_organisationids($this->id,false);
				if(in_array($organisationid,$user_managed_organisationids)) {
					echo "<span style=\"color: #aa0000\"><b>(Manager)</b></span>";
				}
				if($managed) {
					echo(" <b>[<input type=checkbox name=delete_affiliations[$organisationid] value=1><span style=\"color: #aa0000\">Delete?</span>]</b>");
				}
				echo ("<br> with <a href=\"organisation.php?organisationid=$organisationid\" ".(($managed)?"style=\"color: #0000ff\"":"")."><b>$organisation[name]</b></a> ".(($organisation['parentid']>0)?"(of <a href=\"organisation.php?organisationid=$parent[organisationid]\">$parent[name]</a>) ":""));
			}
		}
		$active_organisationid = $session->get_var("active_organisationid");
		if ($active_organisationid && !$this->affiliations[$active_organisationid] && in_array($active_organisationid,$managed_organisationids)) {
			$organisation = &$org_tree[$active_organisationid];
			$parent       = &$org_tree[$organisation['parentid']];
			$backend->open_field("<hr noshade size=0>");
			$backend->open_field("New?<span style=\"font-size:8pt\"><br>(or leave blank)</span>","top");
			echo text_box("new_title","",30,128,"class=data");
			# Is this user a manager of a higher organisation?
			if($this->users_system->higher_manager($session->user->id,$active_organisationid)) {
				echo "<b>[<input type=checkbox name=manager value=1><span style=\"color: #aa0000\">Make Manager?</span>]</b>";
			}
			echo ("<br> with <a href=\"organisation.php?organisationid=$active_organisationid\"><b>$organisation[name]</b></a> ".(($organisation['parentid']>0)?"(of <a href=\"organisation.php?organisationid=$parent[organisationid]\">$parent[name]</a>) ":""));
		}

		$backend->open_section("Location Placements","location");

		if(empty($this->placements)) {
			$backend->open_field();
			echo "None.";
		}

		$i = 1;
		if (is_array($this->placements)) {
			foreach($this->placements as $locationid=>$data) {
				$direct_phone = $data['direct_phone'];
				$direct_fax   = $data['direct_fax'];
				$location     = $this->users_system->location_address($locationid);
				$backend->open_field($i++,"top");
				echo("Ph:".text_box("direct_phone[$locationid]",$direct_phone,15,32,"class=data"));
				echo(" at <a href=\"location.php?locationid=$locationid\"><b>$location</b></a><br>");
				echo("Fx:".text_box("direct_fax[$locationid]",$direct_fax,15,32,"class=data"));
				echo(" <b>[<input type=checkbox name=delete_placements[$locationid] value=1><span style=\"color: #aa0000\">Delete?</span>]</b>");
			}
		}

		$active_locationid = $session->get_var("active_locationid");
		if ($active_locationid && !$this->placements[$active_locationid]) {
			$location     = $this->users_system->location_address($active_locationid);
			$backend->open_field("<hr noshade size=0>");
			$backend->open_field("New Placement?<span style=\"font-size:8pt\"><br>(or leave blank)</span>","top");
			echo ("Ph:".text_box("direct_phone[$active_locationid]","",15,128,"class=data"));
			echo (" at <a href=\"location.php?locationid=$active_locationid\"><b>$location</b></a><br>");
			echo ("Fx:".text_box("direct_fax[$active_locationid]","",15,128,"class=data"));
		}

		$backend->open_field("<hr noshade size=0>");
		$backend->open_field("New Location?");
		echo "Ph:".text_box("new_location_direct_phone","",15,128,"class=data")."&nbsp;";
		echo "Fx:".text_box("new_location_direct_fax","",15,128,"class=data")."&nbsp;";
		$backend->print_icon_button("javascript: if (document.edit.new_location_direct_phone.value != '' || document.edit.new_location_direct_fax.value != '') window.location='location.php?placementid=$this->id&placement_phone=' + escape(document.edit.new_location_direct_phone.value) + '&placement_fax=' + escape(document.edit.new_location_direct_fax.value);","Create New Location","create");

		$backend->print_commit_button("Commit","if(check_date('edit','expiry_date')){if(confirm('Commit this information to the system?')){document.edit.action.value='Commit';document.edit.submit();}}");
		$backend->print_footer();
	}

	 ##################################
	# Returns the fullname of a user
	function name() {
		if (trim($this->firstname) == '' && trim($this->surname) == '') return $this->login;
		return "$this->firstname $this->surname";
	}

	 ##################################################
	# Print the backend screen for extra user data
	function print_form_backend() {
		global $SQUIZLIB_PATH;
		include_once("$SQUIZLIB_PATH/form/form.inc");

		$backend = &$this->get_backend();
		$form_organisationid = $_REQUEST['form_organisationid'];
		$backend->set_hidden_field("form_organisationid",$form_organisationid);
		$organisation = &$this->users_system->get_organisation($form_organisationid);
		$backend->set_active_tab($organisation->name);
		$backend->set_subheading("&nbsp;");

		$backend->print_header();

		$form = new Form($organisation->form);
		if ($form->process()) {
			if(!$form->check()) {
				$results = $form->check_results;
				$backend->open_field("Form Results","top");
				echo("<span class=error>You have not filled out this form correctly:</span>");
				echo("<ul>");
				foreach($results as $result) {
					echo "<li><span class=error>$result</span></li>";
				}
				echo("</ul>");
			} else {
				$backend->add_message($this->update_affiliation_answers($form_organisationid,$form->export_answers()));
			}
		}

		$form->import_answers($this->affiliations[$form_organisationid]["answers"]);

		if(count($form->sections) == 1 && !$form->sections[1]["questions"]) {
			$backend->open_field("");
			echo "No special user data available for ".$organisation->name;
		} else {
			$form->render_backend(&$backend);
		}

		$backend->print_footer();

	}

}

?>
