<?  ##############################################
   ### MySource ------------------------------###
  ##- Include Files ------ PHP4 --------------##
 #-- Copyright Squiz.net ---------------------#
##############################################
## This file is subject to version 1.0 of the
## MySource License, that is bundled with
## this package in the file LICENSE, and is
## available at through the world-wide-web at
## http://mysource.squiz.net/
## If you did not receive a copy of the MySource
## license and are unable to obtain it through
## the world-wide-web, please contact us at
## mysource@squiz.net so we can mail you a copy
## immediately.
##
## Desc: A class which handles the management of the MySource configuration
## $Source: /home/cvsroot/mysource/include/config.inc,v $
## $Revision: 2.27.2.12 $
## $Author: bvial $
## $Date: 2003/01/07 23:37:57 $
#######################################################################

#---------------------------------------------------------------------#

class Config extends CacheableObject {

	var $conf_path;
	var $conf_file;
	var $id;
	var $conf_parser_files;

	# Must supply a unique ID for this file for caching purposes
	function Config($id=0,$conf_file='') {
		$this->id = $id;
		$this->conf_path = dirname($conf_file);
		$this->conf_file = basename($conf_file);
		$this->load();
	}

	function __sleep() {
		$result = array_keys(get_object_vars($this));
		array_remove_element('conf_parser_files',$result);
		return $result;
	}

	  #################################################
	 # Function that streamlines conf parsing
	##########################################
	function get_conf_line($file) {
		$f = &$this->conf_parser_files[$file];
		if (!$f) {
			if (!$f['ptr'] = fopen($file,'r')) {
				report_error(__FILE__,__LINE__,"Configuration file not found: $file");
				exit();
			}
			$f['line'] = 0;
		}
		if(!empty($f['include'])) {
			if($line = $this->get_conf_line($f['include'])) {
				return $line;
			} else {
				unset($f['include']);
			}
		}
		while($line = fgets($f['ptr'],4096)) {
			$f['line']++;
			$line = trim($line);           # Ignore indenting
			if (!$line || $line[0] == '#' || $line[0] == ';') continue; # Ignore blanks and comments

			 ##################
			# Special commands
			if($line[0] == '@') {
				$command = substr(trim(strtok($line," \t")),1);
				$args    = trim(strtok("\n"));
				switch($command) {
				case 'include':
					if($args[0] == '/') {
						$f['include'] = $args;
					} else {
						$f['include'] = dirname($file).'/'.$args;
					}
					return $this->get_conf_line($f['include']);
					break;
				default:
					break;
				}
				continue;
			}

			return strtok($line,'#');
		}
		fclose($f['ptr']);
		unset($f);
		return '';
	}


	  #################################
	 # Another conf parsing function #
	#################################
	function get_conf_line_no($file) {
		return $this->conf_parser_files[$file]['line'];
	}

}


 ############################################################
# Loads a general MySource configuration object and returns
# a reference to it
function &get_config($name) {
	global $CONFIGURATIONS;
	$name = strtolower($name);
	$class = "Config_$name";
	if(!isset($CONFIGURATIONS[$name]) || get_class($CONFIGURATIONS[$name]) != strtolower($class)) {
		global $CONF_PATH;
		$CONFIGURATIONS[$name] = new $class("mysource_$name","$CONF_PATH/$name.conf");
	}
	return $CONFIGURATIONS[$name];
}




 ##################################
# The main MySource Configuration
class Config_MySource extends Config {

	  ######################
	 # Some default values
	########################
	var $system_name = 'MySource System';
	var $system_owner = 'System Owner';
	var $webmaster_email;
	var $backend_message_box_focus = 0;
	var $backend_log_messages = '';
	var $backend_brand_image = '';
	var $jupload_path;


	var $superusers = array('all' => array(), 'web' => array(), 'users' => array());

	var $max_idle_time	= 6000;
	var $max_login_attempts = 3;
	var $require_ssl_login = 0;
	var $log_visitors = 0;
	var $log_remote_hosts = 0;

	var $web_db_details = array('name'=>'','host'=>'','login'=>'','password'=>'', 'querylog'=>'');

	var $virtual_paths  = 0;
	var $strict_url_matching = 0;
	var $backend_suffix = 'edit';
	var $default_language;
	var $default_charset;
	var $moderate_caching;
	var $illegal_filetypes = 'php php3 php4 php5 php6 inc act';
	var $site_backend_dhtml_navigation = 0;
	var $default_table_cell_type = 'richtext';

	var $user_authentication = 'default';

	var $user_db_details	= array('name'=>'','host'=>'','login'=>'','password'=>'','querylog'=>'');

	var $check_db_mbstrings = Array();


	/**
	* Load config variables
	*
	* @returns string
	* @access public
	*/
	function load() {
		  ##########################
		 # Can we load from cache #
		##########################
		if ($this->load_from_cache($this->id)) {
			if (trim(strtolower(getenv('MySource_LogVisitors'))) != 'on') {
				$this->set_log_visitors(false);
			}
			if (trim(strtolower(getenv('MySource_BackendLogMessages'))) != 'on') {
				$this->set_backend_log_messages('');
			}
			if (trim(strtolower(getenv('MySource_WebDatabaseLog'))) != 'on') {
				$this->web_db_details['querylog'] = '';
			}
			if (trim(strtolower(getenv('MySource_UserDatabaseLog'))) != 'on') {
				$this->user_db_details['querylog'] = '';
			}
			return $this->id;
		}

		$parse_error_log = '';

		while($line = $this->get_conf_line("$this->conf_path/$this->conf_file")) {
			# Grab the first word of the line
			$key = strtok($line," \t");

			switch($key) {
				#!!!!!!--> INSERT NEW CONFIGURATION VARS HERE - parsing, do not process
				case 'SystemName':
					$this->set_system_name(trim(strtok("\n")));
					break;
				case 'SystemOwner':
					$this->set_system_owner(trim(strtok("\n")));
					break;
				case 'WebMasterEmail':
					$this->set_webmaster_email(strtok(" \t"));
					break;
				case 'BackendMessageBoxFocus':
					$this->set_backend_message_box_focus(strtok(" \t"));
					break;
				case 'BackendLogMessages':
					$logging = trim(strtolower(getenv('MySource_BackendLogMessages')));
					if ($logging == 'on') {
						$this->set_backend_log_messages(strtok("\n"));
					} else {
						# no logging
						$this->set_log_visitors('');
					}
				case 'BackendBrandImage':
					$this->set_backend_brand_image(strtok("\n"));
					break;
				case 'JUploadPath':
					$this->set_jupload_path(strtok("\n"));
					break;
				case 'BackendMySourceIframe':
					list($key, $url, $title) = split("[ \t]",$line, 3);
					$this->set_backend_mysource_iframe($url, $title);
					break;
				case 'SuperUsers':
					$tmp_logins = split("[ \t\,]+",$line);
					for($i = 1; $i < count($tmp_logins); $i++) {
						$this->add_superuser(trim($tmp_logins[$i]));
					}
					break;
				case 'MaxIdleTime':
					$this->set_max_idle_time(floor(strtok(" \t")));
					break;
				case 'MaxLoginAttempts':
					$this->set_max_login_attempts(floor(strtok(" \t")));
					break;
				case 'RequireSslLogin':
					$this->set_require_ssl_login(floor(strtok(" \t")));
					break;
				case 'LogVisitors':
					$logging = trim(strtolower(getenv('MySource_LogVisitors')));
					if ($logging == 'on') {
						$this->set_log_visitors(floor(strtok(" \t")));
					} else {
						# no logging
						$this->set_log_visitors(false);
					}
					break;
				case 'LogRemoteHosts':
					$this->set_log_remote_hosts(floor(strtok(" \t")));
					break;
				case 'WebDatabase':
					list($key,$name,$host,$login,$password,$querylog) = split("[ \t]",$line);
					$logging = trim(strtolower(getenv('MySource_WebDatabaseLog')));
					if ($logging != 'on') $querylog = '';
					$this->set_web_db_details($name,$host,$login,$password,$querylog);
					break;
				case 'WebMasters':
					$tmp_logins = split("[ \t\,]+",$line);
					for($i = 1; $i < count($tmp_logins); $i++) {
						$this->add_web_master(trim($tmp_logins[$i]));
					}
					break;
				case 'VirtualPaths':
					$this->set_virtual_paths(strtok(" \t"));
					break;
				case 'BackendSuffix':
					$this->set_backend_suffix(strtok(" \t"));
					break;
				case 'StrictUrlMatching':
					$this->set_strict_url_matching(strtok(" \t"));
					break;
				case 'DefaultFrontendLanguage':
					$this->set_default_language(strtok(" \t"));
					break;
				case 'DefaultTableCellType':
					$this->set_default_table_cell_type(strtok(" \t"));
					break;
				case 'DefaultCharacterSet':
					$this->set_default_charset(strtok(" \t"));
					break;
				case 'ModerateCaching':
					$this->set_moderate_caching(strtok(" \t"));
					break;
				case 'IllegalFiletypes':
					$this->set_illegal_filetypes(strtok("\n"));
					break;
				case 'SiteBackendDHTMLNavigation':
					$this->set_site_backend_dhtml_navigation(strtok(" \t"));
					break;
				case 'CheckDBMBStrings':
					$str = strtok("\n");
					$this->check_db_mbstrings = (trim($str) != '') ? split("[ \t]+", $str) : Array();
					break;
				case 'UserDatabase':
					list($key,$name,$host,$login,$password,$querylog) = split("[ \t]",$line);
					$logging = trim(strtolower(getenv('MySource_UserDatabaseLog')));
					if ($logging != 'on') $querylog = '';
					$this->set_user_db_details($name,$host,$login,$password,$querylog);
					break;
				case 'UserLDAP': case 'AuthenticationType':
					# Backwards compatiblility
					break;
				#	list($key,$host,$password,$rootdn) = split("[ \t]",$line);
				#	$this->set_user_ldap_details($host,$password,$rootdn);
				#	break;
				case "UserAuthentication":
					list($key,$authentication) = split("[ \t]",$line);
					$this->set_user_authentication($authentication);
					break;
				case 'UserMasters':
					$tmp_logins = split("[ \t\,]+",$line);
					for($i = 1; $i < count($tmp_logins); $i++) {
						$this->add_user_master(trim($tmp_logins[$i]));
					}
					break;
				case 'BatchDelete':
					$this->set_batch_delete(floor(strtok(" \t")));
					break;
				case 'BatchDupe':
					$this->set_batch_dupe(floor(strtok(" \t")));
					break;
				default:
					$parse_error_log .= "Unrecognised keyword: \"$key\" on line ".$this->conf_parser_files[$this->conf_file]['line']." of $this->conf_file<br>";
					break;
				#<--!!!!!!
			}
		}

		# Errors found, die.
		if ($parse_error_log) {
			report_error(__FILE__,__LINE__,"<B>Parsing configuration file:</b><br><br>$parse_error_log");
			exit();
		}

		# End parsing configuration file

		# Write the cache
		$this->save_to_cache($this->id);

		return $this->id;

	}

	 #########################################################
	# functions for setting and deleting there variables

	function set_system_name($name) {
		if($name == $this->system_name) return;
		$this->system_name = $name;
		return "System Name changed to: $name";
	}

	function set_system_owner($owner) {
		if($owner == $this->system_owner) return;
		$this->system_owner = $owner;
		return "System Owner changed to: $owner";
	}

	function set_webmaster_email($email) {
		if($email == $this->webmaster_email) return;
		$this->webmaster_email = $email;
		return "Webmaster Email set to: $email";
	}

	function set_backend_message_box_focus($bool) {
		$bool = strtolower(trim($bool));
		if(in_array("$bool",array('y','yes','on','1'))) {
			if($this->backend_message_box_focus) return;
			$this->backend_message_box_focus = 1;
			return 'Backend Message Box Focus activated';
		} else {
			if(!$this->backend_message_box_focus) return;
			$this->backend_message_box_focus = 0;
			return 'Backend Message Box Focus deactivated';
		}
	}

	function set_backend_log_messages($path) {
		if($this->backend_log_messages == $path) return;
		$this->backend_log_messages = $path;
		return (($path)?'Backend Log Messages activated':'Backend Log Messages deactivated');
	}

	function set_backend_brand_image($image) {
		if($image == $this->backend_brand_image) return;
		$this->backend_brand_image = $image;
		return 'Brand Image '.(($this->backend_brand_image) ? '' : 'de').'activated';
	}

	function set_jupload_path($path) {
		if($path == $this->jupload_path) return;
		if($this->jupload_path = $path) {
			return 'Updated JUpload path.';
		} else {
			return 'JUpload disabled.';
		}
	}

	function set_backend_mysource_iframe($url,$title) {
		if($url == $this->backend_mysource_iframe['url']
			&& $host  == $this->backend_mysource_iframe['title']
			) return;

		$this->backend_mysource_iframe['url']   = $url;
		$this->backend_mysource_iframe['title'] = $title;
		return 'Backend MySource Iframe details updated.';
	}

	function set_web_db_details($name,$host,$login,$password,$querylog) {
		if(!$name || !$host || !$login) return 'Database name, host and login are required';
		if($name == $this->web_db_details['name']
			&& $host  == $this->web_db_details['host']
			&& $login == $this->web_db_details['login']
			&& $password == $this->web_db_details['password']
			&& $querylog == $this->web_db_details['querylog']
			) return;
		# Try to connect
		global $SQUIZLIB_PATH;
		require_once("$SQUIZLIB_PATH/db/db.inc");
		$db = new Db($name,$login,$password,$host,$querylog);
		if(!$db->ptr) {
			 return 'Can not connect to database: Web Database details unchanged';
		} else {
			$db->disconnect();
		}
		$this->web_db_details['name']     = $name;
		$this->web_db_details['host']     = $host;
		$this->web_db_details['login']    = $login;
		$this->web_db_details['password'] = $password;
		$this->web_db_details['querylog'] = $querylog;
		return 'Web Database details updated.';
	}

	function set_default_language($lan) {
		if($lan == $this->default_language) return;
		$this->default_language = $lan;
		$languages_config = &get_config('languages');
		$desc = substr($desc,0,-2);
		return 'Default Frontend Language set to: '.$languages_config->name_list($this->default_language);
	}

	function set_default_charset($charset) {
		if($charset == $this->default_charset) return;
		$this->default_charset = $charset;
		$charsets_config = &get_config('charsets');
		return array(MYSOURCE_ERROR_CODE_NONE,"Default Character Set set to: {$charsets_config->charsets[$this->default_charset]}");
	}

	function set_moderate_caching($moderate_caching) {
		if($moderate_caching == $this->moderate_caching) return;
		$this->moderate_caching = $moderate_caching;
		return array(MYSOURCE_ERROR_CODE_NONE,(($this->moderate_caching)?'MySource will attempt to moderate web caching.':'MySource will no longer attempt to moderate web caching.'));
	}

	function set_illegal_filetypes($illegal_filetypes) {
		if($illegal_filetypes == $this->illegal_filetypes) return;
		$this->illegal_filetypes = $illegal_filetypes;
		return array(MYSOURCE_ERROR_CODE_NONE,"Filetypes which may not be uploaded into MySource include now include: $this->illegal_filetypes");
	}

	function check_file_legality($filename) {
		return !in_array(get_file_type($filename),preg_split("/[ \t\n\r]+/",$this->illegal_filetypes));
	}

	function set_check_db_mbstrings($check) {
		if (!is_array($check)) return '';
		if(equal_arrays($check, $this->check_db_mbstrings)) return;
		$this->check_db_mbstrings = $check;
		return array(MYSOURCE_ERROR_CODE_NONE,'Validation of multibyte strings from the database updated.');
	}

	function set_user_db_details($name,$host,$login,$password,$querylog) {
		if(!$name || !$host || !$login) return array(MYSOURCE_ERROR_CODE_ERROR,'Database name, host and login are required');
		if($name == $this->user_db_details['name']
			&& $host == $this->user_db_details['host']
			&& $login == $this->user_db_details['login']
			&& $password == $this->user_db_details['password']
			&& $querylog == $this->user_db_details['querylog']
			) return;

		$db = new Db($name,$login,$password,$host,$querylog);
		if(!$db->ptr) {
			 return array(MYSOURCE_ERROR_CODE_ERROR,"Can not connect to database: User Database details unchanged");
		} else {
			$db->disconnect();
		}
		$this->user_db_details['name']     = $name;
		$this->user_db_details['host']     = $host;
		$this->user_db_details['login']    = $login;
		$this->user_db_details['password'] = $password;
		$this->user_db_details['querylog'] = $querylog;
		return array(MYSOURCE_ERROR_CODE_NONE,'User Database details updated.');
	}

	function add_superuser($login) {
		if(!$login) return;
		if(in_array($login,$this->superusers['all'])) return array(MYSOURCE_ERROR_CODE_WARNING,"$login is already a Superuser");
		$this->superusers['all'][] = $login;
		return array(MYSOURCE_ERROR_CODE_NONE,"Superuser added: $login");
	}

	function add_web_master($login) {
		if(!$login) return;
		if(in_array($login,$this->superusers['web'])) return array(MYSOURCE_ERROR_CODE_WARNING,"$login is already a Web Master");
		$this->superusers['web'][] = $login;
		return array(MYSOURCE_ERROR_CODE_NONE,"Web Master added: $login");
	}

	function add_user_master($login) {
		if(!$login) return;
		if(in_array($login,$this->superusers['user'])) return array(MYSOURCE_ERROR_CODE_WARNING,"$login is already a User Master");
		$this->superusers['user'][] = $login;
		return array(MYSOURCE_ERROR_CODE_NONE,"User Master added: $login");
	}

	function delete_superuser($login) {
		if(!$login) return;
		if(!in_array($login,$this->superusers['all'])) return array(MYSOURCE_ERROR_CODE_WARNING,"$login is not a Superuser");
		array_remove_element($login,$this->superusers['all']);
		return array(MYSOURCE_ERROR_CODE_NONE,"Superuser deleted: $login");
	}

	function delete_web_master($login) {
		if(!$login) return;
		if(!in_array($login,$this->superusers['web'])) return array(MYSOURCE_ERROR_CODE_WARNING,"$login is not a Web Master");
		array_remove_element($login,$this->superusers['web']);
		return array(MYSOURCE_ERROR_CODE_NONE,"Web Master deleted: $login");
	}

	function delete_user_master($login) {
		if(!$login) return;
		if(!in_array($login,$this->superusers['user'])) return array(MYSOURCE_ERROR_CODE_WARNING,"$login is not a User Master");
		array_remove_element($login,$this->superusers['user']);
		return array(MYSOURCE_ERROR_CODE_NONE,"User Master deleted: $login");
	}

	function set_max_login_attempts($attempts) {
		$attempts = max(0, (int)$attempts); # Must be a natural number
		if($attempts == $this->max_login_attempts) return;
		$this->max_login_attempts = $attempts;
		if($attempts) {
			return array(MYSOURCE_ERROR_CODE_NONE,"Maximum Allowed Login Attempts set to $attempts.");
		} else {
			return array(MYSOURCE_ERROR_CODE_NONE,'Maximum Allowed Login Attempts: unlimited.');
		}
	}

	function set_max_idle_time($time) {
		$time = max(0,(int) $time);
		if ($time && $time < 60) $time = 60;
		if($time == $this->max_idle_time) return;
		$this->max_idle_time = $time;
		if($time) {
			return array(MYSOURCE_ERROR_CODE_NONE,"Maximum Idle Time set to $time seconds.");
		} else {
			return array(MYSOURCE_ERROR_CODE_NONE,'Maximum Idle Time: unlimited.');
		}
	}

	function set_require_ssl_login($bool) {
		$bool = strtolower(trim($bool));
		if(in_array($bool, array('y','yes','on','1'))) {
			if($this->require_ssl_login) return;
			$this->require_ssl_login = 1;
			return array(MYSOURCE_ERROR_CODE_NONE,'Login now requires SSL encryption.');
		} else {
			if(!$this->require_ssl_login) return;
			$this->require_ssl_login = 0;
			return array(MYSOURCE_ERROR_CODE_NONE,'Login no longer requires SSL encryption.');
		}
	}

	function set_log_visitors($bool) {
		$bool = strtolower(trim($bool));
		if(in_array($bool, array('y','yes','on','1'))) {
			if($this->log_visitors) return;
			$this->log_visitors = 1;
			return array(MYSOURCE_ERROR_CODE_NONE,'Now logging visitors (ie sessions as well as page and file hits).');
		} else {
			if(!$this->log_visitors) return;
			$this->log_visitors = 0;
			return array(MYSOURCE_ERROR_CODE_NONE,'No longer logging visitors (ie sessions as well as page and file hits).');
		}
	}

	function set_log_remote_hosts($bool) {
		$bool = strtolower(trim($bool));
		if(in_array("$bool",array('y','yes','on','1'))) {
			if($this->log_remote_hosts) return;
			$this->log_remote_hosts = 1;
			return array(MYSOURCE_ERROR_CODE_NONE,'Now logging remote hostnames for new sessions.');
		} else {
			if(!$this->log_remote_hosts) return;
			$this->log_remote_hosts = 0;
			return array(MYSOURCE_ERROR_CODE_NONE,'No longer logging remote hostnames.');
		}
	}


	function set_virtual_paths($bool) {
		$bool = strtolower(trim($bool));
		if(in_array("$bool",array('y','yes','on','1'))) {
			if($this->virtual_paths) return;
			$this->virtual_paths = 1;
			return array(MYSOURCE_ERROR_CODE_WARNING,'Virtual Paths activated. Please ensure your web server configuration is correct.');
		} else {
			if(!$this->virtual_paths) return;
			$this->virtual_paths = 0;
			return array(MYSOURCE_ERROR_CODE_WARNING,'Virtual Paths deactivated.');
		}
	}

	function set_backend_suffix($suffix) {
		$suffix = ereg_replace("/+",'',$suffix);
		if($suffix == $this->backend_suffix) return;
		$this->backend_suffix = $suffix;
		return array(MYSOURCE_ERROR_CODE_NONE,"Backend suffix set to: /$suffix");
	}

	function set_strict_url_matching($bool) {
		$bool = strtolower(trim($bool));
		if(in_array("$bool",array('y','yes','on','1'))) {
			if($this->strict_url_matching) return;
			$this->strict_url_matching = 1;
			return array(MYSOURCE_ERROR_CODE_NONE,'Strict URL matching activated.');
		} else {
			if(!$this->strict_url_matching) return;
			$this->strict_url_matching = 0;
			return array(MYSOURCE_ERROR_CODE_NONE,'Strict URL matching deactivated.');
		}
	}


	function set_site_backend_dhtml_navigation($bool) {
		$bool = strtolower(trim($bool));
		if(in_array("$bool",array('y','yes','on','1'))) {
			if($this->site_backend_dhtml_navigation) return;
			$this->site_backend_dhtml_navigation = 1;
			return array(MYSOURCE_ERROR_CODE_NONE,'DHTML Navigation for Site Backends activated');
		} else {
			if(!$this->site_backend_dhtml_navigation) return;
			$this->site_backend_dhtml_navigation = 0;
			return array(MYSOURCE_ERROR_CODE_NONE,'DHTML Navigation for Site Backends deactivated');
		}
	}

	function set_default_table_cell_type($type) {
		$bool = strtolower(trim($type));
		if($this->default_table_cell_type == $type) return;
		$this->default_table_cell_type = $type;
		return array(MYSOURCE_ERROR_CODE_NONE,"Default table cell type set to $type");
	}

	function set_user_authentication($authentication) {
		if (!$authentication || $authentication == $this->user_authentication) return;
		global $XTRAS;
		if($XTRAS->codename('users/authentication',$authentication)) {
			$this->user_authentication = $authentication;
			return array(MYSOURCE_ERROR_CODE_NONE,'User Authentication system changed');
		} else {
			return array(MYSOURCE_ERROR_CODE_WARNING,'Invalid User Authentication code');
		}
		/*
		switch ($authtype) {
			case "mysql":
				if ($authtype == $this->authenticationtype
					&& $connection_details['name']     == $this->user_db_details['name']
					&& $connection_details['host']     == $this->user_db_details['host']
					&& $connection_details['login']    == $this->user_db_details['login']
					&& $connection_details['password'] == $this->user_db_details['password']
					&& $connection_details['querylog'] == $this->user_db_details['querylog']
				) return;
				$success = $this->set_user_db_details(
					$connection_details['name'],
					$connection_details['host'],
					$connection_details['login'],
					$connection_details['password'],
					$connection_details['querylog']
				);
				if ($success[0] == MYSOURCE_ERROR_CODE_NONE || !$success[0]) {
					$this->authenticationtype=$authtype;
					if (!$include_file) {
						$include_file = 'include/user.inc';
					}
					$this->authenticationlocation = $include_file;
					return array(MYSOURCE_ERROR_CODE_NONE, "Switching to MySQL");
				}
				return array(MYSOURCE_ERROR_CODE_ERROR, "Unable to switch to MySQL");
			break;
			case "ldap":
				if ($authtype == $this->authenticationtype
					&& $connection_details['host']     == $this->user_ldap_details['host']
					&& $connection_details['password'] == $this->user_ldap_details['password']
					&& $connection_details['rootdn']   == $this->user_ldap_details['rootdn']
				) return;
				$success = $this->set_user_ldap_details(
					$connection_details['host'],
					$connection_details['password'],
					$connection_details['rootdn']
				);
				if ($success[0] == MYSOURCE_ERROR_CODE_NONE || !$success[0]) {
					$this->authenticationtype=$authtype;
					if (!$include_file) {
						$include_file = 'xtras/users/extensions/ldap/user_ldap.inc';
					}
					$this->authenticationlocation = $include_file;
					return array(MYSOURCE_ERROR_CODE_NONE, "Switching to LDAP");
				}
				return array(MYSOURCE_ERROR_CODE_ERROR, "Unable to switch to LDAP");
			break;
		}*/
	}

	function set_batch_delete($batch_delete) {
		$batch_delete = max(0, (int)$batch_delete); # Must be a natural number
		if($batch_delete == $this->batch_delete) return;
		$this->batch_delete = $batch_delete;
		if($batch_delete) {
			return array(MYSOURCE_ERROR_CODE_NONE,"Batch Delete Pages set to $batch_delete.");
		} else {
			return array(MYSOURCE_ERROR_CODE_NONE,'Batch Delete Pages: using default');
		}
	}

	function set_batch_dupe($batch_dupe) {
		$batch_dupe = max(0, (int)$batch_dupe); # Must be a natural number
		if($batch_dupe == $this->batch_dupe) return;
		$this->batch_dupe = $batch_dupe;
		if($batch_dupe) {
			return array(MYSOURCE_ERROR_CODE_NONE,"Batch Dupe Pages set to $batch_dupe.");
		} else {
			return array(MYSOURCE_ERROR_CODE_NONE,'Batch Dupe Pages: using default');
		}
	}

	  ###############################################
	 # Rewrites the conf file with current variables
	################################################
	function conf_updated() {

		  ################################
		 # Delete old conf file and cache
		#################################

		$this->clear_cache($this->id);


		# Re-write new conf file
		if(!($fd = fopen("$this->conf_path/$this->conf_file",'w'))) {
			report_error(__FILE__,__LINE__,"Configuration file not found: $this->conf_path/$this->conf_file");
			exit();
		}

		$conf_file = "SystemName $this->system_name\n\n";
		$conf_file .= "SystemOwner $this->system_owner\n\n";
		$conf_file .= "WebMasterEmail $this->webmaster_email\n\n";
		$conf_file .= "BackendMessageBoxFocus $this->backend_message_box_focus\n\n";
		$conf_file .= "BackendLogMessages $this->backend_log_messages\n\n";
		$conf_file .= "BackendBrandImage $this->backend_brand_image\n\n";
		$conf_file .= "JUploadPath $this->jupload_path\n\n";
		if ($this->backend_mysource_iframe['url']) {
			$conf_file .= 'BackendMySourceIframe '.$this->backend_mysource_iframe['url'].' '.$this->backend_mysource_iframe['title']."\n\n";
		}

		$conf_file .= 'WebDatabase '.$this->web_db_details['name'].' '.$this->web_db_details['host'].' '.$this->web_db_details['login'].' '.$this->web_db_details['password'].' '.$this->web_db_details['querylog']."\n\n";

		$conf_file .= 'UserDatabase '.$this->user_db_details['name'].' '.$this->user_db_details['host'].' '.$this->user_db_details['login'].' '.$this->user_db_details['password'].' '.$this->user_db_details['querylog']."\n\n";
		#$conf_file .= 'UserLDAP '.$this->user_ldap_details['host']. ' ' . $this->user_ldap_details['password'] . ' ' . $this->user_ldap_details['rootdn'] . "\n\n";

		#$conf_file .= 'AuthenticationType '.$this->authenticationtype . ' ' . $this->authenticationlocation . "\n\n";

		$conf_file .= 'UserAuthentication '.$this->user_authentication."\n\n";

		$conf_file .= 'SuperUsers ';
		for(reset($this->superusers['all']);$tmp_login=current($this->superusers['all']);next($this->superusers['all'])) {
			$conf_file .= $tmp_login.' ';
		}
		$conf_file .= "\n\n";
		$conf_file .= 'WebMasters ';
		for(reset($this->superusers['web']);$tmp_login=current($this->superusers['web']);next($this->superusers['web'])) {
			$conf_file .= $tmp_login.' ';
		}
		$conf_file .= "\n\n";
		$conf_file .= 'UserMasters ';
		for(reset($this->superusers['user']);$tmp_login=current($this->superusers['user']);next($this->superusers['user'])) {
			$conf_file .= $tmp_login.' ';
		}
		$conf_file .= "\n\n";
		$conf_file .= "MaxIdleTime $this->max_idle_time\n\n";
		$conf_file .= "MaxLoginAttempts $this->max_login_attempts\n\n";
		$conf_file .= "RequireSslLogin $this->require_ssl_login\n\n";
		$conf_file .= "LogVisitors $this->log_visitors\n\n";
		$conf_file .= "LogRemoteHosts $this->log_remote_hosts\n\n";
		$conf_file .= "VirtualPaths $this->virtual_paths\n\n";
		$conf_file .= "BackendSuffix $this->backend_suffix\n\n";
		$conf_file .= "StrictUrlMatching $this->strict_url_matching\n\n";
		$conf_file .= "DefaultFrontendLanguage $this->default_language\n\n";
		$conf_file .= "DefaultTableCellType $this->default_table_cell_type\n\n";
		$conf_file .= "DefaultCharacterSet $this->default_charset\n\n";
		$conf_file .= "ModerateCaching $this->moderate_caching\n\n";
		$conf_file .= "IllegalFiletypes $this->illegal_filetypes\n\n";
		$conf_file .= "SiteBackendDHTMLNavigation $this->site_backend_dhtml_navigation\n\n";
		$conf_file .= 'CheckDBMBStrings '.implode(' ',$this->check_db_mbstrings)."\n\n";
		$conf_file .= "BatchDelete $this->batch_delete\n\n";
		$conf_file .= "BatchDupe $this->batch_dupe\n\n";

		fwrite($fd,$conf_file);
		fclose($fd);

		# Write the cache
		$this->save_to_cache($this->id);

		return "Configuration file $this->conf_file updated.";
	}

	  ##################################
	 # Lets print the conf backend    #
	##################################
	function print_backend() {
		global $EDIT_PATH, $EDIT_DIR, $INCLUDE_PATH;
		include_once("$INCLUDE_PATH/backend.inc");
		$backend = new Backend($EDIT_DIR,$EDIT_PATH);
		$backend->set_title("$this->system_name - Backend");

		$session = &get_mysource_session();

		 ###################################################
		# SECURITY - Only let in those who have permission
		if (!$session->logged_in()) {
			$session->login_screen($backend->title,"You must be logged in and have permission to edit <i>$this->system_name</i> in order to proceed.");
		}

		if (!superuser('web') && !superuser('user')) {
			$session->login_screen($backend->title,"You do not have permission to view or edit the system config of <i>$this->system_name</i>.");
		}

		$backend->set_active_menu_item('config');

		# Only privileged users can mess around here
		if (superuser('web') || superuser('user')) {
			$action = $_POST['action'];

			#############################
			# get users database object
			#############################
			#
			$users_system = &get_users_system();
			$db = &$users_system->db;

			##################
			# process $action
			##################
			#
			switch($action) {

				case 'Commit':

					$globalvars = array('system_name','system_owner','webmaster_email','jupload_path','web_db_details','user_db_details','max_login_attempts','max_idle_time', 'require_ssl_login','delete_superuser_ids', 'delete_webmaster_ids', 'delete_usermaster_ids', 'superuser_search', 'webmaster_search', 'usermaster_search', 'log_visitors', 'log_remote_hosts', 'virtual_paths', 'backend_suffix', 'strict_url_matching', 'default_language', 'default_charset', 'moderate_caching', 'illegal_filetypes', 'check_db_mbstrings', 'site_backend_dhtml_navigation', 'backend_message_box_focus', 'backend_log_messages', 'user_db_details', 'user_authentication', 'default_table_cell_type', 'batch_delete', 'batch_dupe');
					foreach($globalvars as $k) {
						$$k = $_POST[$k];
					}

					if(user_root()) {

						####################
						# delete superusers
						####################
						#
						if (!empty($delete_superuser_ids)) {
							$sql = "SELECT login
									  FROM user
									 WHERE userid IN ('".implode("','", $delete_superuser_ids)."')";

							$superusers = $db->single_column($sql);
							foreach($superusers as $login) {
								$backend->add_message($this->delete_superuser($login));
							}
						}

						#################
						# add superusers
						#################
						#
						$user_searches = split("[ \t\r\n\,]+",gpc_stripslashes($superuser_search));
						foreach($user_searches as $login) {
							# security & empty var check
							if (trim($login) != '') {
								# make sure user exists before adding
								if ($user_row = $users_system->find_user($login)) {
									$backend->add_message($this->add_superuser($user_row['login']));
								}
								else {
									$backend->add_message("Could not add superuser: $login. User does not exist");
								}
							}
						}# end foreach


						###############################
						# update web database details
						###############################
						#
						$web_db_details = gpc_stripslashes($web_db_details);
						$backend->add_message($this->set_web_db_details($web_db_details['name'],
																		$web_db_details['host'],
																		$web_db_details['login'],
																		$web_db_details['password'],
																		$web_db_details['querylog']));

						###############################
						# update user database details
						###############################
						#
						$user_db_details     = gpc_stripslashes($user_db_details);
						$user_authentication = gpc_stripslashes($user_authentication);

						$backend->add_message($this->set_user_db_details(
								$user_db_details['name'],
								$user_db_details['host'],
								$user_db_details['login'],
								$user_db_details['password'],
								$user_db_details['querylog']
						));


						$backend->add_message($this->set_user_authentication($user_authentication));

					}#end if user_root



					if(superuser()) {

						#####################
						# delete web masters
						#####################
						#
						if (count($delete_webmaster_ids)) {
							$sql = "SELECT login
									  FROM user
									 WHERE userid IN ('".implode("','", $delete_webmaster_ids)."')";

							$webmasters = $db->single_column($sql);
							foreach($webmasters as $login) {
								$backend->add_message($this->delete_web_master($login));
							}
						}

						######################
						# delete user masters
						######################
						#
						if (count($delete_usermaster_ids)) {
							$sql = "SELECT login
									  FROM user
									 WHERE userid IN ('".implode("','", $delete_usermaster_ids)."')";

							$usermasters = $db->single_column($sql);
							foreach($usermasters as $login) {
							  if (superuser()) {
								$backend->add_message($this->delete_user_master($login));
							  }
							}
						}

						##################
						# add web masters
						##################
						#
						$user_searches = split("[ \t\r\n\,]+", gpc_stripslashes($webmaster_search));
						foreach($user_searches as $login) {
							# security and empty var check
							if (trim($login) != '') {
								# check user exists
								if ($user_row = $users_system->find_user($login)) {
									$backend->add_message($this->add_web_master($user_row['login']));
								}
								else {
									$backend->add_message("Could not add web master: $login. User does not exist");
								}
							}
						}# end foreach

						###################
						# add user masters
						###################
						#
						$user_searches = split("[ \t\r\n\,]+", gpc_stripslashes($usermaster_search));
						foreach($user_searches as $login) {
							# security and empty string check
							if (trim($login) != '') {
								# user exists in first place?
								if ($user_row = $users_system->find_user($login)) {
									$backend->add_message($this->add_user_master($user_row['login']));
								}
								else {
									$backend->add_message("Could not add user master: $login. User does not exist");
								}
							}
						}# end foreach


						# Update other config vars
						$backend->add_message($this->set_system_name(gpc_stripslashes($system_name)));
						$backend->add_message($this->set_system_owner(gpc_stripslashes($system_owner)));
						$backend->add_message($this->set_webmaster_email(gpc_stripslashes($webmaster_email)));
						$backend->add_message($this->set_backend_message_box_focus(gpc_stripslashes($backend_message_box_focus)));

						$backend->add_message($this->set_backend_log_messages(gpc_stripslashes($backend_log_messages)));

						$upload_result = process_image_upload('backend_brand_image', get_data_path(true, 'backend_brand_image'), false);
						$backend->add_message($upload_result['message']);
						$image = get_image(get_data_path(true, 'backend_brand_image'));
						if ($image) {
							$image_size = getImageSize($image);
							$image = '<img src="'.data_href(basename($image)).'" '.$image_size[3].' border="0">';
						}
						$backend->add_message($this->set_backend_brand_image($image));

						$backend->add_message($this->set_jupload_path($jupload_path));

					}#end if superuser

					if (superuser()) {
						$backend->add_message($this->set_max_login_attempts(gpc_stripslashes($max_login_attempts)));
						$backend->add_message($this->set_max_idle_time(gpc_stripslashes($max_idle_time)));
						$backend->add_message($this->set_require_ssl_login(gpc_stripslashes($require_ssl_login)));
						$backend->add_message($this->set_log_visitors(gpc_stripslashes($log_visitors)));
						$backend->add_message($this->set_log_remote_hosts(gpc_stripslashes($log_remote_hosts)));
						$backend->add_message($this->set_batch_delete(gpc_stripslashes($batch_delete)));
						$backend->add_message($this->set_batch_dupe(gpc_stripslashes($batch_dupe)));
					}

					if(superuser('web')) {

						$backend->add_message($this->set_default_table_cell_type(gpc_stripslashes($default_table_cell_type)));
						$backend->add_message($this->set_default_language(gpc_stripslashes(implode(',',$default_language))));
						$backend->add_message($this->set_default_charset(gpc_stripslashes($default_charset)));
						$backend->add_message($this->set_moderate_caching(gpc_stripslashes($moderate_caching)));

						$backend->add_message($this->set_illegal_filetypes(gpc_stripslashes($illegal_filetypes)));
						$backend->add_message($this->set_check_db_mbstrings(gpc_stripslashes($check_db_mbstrings)));
						$backend->add_message($this->set_site_backend_dhtml_navigation(gpc_stripslashes($site_backend_dhtml_navigation)));
					}

					if(superuser()) {
						#if($this->virtual_paths) {
						$backend->add_message($this->set_backend_suffix(gpc_stripslashes($backend_suffix)));
						#}
						$backend->add_message($this->set_virtual_paths(gpc_stripslashes($virtual_paths)));
						$backend->add_message($this->set_strict_url_matching(gpc_stripslashes($strict_url_matching)));
					}
					break;

			}
			if($action) {
				$this->clear_cache($this->id);
				$this->save_to_cache($this->id);
				$backend->add_message($this->conf_updated());
			}
		}

		$backend->set_heading('System Configuration','create');
		$backend->set_subheading($this->system_name);
		$backend->set_hidden_field('action');
		$backend->print_header();

		 ########################################
		# this stuff comes from the config file
		$superusers  = &$this->superusers['all'];
		$webmasters  = &$this->superusers['web'];
		$usermasters = &$this->superusers['user'];


		$backend->open_section('System Settings');
		$backend->open_field('System Name');
		if(superuser()) {
			echo text_box('system_name',$this->system_name, 30, '','class=data');
		} else {
			echo $this->system_name;
		}

		$backend->open_field('System Owner');
		if(superuser()) {
			echo text_box('system_owner',$this->system_owner, 30, '','class=data');
		} else {
			echo $this->system_owner;
		}

		$backend->open_field('Web Master Email');
		if(superuser()) {
			echo text_box('webmaster_email',$this->webmaster_email, 30, '','class=data');
		} else {
			echo $this->webmaster_email;
		}

		$backend->open_field('Backend Message Box Focus');
		if (superuser()) {
			echo combo_box('backend_message_box_focus',array('1'=>'On','0'=>'Off'),$this->backend_message_box_focus);
		} else {
			echo (($this->backend_message_box_focus)?'On':'Off');
		}
		echo('<span class=smallprint><br>This determines whether the message box in the backend pops up over the current window or not</span>');

		$backend->open_field('Backend Log Messages','top');
		if (trim(strtolower(getenv('MySource_BackendLogMessages'))) != 'on') {
			echo '<span class=smallprint>This feature is not available with your current configuration.</span>';
		} else {
			if (superuser()) {
				echo text_box('backend_log_messages',$this->backend_log_messages,30,'','class=data');
			} else {
				echo $this->backend_log_messages;
			}
			echo '<span class=smallprint><br>/path/to/log/file or leave blank for no logging.</span>';
		}

		$backend->open_field('Backend Brand Image', 'top');
		if (superuser()) {
			echo image_upload('backend_brand_image', get_data_path(true, 'backend_brand_image'), data_href(), 20000, 200, 100, true);
		} else {
			echo $this->backend_brand_image;
		}

		$backend->open_field('JUpload Path', 'top');
		echo text_box('jupload_path',$this->jupload_path,40,100);
		echo '<span class=smallprint><br>If you have configured tomcat or another Java Servlet handler on your server and have enabled the squizlib/jupload directory, enter the appropriate path here (from the browsers POV).<br>E.g. <i>http://beta.squiz.net/agi_test_jupload/</i><br><b>Leave this field blank if you cannot or do not wish to use the Java uploader.</b></span>';


		 ##############
		# super-users
		if (user_root()) {

			if (!empty($superusers)) {

				$backend->open_field('Current Super Users ('.count($superusers).'):', 'top');

				$sql = "SELECT userid, login, CONCAT(firstname, ' ', surname) as name, email
						FROM user
						WHERE login IN ('".implode("','", $superusers)."')
						ORDER BY surname, firstname";
				$superusers  = $db->associative_array($sql);

				$users_system->display_users_table(array_keys($superusers), ((user_root())?'delete_superuser_ids':''), 'Delete?','super_page_counter');
			}#end if count(superusers)

			$backend->open_field('Add Super Users:<br><span class=smallprint>(logins/emails)</span>',  'top');
			echo text_area(superuser_search,'',30,3,3000,'class=data');

		}#end if user_root

		 ##########################################
		# login and session timeout configuration
		$backend->open_section('Login/Session Settings');
		$backend->open_field('Max Login Attempts');
		if(superuser()) {
			echo text_box('max_login_attempts',(($this->max_login_attempts)?$this->max_login_attempts:'Unlimited'), 10, 10,'class=data');
		} else {
			echo (($this->max_login_attempts)?$this->max_login_attempts:'Unlimited');
		}

		$backend->open_field('Max Idle Time');
		if(superuser()) {
			echo text_box('max_idle_time',(($this->max_idle_time)?$this->max_idle_time:'Unlimited'), 10, 10,'class=data').'<span class=fineprint>(seconds. Min: 60)</span>';
		} else {
			echo (($this->max_idle_time)?$this->max_idle_time.'<span class=fineprint> (seconds)</span>':'Unlimited');
		}

		$backend->open_field('Require SSL Login','top');
		if(superuser()) {
			echo combo_box('require_ssl_login',array('1'=>'On','0'=>'Off'),$this->require_ssl_login);
		} else {
			echo (($this->require_ssl_login) ? 'Yes' : 'No');
		}
		echo '<span class=smallprint><br>This will make the default login box on the frontend SSL encrypted.</span>';

		$backend->open_field('Log Visitors','top');
		if (trim(strtolower(getenv('MySource_LogVisitors'))) != 'on') {
			echo '<span class=smallprint>This feature is not available with your current configuration.</span>';
		} else {
			if(superuser()) {
				echo combo_box('log_visitors', array('1'=>'On','0'=>'Off'), $this->log_visitors);
			} else {
				echo (($this->log_visitors) ? 'Yes' : 'No');
			}
			echo('<span class=smallprint><br>Turning on this setting, enables logging of sessions, page hits and file hits.<br><i>NOTE: On high traffic sites enabling this option can cause the database server to crash due to the huge amounts of data being stored</i></span>');
		}

		$backend->open_field('Log Remote Hosts','top');
		if(superuser()) {
			echo combo_box('log_remote_hosts',array('1'=>'On','0'=>'Off'),$this->log_remote_hosts);
		} else {
			echo (($this->log_remote_hosts)?'Yes':'No');
		}
		echo('<span class=smallprint><br>If pages sometimes take a very long time to load at the beginning of a session, turn this option off. If on, the <i>hostname</i> of the user is logged, which can be used to figure out their ISP and country of origin.<br>Only effective if Log Visitors in enabled</span>');

		 ############
		# WEB SYSTEM
		$backend->open_section('Web System Settings');

		 ####################################
		# Only root needs to see this stuff
		if(user_root()) {
			$backend->open_field('Database Name');
			echo text_box('web_db_details[name]',$this->web_db_details['name'], 30, 30,'class=data');

			$backend->open_field('Database Host','top');
			echo text_box('web_db_details[host]',$this->web_db_details['host'], 40, 128,'class=data');
			echo('<span class=fineprint><br><b>Syntax:</b> host[:port][:/path/to/socket]<br><b>Examples:</b><br>localhost<br>dataserver.mycompany.com:3309<br>localhost:3309:/var/lib/mysql_special/mysql.sock</span>');

			$backend->open_field('Database Login');
			echo text_box('web_db_details[login]',$this->web_db_details['login'], 15, 30,'class=data');

			$backend->open_field('Database Password');
			echo password_box('web_db_details[password]',$this->web_db_details['password'], 15, 30,'class=data');

			$backend->open_field('Database Query Logs', 'top');
			if (trim(strtolower(getenv('MySource_WebDatabaseLog'))) != 'on') {
				echo '<span class=smallprint>This feature is not available with your current configuration.</span>';
			} else {
				echo text_box('web_db_details[querylog]',$this->web_db_details['querylog'],45,255,'class=data');
				echo ('<span class=smallprint><br>/path/to/log/file or leave blank for no logging.</span>');
			}
		}

		$backend->open_field('Virtual Paths','top');
		if (superuser()) {
			echo combo_box('virtual_paths',array('1'=>'On','0'=>'Off'),$this->virtual_paths);
		} else {
			echo (($this->virtual_paths)?'On':'Off');
		}
		$backend->open_field('Backend Suffix','top');
		#if(superuser() && $this->virtual_paths) {
		echo '<span class=data>/</span>';
		echo text_box('backend_suffix',$this->backend_suffix,15,255,'class=data');
		echo ('<span class=smallprint><br>This must correspond with your web server configuration.</span>');
		#} else {
		#	echo "<span class=data>/$this->backend_suffix</span>";
		#}

		$backend->open_field('Batch Page Delete', 'top');
		if(superuser()) {
			echo text_box('batch_delete',(($this->batch_delete)?$this->batch_delete:'10'), 10, 10,'class=data');
		} else {
			echo (($this->batch_delete)?$this->batch_delete:'10');
		}
		echo ('<span class=smallprint><br>The number of pages to delete at a time when deleting a page or site. Set this to a low number if your deleting is timing out.</span>');

		$backend->open_field('Batch Page Dupe', 'top');
		if(superuser()) {
			echo text_box('batch_dupe',(($this->batch_dupe)?$this->batch_dupe:'10'), 10, 10,'class=data');
		} else {
			echo (($this->batch_dupe)?$this->batch_dupe:'10');
		}
		echo ('<span class=smallprint><br>The number of pages to dupe at a time when duping a page or site. Set this to a low number if your duping is timing out.</span>');

		$backend->open_field('Strict URL Matching','top');
		if (superuser()) {
			echo combo_box('strict_url_matching',array('1'=>'On','0'=>'Off'),$this->strict_url_matching);
		} else {
			echo (($this->strict_url_matching)?'On':'Off');
		}
		echo ('<span class=smallprint><br>This decides whether the system will try to match the closest URL for or display the \'Page Not Found\'.</span>');

		$backend->open_field('Moderate Caching','top');
		if (superuser()) {
			echo combo_box('moderate_caching',array('1'=>'On','0'=>'Off'),$this->moderate_caching);
		} else {
			echo (($this->moderate_caching)?'On':'Off');
		}
		echo ('<span class=smallprint><br>MySource can attempt to control web caching in browsers and proxies using HTTP headers. You may switch this off to use the PHP defaults, however, but these tend to discourage caching which can lead to increased traffic and download time.</span>');

		$backend->open_field('Illegal Filetypes','top');
		if (superuser()) {
			echo text_area('illegal_filetypes',$this->illegal_filetypes,40,3);
		} else {
			echo $this->illegal_filetypes;
		}
		echo ('<span class=smallprint><br>List the file extensions that you do not want MySource users to be able to upload, and use to potentially exploit your server. (all lower-case - uppercase files will also be rejected)</span>');

		# DEFAULT TABLE CELL TYPE
		if (superuser('web')) {
			$backend->open_field('Default Table Cell Type');
			echo combo_box('default_table_cell_type',array('richtext'=>'Rich Text','wysiwyg'=>'WYSIWYG','rawhtml'=>'Raw HTML'),$this->default_table_cell_type);
		}

		# LANGUAGE
		$backend->open_field('Frontend Language','top');
		$languages_config = &get_config('languages');
		if(superuser()) {
			if($this->default_language) {
				echo $languages_config->name_list($this->default_language).'<br>';
			}
			echo multiple_combo_box('default_language',$languages_config->languages,explode(',',$this->default_language),'class=data', '', 4);
		} else {
			echo '<span class=data>'.$languages_config->name_list($this->default_language).'</span>';
		}
		echo('<span class=smallprint><br>This is the default language used on the frontend. It may be overridden by individual sites and pages.</span>');

		# CHARACTER SETS
		$backend->open_field('Character Set','top');
		if(superuser()) {
			$charsets_config = &get_config('charsets');
			echo combo_box('default_charset',array(''=>'-- Browser Default --')+$charsets_config->charsets,$this->default_charset, 'class=data');
		} else {
			$languages_config = &get_config('charsets');
			echo "<span class=data>{$charsets_config->charsets[$this->default_charset]}</span>";
		}
		echo('<span class=smallprint><br>This is the default character set used in the backend and the frontend. It may be overridden by individual sites and pages.</span>');
		echo('<span class=smallprint><br><input type=checkbox name=check_db_mbstrings[] value=web '.((in_array('web',$this->check_db_mbstrings))?'checked':'').'> Validate data coming out of the <b>web</b> database is in this character set and uncorrupted.<br><input type=checkbox name=check_db_mbstrings[] value=users '.((in_array('users',$this->check_db_mbstrings))?'checked':'').'> Validate data coming out of the <b>users</b> database is in this character set and uncorrupted.</span>');
		echo('<span class=warning style="font-size: 10px;"><br><b>Warning: These settings are only necessary for multi-byte character sets.</b> You must have the <i>mbstring</i> module for PHP installed for these two options to work correctly. Only a few character sets are supported (generally Japanese ones).</span>');

		$backend->open_field('Site Backend DHTML Navigation');
		if (superuser('web')) {
			echo combo_box('site_backend_dhtml_navigation',array('1'=>'On','0'=>'Off'),$this->site_backend_dhtml_navigation);
		} else {
			echo (($this->site_backend_dhtml_navigation)?'On':'Off');
		}

		 ##############
		# web-masters
		if (superuser()) {
			if (count($webmasters)) {
				$backend->open_field('Current Web Masters ('.count($webmasters).'):', 'top');

				$sql = "SELECT userid, login, CONCAT(firstname, ' ', surname) as name, email
						FROM user
						WHERE login IN ('".implode("','", $webmasters)."')
						ORDER BY surname, firstname";

				$webmasters = $db->associative_array($sql);

				$users_system->display_users_table(array_keys($webmasters), 'delete_webmaster_ids','Delete?','web_page_counter');
			}#end if count(webmasters)
			$backend->open_field('Add Web Masters:<br><span class=smallprint>(logins/emails)</span>',  'top');
			echo text_area(webmaster_search,'',30,3,3000,'class=data');
		}#end if superuser


		 ####################################
		# Only root needs to see this stuff
		$backend->open_section('Users System');
		if(user_root()) {
			$backend->open_field('Database Name');
			echo text_box('user_db_details[name]',$this->user_db_details['name'], 30, 30,'class=data');
			$backend->open_field('Database Host');
			echo text_box('user_db_details[host]',$this->user_db_details['host'], 40, 128,'class=data');
			echo('<span class=fineprint><br><b>Syntax:</b> host[:port][:/path/to/socket]</span>');
			$backend->open_field('Database Login','top');
			echo text_box('user_db_details[login]',$this->user_db_details['login'], 30, 30,'class=data');
			$backend->open_field('Database Password');
			echo password_box('user_db_details[password]',$this->user_db_details['password'], 30, 30,'class=data');
			$backend->open_field('Database Query Logs', 'top');
			if (trim(strtolower(getenv('MySource_UserDatabaseLog'))) != 'on') {
				echo '<span class=smallprint>This feature is not available with your current configuration.</span>';
			} else {
				echo text_box('user_db_details[querylog]',$this->user_db_details['querylog'],45,255,'class=data');
				echo ('<span class=smallprint><br>/path/to/log/file or leave blank for no logging.</span>');
			}

			global $XTRAS;
			$backend->open_field('User Authentication','top');
			echo combo_box('user_authentication',$XTRAS->list_type('users/authentication'),$this->user_authentication);
			echo('(<a href="users.php?authentication_edit='.$this->user_authentication.'">Configure current authentication system</a>)<br>Note that the user "root" is always validated off the MySource user database.');
		}

		 ###############
		# user-masters
		if (superuser()) {
			if (count($usermasters)) {
				$backend->open_field('Current Users Masters ('.count($usermasters).'):', 'top');

				$sql = "SELECT userid, login, CONCAT(firstname, ' ', surname) as name, email
						FROM user
						WHERE login IN ('".implode("','", $usermasters)."')
						ORDER BY surname, firstname";

				$usermasters = $db->associative_array($sql);

				$users_system->display_users_table(array_keys($usermasters), 'delete_usermaster_ids','Delete?','user_page_counter');
			}#end if count(usermasters)
			$backend->open_field('Add User Masters:<br><span class=smallprint>(logins/emails)</span>',  'top');
			echo text_area(usermaster_search,'',30,3,3000,'class=data');
		}#end if superuser



		if (superuser()) {
			global $XTRAS;
			$backend->open_section('Xtras');
			$backend->open_field('List', 'top');
			$XTRAS->print_backend($backend);
		}

		if(superuser('web')) {
			$backend->print_commit_button('Commit',"if (confirm('Commit this information to the system?')) { document.edit.action.value='Commit';document.edit.submit(); }");
		}

		$backend->print_footer();

	}#end method

}




 ################################################
# File types: descriptions and mime-types base
# on the extensions
class Config_File_Types extends Config {

	var $file_types;
	var $mime_types;

	function load() {

		# Can we load from cache ?
		$loaded = $this->load_from_cache();
		if($loaded) return;

		$parse_error_log = '';

		 ###########################################
		# Parse the file types configuration file
		while($line = $this->get_conf_line("$this->conf_path/$this->conf_file")) {
			# Grab the first word of the line
			$key   = strtok($line," \t");
			$ext   = strtok(" \t");
			$value = strtok("\n");

			switch($key) {
				case 'desc':
					$this->add_file_type($ext,trim($value));
					break;
				case 'mime':
					$this->add_mime_type($ext,trim($value));
					break;
				default:
					$parse_error_log .= "Unrecognised keyword: \"$key\" on line ".$this->conf_parser_files[$this->conf_file]['line']." of $this->conf_file<br>";
					break;
			}

		}
		# Errors found, die.
		if ($parse_error_log) {
			report_error(__FILE__,__LINE__,"<B>Parsing configuration file:</b><br><br>$parse_error_log");
			exit();
		}

		# End parsing configuration file

		# Write the cache
		$this->save_to_cache($this->id);

	}

	function add_file_type($ext,$type) {
		if(!$ext || !$type) return;
		if(isset($this->file_types[$ext])) return "File type already set for: $ext";
		$this->file_types[$ext] = $type;
		return "File type $ext added";
	}

	function delete_file_type($ext) {
		if(!$ext) return;
		if(!isset($this->file_types[$ext])) return "File type $ext does not exist";
		unset($this->file_types[$ext]);
		return "File type $ext deleted";
	}

	function add_mime_type($ext,$type) {
		if(!$ext || !$type) return;
		if(isset($this->mime_types[$ext])) return "Mime type already set for: $ext";
		$this->mime_types[$ext] = $type;
		return "Mime type $ext added";
	}

	function delete_mime_type($ext) {
		if(!$ext) return;
		if(!isset($this->mime_types[$ext])) return "Mime type $ext does not exist";
		unset($this->mime_types[$ext]);
		return "Mime type $ext deleted";
	}

	  ###############################################
	 # Rewrites the conf file with current variables
	function conf_updated() {

		  ################################
		 # Delete old conf file and cache
		$this->clear_cache($this->id);

		# Re-write new conf file
		if(!($fd = fopen("$this->conf_path/$this->conf_file","w"))) {
			report_error(__FILE__,__LINE__,"Configuration file not found: $this->conf_path/$this->conf_file");
			exit();
		}

		foreach($this->file_types as $ext => $type) {
			$conf_file .= "desc $ext $type\n";
		}
		foreach($this->mime_types as $ext => $type) {
			$conf_file .= "mime $ext $type\n";
		}

		fwrite($fd,$conf_file);
		fclose($fd);

		return "Configuration file $this->conf_file updated.";
	}

}



 ###########################
# Countries and their codes
class Config_Countries extends Config {

	var $countries;

	function load() {

		 ############################
		# Can we load from cache ?
		$loaded = $this->load_from_cache();
		if($loaded) return;

		$parse_error_log = '';

		 ###########################################
		# Parse the file types configuration file
		$this->countries = array();
		while($line = $this->get_conf_line("$this->conf_path/$this->conf_file")) {
			# The code must be a lower-case two-letter country code
			$code = strtolower(substr(strtok($line," \t"),0,2));
			if(!ereg("^[a-z][a-z]$",$code)) {
				$parse_error_log .= "'$code' is not a valid country code.\n";
			} else {
				$this->countries[$code] = strtok("\n");
			}
		}
		# Errors found, die.
		if ($parse_error_log) {
			report_error(__FILE__,__LINE__,"<B>Parsing configuration file:</b><br><br>$parse_error_log");
			exit();
		}

		# Write the cache
		$this->save_to_cache();

	}

}



 ###########################
# Languages and their Codes
class Config_Languages extends Config {

	var $languages;

	function load() {

		 ############################
		# Can we load from cache ?
		$loaded = $this->load_from_cache();
		if($loaded) return;

		$parse_error_log = '';

		 ###########################################
		# Parse the file types configuration file
		$this->languages = array();
		while($line = $this->get_conf_line("$this->conf_path/$this->conf_file")) {
			# The code must be a lower-case two-letter Languages code
			$code = strtolower(substr(strtok($line," \t"),0,2));
			if(!ereg("^[a-z][a-z]$",$code)) {
				$parse_error_log .= "'$code' is not a valid language code.\n";
			} else {
				$this->languages[$code] = strtok("\n");
			}
		}
		# Errors found, die.
		if ($parse_error_log) {
			report_error(__FILE__,__LINE__,"<B>Parsing configuration file:</b><br><br>$parse_error_log");
			exit();
		}

		# Write the cache
		$this->save_to_cache();

	}

	 ###############################################
	# Given a comma-separated list of language code,
	# returns a comma-separated list of language names
	function name_list($codes) {
		$codes = split("[ \t]*[\,\;][ \t]*",$codes);
		foreach($codes as $code) {
			$result .= "{$this->languages[$code]}, ";
		}
		return substr($result,0,-2);
	}
}


 ################################################
# Popular Character Sets and their Descriptions
class Config_Charsets extends Config {

	var $charsets;

	function load() {

		 ############################
		# Can we load from cache ?
		$loaded = $this->load_from_cache();
		if($loaded) return;

		$parse_error_log = '';

		 ###########################################
		# Parse the file types configuration file
		$this->charsets = array();
		while($line = $this->get_conf_line("$this->conf_path/$this->conf_file")) {
			# The code must be a lower-case two-letter Languages code
			$code = strtolower(strtok($line," \t"));
			$this->charsets[$code] = strtok("\n");
		}
		# Errors found, die.
		if ($parse_error_log) {
			report_error(__FILE__,__LINE__,"<B>Parsing configuration file:</b><br><br>$parse_error_log");
			exit();
		}

		# Write the cache
		$this->save_to_cache();
	}

}

?>
