<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006-2008 Malcolm Cowe
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

include("../inc/inc.Settings.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.FileUtils.php");
include("../inc/inc.Utils.php");
include("../inc/inc.Language.php");
include("../inc/inc.ClassUI.php");
include("../inc/inc.Authentication.php");

if (!isset($_GET["documentid"]) || !is_numeric($_GET["documentid"]) || intval($_GET["documentid"])<1) {
	UI::htmlStartPage(getMLText("document_title", array("documentname" => getMLText("invalid_doc_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_doc_id"));
	UI::htmlEndPage();
	exit;
}

$documentid = $_GET["documentid"];
$document = getDocument($documentid);
if (!is_object($document)) {
	UI::htmlStartPage(getMLText("document_title", array("documentname" => getMLText("invalid_doc_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_doc_id"));
	UI::htmlEndPage();
	exit;
}

$folder = $document->getFolder();
$docPathHTML = getFolderPathHTML($folder, true). " / ".$document->getName();

UI::htmlStartPage(getMLText("document_title", array("documentname" => $document->getName())));
UI::globalNavigation($folder);
UI::pageNavigation($docPathHTML, "view_document");

if ($document->getAccessMode($user) < M_READ) {
	UI::contentContainer(getMLText("access_denied"));
	UI::htmlEndPage();
	exit;
}

$versions = $document->getContent();
$latestContent = $document->getLatestContent();
$status = $latestContent->getStatus();
$reviewStatus = $latestContent->getReviewStatus();
$approvalStatus = $latestContent->getApprovalStatus();

UI::contentHeading(getMLText("document_infos"));
UI::contentContainerStart();
?>
<table>
<tr>
<td><?php printMLText("owner");?>:</td>
<td>
<?php
$owner = $document->getOwner();
print "<a class=\"infos\" href=\"mailto:".$owner->getEmail()."\">".$owner->getFullName()."</a>";
?>
</td>
</tr>
<tr>
<td><?php printMLText("comment");?>:</td>
<td><?php print $document->getComment();?></td>
</tr>
<tr>
<td><?php printMLText("creation_date");?>:</td>
<td><?php print getLongReadableDate($document->getDate()); ?></td>
</tr>
<tr>
<td><?php printMLText("keywords");?>:</td>
<td><?php print $document->getKeywords();?></td>
</tr>
<?php
if ($document->isLocked()) {
	$lockingUser = $document->getLockingUser();
?>
<tr>
	<td><?php printMLText("lock_status");?>:</td>
	<td><?php printMLText("lock_message", array("email" => $lockingUser->getEmail(), "username" => $lockingUser->getFullName()));?></td>
</tr>
<?php
}
?>
</tr>
</table>
<?php
UI::contentContainerEnd();

UI::contentHeading(getMLText("current_version"));
UI::contentContainerStart();
print "<table class=\"folderView\">";
print "<thead>\n<tr>\n";
print "<th></th>\n";
print "<th>".getMLText("version")."</th>\n";
print "<th>".getMLText("file")."</th>\n";
print "<th>".getMLText("comment")."</th>\n";
print "<th>".getMLText("status")."</th>\n";
print "<th>".getMLText("actions")."</th>\n";
print "</tr>\n</thead>\n<tbody>\n";
print "<tr>\n";
print "<td><ul class=\"actions\">";
print "<li class=\"first\"><a href=\"../op/op.Download.php?documentid=".$documentid."&version=".$latestContent->getVersion()."\"><img src=\"images/download.gif\" class=\"mimeicon\"></a><a href=\"../op/op.Download.php?documentid=".$documentid."&version=".$latestContent->getVersion()."\">".getMLText("download")."</a></dt>";
if ($latestContent->viewOnline())
	print "<li><a target=\"_blank\" href=\"../op/viewonline" . $latestContent->getURL()."\"><img src=\"images/view.gif\" class=\"mimeicon\">" . getMLText("view_online") . "</a></dt>";
print "</ul></td>\n";
print "<td class=\"center\">".$latestContent->getVersion()."</td>\n";
print "<td><dl class=\"documentDetail\">\n";
print "<dt><img class=\"mimeicon\" src=\"images/icons/".UI::getMimeIcon($latestContent->getFileType())."\" title=\"".$latestContent->getMimeType()."\"> ".
	$latestContent->getOriginalFileName() ."</dt>\n";
print "<dd>". filesize($settings->_contentDir . $latestContent->getPath()) ." bytes</dd>\n";
print "<dd>".$latestContent->getMimeType()."</dd>";
$updatingUser = $latestContent->getUser();
print "<dd>".getMLText("uploaded")." ".getLongReadableDate($latestContent->getDate())." by <a href=\"mailto:".$updatingUser->getEmail()."\">".$updatingUser->getFullName()."</a></dd>";
print "<dd>".(!$document->getExpires() ? getMLText("does_not_expire") : getMLText("expires").": ".getReadableDate($document->getExpires()))."</dd>";
print "</dl>";
print "<td>".$latestContent->getComment()."</td>";
print "<td>".getOverallStatusText($status["status"])."</td>";
print "<td>";

$notFirst = false;
$noActions = true;
print "<ul class=\"actions\">";
if ($document->getAccessMode($user) == M_ALL) {
	print "<li class=\"first\"><a href='../out/out.OverrideContentStatus.php?documentid=".$documentid."&version=".$latestContent->getVersion()."'>Change Status</a></li>";
	print "<li><a href='../out/out.SetReviewersApprovers.php?documentid=".$documentid."&version=".$latestContent->getVersion()."'>Change Assignments</a></li>";
	$notFirst = true;
	$noActions = false;
}
if (($document->getAccessMode($user) >= M_READWRITE) && (count($versions) > 1)) {
	print "<li".($notFirst ? "" : " class=\"first\"")."><a href=\"out.RemoveVersion.php?documentid=".$documentid."&version=".$latestContent->getVersion()."\">".getMLText("delete")."</a></li>";
	$noActions = false;
}

//
// Display a link if the user is a reviewer or approver for this document.
//
$userRStat = $user->getReviewStatus($documentid, $latestContent->getVersion());
$userAStat = $user->getApprovalStatus($documentid, $latestContent->getVersion());
$is_reviewer = false;
$is_approver = false;

if (!is_bool($userRStat)) {
	if (count($userRStat["indstatus"])>0) {
		if ($userRStat["indstatus"][0]["status"]==0) {
			$is_reviewer = true;
		}
	}
	else {
		foreach ($userRStat["grpstatus"] as $grpstatus) {
			if ($grpstatus["status"]==0) {
				$is_reviewer = true;
				break;
			}
		}
	}
}
if (!is_bool($userAStat)) {
	if (count($userAStat["indstatus"])>0) {
		if ($userAStat["indstatus"][0]["status"]==0) {
			$is_approver = true;
		}
	}
	else {
		foreach ($userAStat["grpstatus"] as $grpstatus) {
			if ($grpstatus["status"]==0) {
				$is_approver = true;
				break;
			}
		}
	}
}
if ($is_reviewer && ($status["status"]!=1 || !$is_approver)) {
	print "<li".($notFirst ? "" : " class=\"first\"")."><a href=\"../out/out.ReviewDocument.php?documentid=".$documentid."&version=".$latestContent->getVersion()."\">".getMLText("submit_review")."</a></li>";
}
if ($is_approver && $status["status"]!=0) {
	print "<li".($notFirst ? "" : " class=\"first\"")."><a href=\"../out/out.ApproveDocument.php?documentid=".$documentid."&version=".$latestContent->getVersion()."\">".getMLText("submit_approval")."</a></li>";
}

if ($noActions) {
	print "<li class=\"first\">-</li>";
}
print "</ul>";
echo "</td>";
print "</tr></tbody>\n</table>\n";

UI::contentSubHeading(getMLText("reviewers"));
print "<table class=\"folderView\">\n";
print "<thead>\n<tr>\n";
print "<th>".getMLText("name")."</th>\n";
print "<th>".getMLText("status")."</th>\n";
print "<th>".getMLText("comment")."</th>";
print "<th>".getMLText("last_update")."</th>\n";
print "</tr>\n</thead>\n<tbody>\n";
if (is_array($reviewStatus) && count($reviewStatus)>0) {
	foreach ($reviewStatus as $r) {
		if ($r["status"]!=-2) {
			$required = null;
			switch ($r["type"]) {
				case 0: // Reviewer is an individual.
					$required = getUser($r["required"]);
					if (!is_object($required)) {
						$reqName = getMLText("unknown_user")." '".$r["required"]."'";
					}
					else {
						$reqName = "[I] ".$required->getFullName();
					}
					break;
				case 1: // Reviewer is a group.
					$required = getGroup($r["required"]);
					if (!is_object($required)) {
						$reqName = getMLText("unknown_group")." '".$r["required"]."'";
					}
					else {
						$reqName = "[G] ".$required->getName();
					}
					break;
			}
			print "<tr>\n";
			print "<td>".$reqName."</td>\n";
			print "<td>".getReviewStatusText($r["status"])."</td>\n";
			print "<td>".$r["comment"]."</td>\n";
			print "<td>".$r["date"];
			$updateUser = getUser($r["userID"]);
			print " by ".(is_object($updateUser) ? $updateUser->getFullName() : "unknown user id '".$r["userID"]."'");
			print "</td>\n</tr>\n";
		}
	}
}
else {
	print "<tr><td colspan=4>".getMLText("no_reviewers")."</td></tr>\n";
}
print	"</tbody>\n</table>\n";

UI::contentSubHeading(getMLText("approvers"));
print "<table class=\"folderView\">\n";
print "<thead>\n<tr>\n";
print "<th>".getMLText("name")."</th>\n";
print "<th>".getMLText("status")."</th>\n";
print "<th>".getMLText("comment")."</th>";
print "<th>".getMLText("last_update")."</th>\n";
print "</tr>\n</thead>\n<tbody>\n";
if (is_array($approvalStatus) && count($approvalStatus)>0) {
	foreach ($approvalStatus as $a) {
		if ($a["status"]!=-2) {
			$required = null;
			switch ($a["type"]) {
				case 0: // Approver is an individual.
					$required = getUser($a["required"]);
					if (!is_object($required)) {
						$reqName = getMLText("unknown_user")." '".$r["required"]."'";
					}
					else {
						$reqName = "[I] ".$required->getFullName();
					}
					break;
				case 1: // Approver is a group.
					$required = getGroup($a["required"]);
					if (!is_object($required)) {
						$reqName = getMLText("unknown_group")." '".$r["required"]."'";
					}
					else {
						$reqName = "[G] ".$required->getName();
					}
					break;
			}
			print "<tr>\n";
			print "<td>".$reqName."</td>\n";
			print "<td>".getApprovalStatusText($a["status"])."</td>\n";
			print "<td>".$a["comment"]."</td>\n";
			print "<td>".$a["date"];
			$updateUser = getUser($a["userID"]);
			print " by ".(is_object($updateUser) ? $updateUser->getFullName() : "unknown user id '".$a["userID"]."'");
			print "</td>\n</tr>\n";
		}
	}
}
else {
	print "<tr><td colspan=4>".getMLText("no_approvers")."</td></tr>\n";
}
print	"</tbody>\n</table>\n";
UI::contentContainerEnd();

UI::contentHeading(getMLText("previous_versions"));
UI::contentContainerStart();
print "<table class=\"folderView\">";
print "<thead>\n<tr>\n";
print "<th></th>\n";
print "<th>".getMLText("version")."</th>\n";
print "<th>".getMLText("file")."</th>\n";
print "<th>".getMLText("comment")."</th>\n";
print "<th>".getMLText("status")."</th>\n";
print "<th>".getMLText("actions")."</th>\n";
print "</tr>\n</thead>\n<tbody>\n";

if (count($versions)>1) {
	for ($i = count($versions)-2; $i >= 0; $i--) {
		$version = $versions[$i];
		$vstat = $version->getStatus();
		$comment = $version->getComment();
		//if (strlen($comment) > 25) $comment = substr($comment, 0, 22) . "...";
		print "<tr>\n";
		print "<td><ul class=\"actions\">";
		print "<li class=\"first\"><a href=\"../op/op.Download.php?documentid=".$documentid."&version=".$version->getVersion()."\"><img src=\"images/download.gif\" class=\"mimeicon\"></a><a href=\"../op/op.Download.php?documentid=".$documentid."&version=".$version->getVersion()."\">".getMLText("download")."</a></dt>";
		if ($version->viewOnline())
			print "<li><a target=\"_blank\" href=\"../op/viewonline" . $version->getURL()."\"><img src=\"images/view.gif\" class=\"mimeicon\">" . getMLText("view_online") . "</a></dt>";
		print "</ul></td>\n";
		print "<td class=\"center\">".$version->getVersion()."</td>\n";
		print "<td><dl class=\"documentDetail\">\n";
		print "<dt><img class=\"mimeicon\" src=\"images/icons/".UI::getMimeIcon($version->getFileType())."\" title=\"".$version->getMimeType()."\"> ".
			$version->getOriginalFileName() ."</dt>\n";
		print "<dd>". filesize($settings->_contentDir . $version->getPath()) ." bytes</dd>\n";
		print "<dd>".$version->getMimeType()."</dd>";
		$updatingUser = $version->getUser();
		print "<dd>".getMLText("uploaded")." ".getLongReadableDate($version->getDate())." by <a href=\"mailto:".$updatingUser->getEmail()."\">".$updatingUser->getFullName()."</a></dd>";
		print "</dl>";
		print "<td>".$version->getComment()."</td>";
		print "<td>".getOverallStatusText($vstat["status"])."</td>";
		print "<td>";
		print "<ul class=\"actions\">";
		print "<li class=\"first\"><a href='../out/out.DocumentVersionDetail.php?documentid=".$documentid."&version=".$version->getVersion()."'>View Detail</a></li>";
		if (($document->getAccessMode($user) >= M_READWRITE)) {
			$notFirst = false;
			if ($document->getAccessMode($user) == M_ALL) {
				print "<li><a href='../out/out.OverrideContentStatus.php?documentid=".$documentid."&version=".$version->getVersion()."'>Change Status</a></li>";
				print "<li><a href='../out/out.SetReviewersApprovers.php?documentid=".$documentid."&version=".$version->getVersion()."'>Change Assignments</a></li>";
				$notFirst = true;
			}
			if (($document->getAccessMode($user) >= M_READWRITE) && (count($versions) > 1)) {
				print "<li". ($notFirst ? "" : " class=\"first\"")."><a href=\"out.RemoveVersion.php?documentid=".$documentid."&version=".$version->getVersion()."\">".getMLText("delete")."</a></li>";
			}
		}
		print "</ul>";
		echo "</td>\n</tr>\n";
	}
}
else {
	print "<tr><td colspan=6>".getMLText("no_previous_versions")."</td></tr>";
}
print "</tbody>\n</table>\n";

UI::contentContainerEnd();

UI::contentHeading(getMLText("linked_documents"));
UI::contentContainerStart();
$links = $document->getDocumentLinks();
$links = filterDocumentLinks($user, $links);
print "<table class=\"folderView\">";
print "<thead>\n<tr>\n";
print "<th></th>\n";
print "<th>".getMLText("name")."</th>\n";
print "<th>".getMLText("comment")."</th>\n";
print "<th>".getMLText("document_link_by")."</th>\n";
print "<th>".getMLText("document_link_public")."</th>\n";
print "</tr>\n</thead>\n<tbody>\n";
if (count($links) > 0) {
	foreach($links as $link) {
		$responsibleUser = $link->getUser();
		$targetDoc = $link->getTarget();

		print "<tr>";
		print "<td><img src=\"images/file.gif\" class=\"mimeicon\"></td>";
		print "<td><a href=\"out.ViewDocument.php?documentid=".$targetDoc->getID()."\" class=\"linklist\">".$targetDoc->getName()."</a></td>";
		print "<td>".$targetDoc->getComment()."</td>";
		print "<td>".$responsibleUser->getFullName()."</td>";
		print "<td>" . (($link->isPublic()) ? getMLText("yes") : getMLText("no")) . "</td>";
		print "<td>";
		if (($user->getID() == $responsibleUser->getID()) || ($user->getID() == $settings->_adminID) || ($link->isPublic() && ($document->getAccessMode($user) >= M_READWRITE )))
			print "<a href=\"../op/op.RemoveDocumentLink.php?documentid=".$documentid."&linkid=".$link->getID()."\"><img src=\"images/del.gif\" border=0></a>";
		print "</td>";
		print "</tr>";
	}
}
else {
	print "<tr><td colspan=\"5\">".getMLText("no_document_links")."</td></tr>";
}
print "</tbody>\n</table>\n";

if ($user->getID() != $settings->_guestID) {
	UI::contentSubHeading(getMLText("add_link"));
?>
	<form action="../op/op.AddDocumentLink.php" name="form1">
	<input type="Hidden" name="documentid" value="<?php print $documentid;?>">
	<table>
	<tr>
	<td><?php printMLText("choose_target_document");?>:</td>
	<td><?php UI::printDocumentChooser("form1");?></td>
	</tr>
	<?php
	if ($document->getAccessMode($user) >= M_READWRITE) {
		print "<tr><td>".getMLText("document_link_public")."</td>";
		print "<td><ul class=\"actions\">";
		print "<li class=\"first\"><input type=\"Radio\" name=\"public\" value=\"true\" checked>" . getMLText("yes")."</li>";
		print "<li><input type=\"Radio\" name=\"public\" value=\"false\">" . getMLText("no")."</li>";
		print "</ul></td></tr>";
	}
	?>
	<tr>
	<td colspan="2"><input type="Submit" value="<?php printMLText("add_document_link");?>"></td>
	</tr>
	</table>
	</form>
<?php
}
UI::contentContainerEnd();
UI::htmlEndPage();
?>
