<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006-2008 Malcolm Cowe
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

include("../inc/inc.Settings.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.ClassKeywords.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.FileUtils.php");
include("../inc/inc.Language.php");
include("../inc/inc.ClassUI.php");
include("../inc/inc.Authentication.php");

UI::htmlStartPage(getMLText("personal_default_keywords"));
UI::globalNavigation();
UI::pageNavigation(getMLText("personal_default_keywords"), "edit_user");

if (isset($_POST["action"])) {
	$action = sanitizeString($_POST["action"]);
}
else {
	$action = sanitizeString($_GET["action"]);
}

//Neue Kategorie anlegen -----------------------------------------------------------------------------
if ($action == "addcategory") {
	UI::contentHeading(getMLText("new_default_keyword_category"));
	UI::contentContainerStart();
	printMLText("creating_new_default_keyword_category");
	if (isset($_POST["name"])) {
		$name = sanitizeString($_POST["name"]);
	}
	else {
		$name = sanitizeString($_GET["name"]);
	}
	
	$newCategory = addKeywordCategory($user->getID(), $name);
	if ($newCategory) {
		printMLText("op_finished");
	}
	else {
		printMLText("error_occured");
	}
	UI::contentContainerEnd();
}

//Kategorie lschen ----------------------------------------------------------------------------------
else if ($action == "removecategory") {
	if (isset($_POST["categoryid"])) {
		$categoryid = sanitizeString($_POST["categoryid"]);
	}
	else {
		$categoryid = sanitizeString($_GET["categoryid"]);
	}
	$category = getKeywordCategory($categoryid);
	if (is_object($category)) {
		$owner    = $category->getOwner();
		UI::contentHeading(getMLText("rm_default_keyword_category").": ".$category->getName());
		UI::contentContainerStart();
		printMLText("removing_default_keyword_category");
		if ($owner->getID() != $user->getID()) {
			print ("You are not allowed to delete this category.");
			UI::contentContainerEnd();
			UI::htmlEndPage();
			exit;
		}
		if ($category->remove()) {
			printMLText("op_finished");
		}
		else {
			UI::contentHeading(getMLText("rm_default_keyword_category"));
			UI::contentContainerStart();
			printMLText("error_occured");
		}
	}
	else {
		UI::contentHeading(getMLText("rm_default_keyword_category"));
		UI::contentContainerStart();
		printMLText("error_occured");
	}
	UI::contentContainerEnd();
}

//Kategorie bearbeiten: Neuer Name --------------------------------------------------------------------
else if ($action == "editcategory") {
	UI::contentHeading(getMLText("edit_default_keyword_category"));
	UI::contentContainerStart();
	printMLText("editing_default_keyword_category");
	
	if (isset($_POST["categoryid"])) {
		$categoryid = sanitizeString($_POST["categoryid"]);
	}
	else {
		$categoryid = sanitizeString($_GET["categoryid"]);
	}
	$category = getKeywordCategory($categoryid);
	if (is_object($category)) {
		$owner = $category->getOwner();
		if ($owner->getID() != $user->getID()) {
			print("You're not allowed to edit this category");
			UI::contentContainerEnd();
			UI::htmlEndPage();
			exit;
		}
		if (isset($_POST["name"])) {
			$name = sanitizeString($_POST["name"]);
		}
		else {
			$name = sanitizeString($_GET["name"]);
		}

		if ($category->setName($name)) {
			printMLText("op_finished");
		}
		else {
			printMLText("error_occured");
		}
	}
	else {
		printMLText("error_occured");
	}
	UI::contentContainerEnd();
}

//Kategorie bearbeiten: Neue Stichwortliste  ----------------------------------------------------------
else if ($action == "newkeywords") {
	UI::contentHeading(getMLText("new_default_keywords"));
	UI::contentContainerStart();
	printMLText("adding_default_keywords");
	
	if (isset($_POST["categoryid"])) {
		$categoryid = sanitizeString($_POST["categoryid"]);
	}
	else {
		$categoryid = sanitizeString($_GET["categoryid"]);
	}
	$category = getKeywordCategory($categoryid);
	if (is_object($category)) {
		$owner    = $category->getOwner();
		if ($owner->getID() != $user->getID()) {
			print("You're not allowed to add keywords to this category");
			UI::contentContainerEnd();
			UI::htmlEndPage();
			exit;
		}

		if (isset($_POST["keywords"])) {
			$keywords = sanitizeString($_POST["keywords"]);
		}
		else {
			$keywords = sanitizeString($_GET["keywords"]);
		}
		if ($category->addKeywordList($keywords)) {
			printMLText("op_finished");
		}
		else {
			printMLText("error_occured");
		}
	}
	else {
		printMLText("error_occured");
	}
	UI::contentContainerEnd();
}

//Kategorie bearbeiten: Stichwortliste bearbeiten ----------------------------------------------------------
else if ($action == "editkeywords") {
	UI::contentHeading(getMLText("edit_default_keywords"));
	UI::contentContainerStart();
	printMLText("editing_default_keywords");

	if (isset($_POST["categoryid"])) {
		$categoryid = sanitizeString($_POST["categoryid"]);
	}
	else {
		$categoryid = sanitizeString($_GET["categoryid"]);
	}
	$category = getKeywordCategory($categoryid);
	if (is_object($category)) {
		$owner = $category->getOwner();
		if ($owner->getID() != $user->getID()) {
			print ("You're not allowed to edit keywords in this category");
			UI::contentContainerEnd();
			UI::htmlEndPage();
			exit;
		}

		if (isset($_POST["keywordsid"])) {
			$keywordsid = sanitizeString($_POST["keywordsid"]);
		}
		else {
			$keywordsid = sanitizeString($_GET["keywordsid"]);
		}
		if (!is_numeric($keywordsid)) {
			print ("invalid keywords id");
			UI::contentContainerEnd();
			UI::htmlEndPage();
			exit;
		}
		if ($category->editKeywordList($keywordsid, $keywords)) {
			printMLText("op_finished");
		}
		else {
			printMLText("error_occured");
		}
	}
	else {
		printMLText("error_occured");
	}
	UI::contentContainerEnd();
}

//Kategorie bearbeiten: Neue Stichwortliste lschen ----------------------------------------------------------
else if ($action == "removekeywords") {
	UI::contentHeading(getMLText("rm_default_keywords"));
	UI::contentContainerStart();
	printMLText("removing_default_keywords");

	if (isset($_POST["categoryid"])) {
		$categoryid = sanitizeString($_POST["categoryid"]);
	}
	else {
		$categoryid = sanitizeString($_GET["categoryid"]);
	}
	$category = getKeywordCategory($categoryid);
	if (is_object($category)) {
		$owner    = $category->getOwner();
		if ($owner->getID() != $user->getID()) {
			print("You're not allowed to remove keywords from this category");
			UI::contentContainerEnd();
			UI::htmlEndPage();
			exit;
		}
		if (isset($_POST["keywordsid"])) {
			$keywordsid = sanitizeString($_POST["keywordsid"]);
		}
		else {
			$keywordsid = sanitizeString($_GET["keywordsid"]);
		}
		if (!is_numeric($keywordsid)) {
			print ("invalid keywords id");
			UI::contentContainerEnd();
			UI::htmlEndPage();
			exit;
		}
		if ($category->removeKeywordList($keywordsid)) {
			printMLText("op_finished");
		}
		else {
			printMLText("error_occured");
		}
	}
	else {
		printMLText("error_occured");
	}
	UI::contentContainerEnd();
}

UI::htmlEndPage();
?>
