<?
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
include("../inc/inc.Settings.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.Language.php");
include("../inc/inc.OutUtils.php");
include("../inc/inc.Authentication.php");

$document = getDocument($documentid);


if ($document->getAccessMode($user) < M_READ)
{
	printHTMLHead( getMLText("download") );
	printCenterStart();
	printStartBox(getMLText("download"));
	print "<div class=\"standardText\">";
	printMLText("operation_not_allowed");
	printGoBack();
	print "</div>";
	printEndBox();
	printCenterEnd();
	printHTMLFoot();
	exit;
}

$content = $document->getContentByVersion($version);

if (is_bool($content) && !$content)
	die("Version " . $version . " of Document \"" . $document->getName() . "\" not found");

header("Content-Type: application/force-download; name=\"" . $content->getOriginalFileName() . "\"");
header("Content-Transfer-Encoding: binary");
header("Content-Length: " . filesize($settings->_contentDir . $content->getPath() ));
header("Content-Disposition: attachment; filename=\"" . $content->getOriginalFileName() . "\"");
header("Expires: 0");
//header("Content-Type: " . $content->getMimeType());
header("Cache-Control: no-cache, must-revalidate");
header("Pragma: no-cache");

readfile($settings->_contentDir . $content->getPath());
exit();
?>
