<?
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
include("../inc/inc.Settings.php");
include("../inc/inc.Utils.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.FileUtils.php");
include("../inc/inc.Language.php");
include("../inc/inc.OutUtils.php");
include("../inc/inc.Authentication.php");


$folder = getFolder($folderid);



printHTMLHead( getMLText("folder_title", array("foldername" => $folder->getName()) ) );
printTitleBar($folder);
printCenterStart();

printStartBox(getMLText("add_document"));

print "<div class=\"standardText\">";


if ($folder->getAccessMode($user) < M_READWRITE)
{
	printMLText("operation_not_allowed");
	printGoBack();
}
else
{
	if (!isset($userfile) || ($userfile == "none") || ($userfile == ""))
	{
		printMLText("uploading_failed");
		printGoBack();
	}
	else
	{
		printMLText("adding_document", array("documentname" => $name, "foldername" => $folder->getName()));
		
		$name     = sanitizeString($name);
		$comment  = sanitizeString($comment);
		$keywords = sanitizeString($keywords);
		$userfile_type = sanitizeString($userfile_type);
		$userfile_name = sanitizeString($userfile_name);
		if (!is_numeric($sequence))
			die ("invalid sequence value");
		
		$lastDotIndex = strrpos(basename($userfile_name), ".");
		if (is_bool($lastDotIndex) && !$lastDotIndex)
			$fileType = ".";
		else
			$fileType = substr($userfile_name, $lastDotIndex);
		
		$expires = ($expires == "true") ? mktime(0,0,0, $expmonth, $expday, $expyear) : false;
		
		$newDocument = $folder->addDocument($name, $comment, $expires, $user, $keywords, $userfile, basename($userfile_name), $fileType, $userfile_type, $sequence);
		
		if (is_bool($newDocument) && !$newDocument)
		{
			printMLText("error_occured");
			printGoBack();
		}
		else
		{
			printMLText("op_finished");
			printGoto(array(array($folder->getName(), "../out/out.ViewFolder.php?folderid=".$folder->getID()), 
					array($newDocument->getName(), "../out/out.ViewDocument.php?documentid=".$newDocument->getID())));
		}
	}
}



print "</div>";
printEndBox();
printCenterEnd();
printHTMLFoot();
?>
