# library.py
#
#   Copyright (C) 2003 Daniel Burrows <dburrows@debian.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# Code to manage a library.  A library is just a collection of files
# that happen to live under one or more directories.

import filestore
import sets

class MusicLibrary:
    def __init__(self, store, dirs, callbacks):
        """Initialize a library for the given list of directories.  The
        list of callbacks corresponds to the list of directories."""

        self.dirs=dirs

        self.files=sets.Set()
        # We use the add_dir function in this way because, frankly,
        # it's fast enough and a lot easier than making a fancy
        # database that's indexed by filename *and* efficient; this
        # also avoids the issue of changes on-disk for now.
        #
        # In the future, I may want to have a full mirror of the
        # on-disk structure, though, so that I can use fam to detect
        # added and removed files.  (?)
        self.store=store

        self.add_dirs(dirs, callbacks)

    def add_dirs(self, dirs, callbacks):
        """Add the given directories to this library.  Mainly meant to
        be used to set the directory list of the library after initializing
        the library object for better exception handling."""

        failed=[]
        for dir,callback in zip(dirs, callbacks):
            try:
                self.store.add_dir(dir, callback, self.files)
                self.dirs.append(dir)
            except filestore.LoadError,e:
                failed+=e.failed

        if failed <> []:
            raise filestore.LoadError(failed)

    def commit(self, callback):
        self.store.commit(callback, self.files)

    def revert(self, callback):
        self.store.revert(callback, self.files)

    def modified_count(self):
        return self.store.modified_count(self.files)
