//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: organgui.h,v 1.6 2004/02/24 19:30:06 wschweer Exp $
//
//  (C) Copyright 2001-2004 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __ORGANGUI_H__
#define __ORGANGUI_H__

#include "organguibase.h"
#include "organ.h"
#include "libsynti/gui.h"
#include "libsynti/mpevent.h"

class QSignalMapper;

#define NUM_GUI_CONTROLLER 18

//---------------------------------------------------------
//   OrganGui
//---------------------------------------------------------

class OrganGui : public OrganGuiBase, public MessGui {
      Q_OBJECT

      QSignalMapper* map;
      SynthGuiCtrl dctrl[NUM_GUI_CONTROLLER];
      void setParam(int, int);
      virtual void processEvent(const MidiPlayEvent&);

   private slots:
      void ctrlChanged(int idx);
      void readMessage(int);

   public:
      OrganGui();
      };

#endif

