//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: listedit.h,v 1.3.2.1 2005/03/06 01:27:07 qknight Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __LIST_EDIT_H__
#define __LIST_EDIT_H__

#include "midieditor.h"
#include "noteinfo.h"
#include "cobject.h"

class Event;
class MidiTrack;
class PartList;
class MidiPart;
class MidiPart;
class Xml;
class QActionGroup;
class QAction;
class QListView;
class QListViewItem;

//---------------------------------------------------------
//   ListEdit
//---------------------------------------------------------

class ListEdit : public MidiEditor {
      QListView* liste;
      QPopupMenu* menuEdit;
      QActionGroup* insertItems;
      QToolBar* listTools;
      MidiTrack* curTrack;
      MidiPart* curPart;
      int curPartId;

      enum { CMD_DELETE };

      Q_OBJECT
      virtual void closeEvent(QCloseEvent*);
      virtual void keyPressEvent(QKeyEvent*);
      void initShortcuts();
      QAction *insertNote, *insertSysEx, *insertCtrl, *insertMeta, *insertCAfter, *insertPAfter;

   private slots:
      void editInsertNote();
      void editInsertSysEx();
      void editInsertCtrl();
      void editInsertMeta();
      void editInsertCAfter();
      void editInsertPAfter();
      void editEvent(Event&, MidiPart*);
      void selectionChanged();
      void doubleClicked(QListViewItem*);
      void cmd(int cmd);
      void configChanged();

   public slots:
      void songChanged(int);

   signals:
      void deleted(int);

   public:
      ListEdit(PartList*);
      ~ListEdit();
      virtual void readStatus(Xml&);
      virtual void writeStatus(int, Xml&) const;
      };

#endif

