  //=========================================================
  //  MusE
  //  Linux Music Editor
  //  $Id: alsatimer.cpp,v 1.1.2.5 2005/06/04 20:29:22 spamatica Exp $
  //
  //  Plenty of code borrowed from timer.c example in 
  //  alsalib 1.0.7
  //
  //  (C) Copyright 2004 Robert Jonsson (rj@spamatica.se)
  //=========================================================
        
  #include "alsatimer.h"
  
  
  AlsaTimer::AlsaTimer()
     {
  
     }
     
  AlsaTimer::~AlsaTimer()
    {
    }
  
  int AlsaTimer::initTimer()
    {
    if(TIMER_DEBUG)
      printf("AlsaTimer::initTimer()\n");
  
    int err;
    int devclass = SND_TIMER_CLASS_GLOBAL;
    int sclass = SND_TIMER_CLASS_NONE;
    int card = 0;
    int device = SND_TIMER_GLOBAL_SYSTEM;
    int subdevice = 0;
  
    snd_timer_id_alloca(&id);
    snd_timer_info_alloca(&info);
    snd_timer_params_alloca(&params);
  

    sprintf(timername, "hw:CLASS=%i,SCLASS=%i,CARD=%i,DEV=%i,SUBDEV=%i", devclass, sclass, card, device, subdevice);
    if ((err = snd_timer_open(&handle, timername, SND_TIMER_OPEN_NONBLOCK))<0) {
      fprintf(stderr, "timer open %i (%s)\n", err, snd_strerror(err));
      }
    
    if ((err = snd_timer_info(handle, info)) < 0) {
      fprintf(stderr, "timer info %i (%s)\n", err, snd_strerror(err));
      return -1;
      }
    
    snd_timer_params_set_auto_start(params, 1);
    snd_timer_params_set_ticks(params, 1);
      
    if ((err = snd_timer_params(handle, params)) < 0) {
      fprintf(stderr, "timer params %i (%s)\n", err, snd_strerror(err));
      return -1;
      }
    
    count = snd_timer_poll_descriptors_count(handle);
    fds = (pollfd *)calloc(count, sizeof(pollfd));
    if (fds == NULL) {
      fprintf(stderr, "malloc error\n");
      return -1;
      }
    if ((err = snd_timer_poll_descriptors(handle, fds, count)) < 0) {
      fprintf(stderr, "snd_timer_poll_descriptors error: %s\n", snd_strerror(err));
      return -1;
      }
    return fds->fd;
    }
  
  bool AlsaTimer::setTimerResolution(int resolution)
    {
    if(TIMER_DEBUG)
      printf("AlsaTimer::setTimerResolution\n");
    snd_timer_params_set_ticks(params, resolution);
    return true;    
    }
  
  bool AlsaTimer::setTimerTicks(int tick)
    {
    int err;
    
    if(TIMER_DEBUG)
      printf("AlsaTimer::setTimerTicks\n");

    //int setTick = 1024/tick +1;    
    int setTick = (1000000000 / snd_timer_info_get_resolution(info)) / tick + 1;
    
    if(TIMER_DEBUG)
      printf("Setting tick to %d\n", setTick);
    snd_timer_params_alloca(&params);
    snd_timer_params_set_auto_start(params, 1);
    snd_timer_params_set_ticks(params, setTick);
    if ((err = snd_timer_params(handle, params)) < 0) {
      fprintf(stderr, "timer params2 %i (%s)\n", err, snd_strerror(err));
      return -1;
      }
    
    return true;
    }
  
  int  AlsaTimer::getTimerResoltution()
    {
    return  snd_timer_info_get_resolution(info);
    }
        
  bool AlsaTimer::startTimer()
    {
    if(TIMER_DEBUG)
      printf("AlsaTimer::startTimer\n");
    int err;
    if ((err = snd_timer_start(handle)) < 0) {
      fprintf(stderr, "timer start %i (%s)\n", err, snd_strerror(err));
      return false;
      }
    return true;
    }
  
  bool AlsaTimer::stopTimer()
    {
    if(TIMER_DEBUG)
      printf("AlsaTimer::stopTimer\n");
    int err;
    if ((err = snd_timer_stop(handle)) < 0) {
      fprintf(stderr, "timer stop %i (%s)\n", err, snd_strerror(err));
      return false;
      }
    //snd_timer_close(handle);
    return true;
    }
        
  unsigned long  AlsaTimer::getTimerTicks(bool printTicks)
    {
    //if(TIMER_DEBUG)
    //  printf("AlsaTimer::getTimerTicks\n");
    snd_timer_read_t tr;
    tr.ticks = 0;
    while (snd_timer_read(handle, &tr, sizeof(tr)) == sizeof(tr)) {
              if (printTicks) {
                  printf("TIMER: resolution = %uns, ticks = %u\n",
                    tr.resolution, tr.ticks);
                  }
      }
    return tr.ticks;
    }
