//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: arranger.h,v 1.17.2.1 2005/06/21 19:16:08 lunar_shuttle Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __ARRANGER_H__
#define __ARRANGER_H__

#include <vector>

#include <qwidget.h>
#include <qheader.h>
#include <qwhatsthis.h>

#include "midieditor.h"
#include "pcanvas.h"

class QMainWindow;
class QToolButton;
class Header;
class TList;
class ScrollScale;
class QScrollBar;
class MTScale;
class Track;
class Xml;
class Splitter;
class LabelCombo;
class PosLabel;
class QCheckBox;
class QSpinBox;
class MidiTrackInfoBase;
class WaveTrackInfoBase;
class TLLayout;
class WidgetStack;
class AudioStrip;

//---------------------------------------------------------
//   TWhatsThis
//---------------------------------------------------------

class TWhatsThis : public QWhatsThis {
      Header* header;
   protected:
      QString text(const QPoint&);
   public:
      TWhatsThis(QWidget* parent, Header* h) : QWhatsThis(parent) {
            header = h;
            }
      };

//---------------------------------------------------------
//   WidgetStack
//---------------------------------------------------------

class WidgetStack : public QWidget {
      Q_OBJECT
      std::vector<QWidget*> stack;
      int top;

   public:
      WidgetStack(QWidget* parent, const char* name = 0);
      void raiseWidget(int idx);
      void addWidget(QWidget* w, int idx);
      QWidget* getWidget(int idx);
      QWidget* visibleWidget() const;
      int curIdx() const { return top; }
      QSize minimumSizeHint() const;
      };

//---------------------------------------------------------
//   Arranger
//---------------------------------------------------------

class Arranger : public QWidget {
      int _quant, _raster;
      PartCanvas* canvas;
      ScrollScale* hscroll;
      QScrollBar* vscroll;
      TList* list;
      Header* header;
      MTScale* time;
      QSpinBox* lenEntry;
      bool showTrackinfoFlag;

      WidgetStack* trackInfo;
      QScrollBar* infoScroll;
      MidiTrackInfoBase* midiTrackInfo;
      AudioStrip* waveTrackInfo;
      QWidget* noTrackInfo;
      TLLayout* tgrid;

      Track* selected;

      LabelCombo* typeBox;
      QToolButton* ib;
      int trackInfoType;
      Splitter* split;
      QPopupMenu* pop;
      int songType;
      PosLabel* cursorPos;
      QSpinBox* globalTempoSpinBox;

      int program, pan, volume;

      Q_OBJECT
      void genTrackInfo(QWidget* parent);
      void genMidiTrackInfo();
      void genWaveTrackInfo();
      void updateMidiTrackInfo();
      void switchInfo(int);

   private slots:
      void _setRaster(int);
      void songlenChanged(int);
      void showTrackInfo(bool);
      void trackSelectionChanged();
      void trackInfoScroll(int);

      void iNameChanged();
      void iInputChannelChanged(const QString&);
      void iOutputChannelChanged(int);
      void iInputPortChanged(const QString&);
      void iOutputPortChanged(int);
      void iProgramChanged();
      void iLautstChanged(int);
      void iTranspChanged(int);
      void iAnschlChanged(int);
      void iVerzChanged(int);
      void iLenChanged(int);
      void iKomprChanged(int);
      void iPanChanged(int);
      void songChanged(int);
      void modeChange(int);
      void instrPopup();
      void setTime(unsigned);
      void headerMoved();
      void globalPitchChanged(int);
      void globalTempoChanged(int);
      void setTempo50();
      void setTempo100();
      void setTempo200();
      void seek();
      void recordClicked();
      void verticalScrollSetYpos(unsigned);

   signals:
      void editPart(Track*);
      void selectionChanged();
      void dropSongFile(const QString&);
      void dropMidiFile(const QString&);
      void startEditor(PartList*, int);
      void toolChanged(int);
      void addMarker(int);
      void setUsedTool(int);

   public slots:
      void dclickPart(Track*);
      void setTool(int);
      void updateTrackInfo();
      void configChanged();

   public:
      enum { CMD_CUT_PART, CMD_COPY_PART, CMD_PASTE_PART };

      Arranger(QMainWindow* parent, const char* name = 0);
      void setMode(int);
      void reset();

      void writeStatus(int level, Xml&);
      void readStatus(Xml&);

      Track* curTrack() const { return selected; }
      void cmd(int);
      bool isSingleSelection() { return canvas->isSingleSelection(); }
      void setGlobalTempo(int);
      void clear();
      };

#endif

