//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: papersize.cpp,v 1.1.1.1 2003/10/29 10:05:29 wschweer Exp $
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#include <assert.h>

#include "papersize.h"
#include "globals.h"
#include "font.h"
#include "fontsel.h"

#include <qlayout.h>
#include <qgroupbox.h>
#include <qvgroupbox.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qbuttongroup.h>
#include <qtoolbutton.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qcheckbox.h>
#include <qdialog.h>

#define USER_SIZE 0
#define A4_SIZE   1

MMSpinBox::MMSpinBox(int v1, int v2, int step, int value, QWidget* parent)
   : QSpinBox(v1, v2, step, parent)
      {
      setSuffix(QString("mm"));
      setValue(value);
      }

//---------------------------------------------------------
//   mapValueToText
//---------------------------------------------------------

QString MMSpinBox::mapValueToText(int value)
      {
      return QString("%1.%2").arg(value/10).arg(value%10);
      }

//---------------------------------------------------------
//   mapTextToValue
//---------------------------------------------------------

int MMSpinBox::mapTextToValue(bool*)
      {
      return int(currentValueText().toFloat()*10.0);
      }

ScaleSpinBox::ScaleSpinBox(int v1, int v2, int step, int value, QWidget* parent)
   : QSpinBox(v1, v2, step, parent)
      {
      setValue(value);
      }

//---------------------------------------------------------
//   mapValueToText
//---------------------------------------------------------

QString ScaleSpinBox::mapValueToText(int value)
      {
      return QString("%1.%2").arg(value/100).arg(value%100);
      }

//---------------------------------------------------------
//   mapTextToValue
//---------------------------------------------------------

int ScaleSpinBox::mapTextToValue(bool*)
      {
      return int(currentValueText().toFloat()*100.0);
      }

//---------------------------------------------------------
//   PageSettings
//---------------------------------------------------------

PageSettings::PageSettings(QWidget* parent)
   : QDialog(parent)
      {
      bp = barsPage;

      setCaption(QString("MusE"));
      QVBoxLayout* layout = new QVBoxLayout(this);

      QGroupBox* g1 = new QGroupBox(4, Horizontal, tr("Paper Size"), this);

      a4 = new QRadioButton(QString("A4"), g1);
      new QLabel(QString("210"), g1);
      new QLabel(QString("x"), g1);
      new QLabel(QString("297"), g1);

      user = new QRadioButton(tr("user"), g1);
      u1 = new QLineEdit(g1);
      new QLabel(QString("x"), g1);
      u2 = new QLineEdit(g1);

      u1->setFixedWidth(35);
      u2->setFixedWidth(35);

      QGroupBox* g2 = new QGroupBox(4, Horizontal, tr("Margins"), this);
      sb1 = new MMSpinBox(-5000, 5000, 10, int(leftMargin*10), g2);
      new QLabel(tr("left Margin"), g2);
      sb2 = new MMSpinBox(-5000, 5000, 10, int(topMargin*10), g2);
      new QLabel(tr("top Margin"), g2);
      sb3 = new MMSpinBox(-5000, 5000, 10, int(rightMargin*10), g2);
      new QLabel(tr("right Margin"), g2);
      sb4 = new MMSpinBox(-5000, 5000, 10, int(bottomMargin*10), g2);
      new QLabel(tr("bottom Margin"), g2);

      QButtonGroup* bg = new QButtonGroup(g1);
      bg->hide();
      bg->insert(a4, A4_SIZE);
      bg->insert(user, USER_SIZE);
      connect(bg, SIGNAL(clicked(int)), SLOT(selectSize(int)));
      bg->setButton(A4_SIZE);
      selectSize(A4_SIZE);

      QGroupBox* w3 = new QGroupBox(2, Horizontal, tr("Header"), this);
      le1 = new QLineEdit(w3);
      new QLabel(tr("Title"), w3);
      le2 = new QLineEdit(w3);
      new QLabel(tr("Author"), w3);
      le3 = new QLineEdit(w3);
      w3->addSpace(0);
      w3->addSpace(0);
      w3->addSpace(0);

      //---------------------------------------------------
      QVGroupBox* fonts = new QVGroupBox(tr("Fonts"), this);
      fs1 = new FontSel(fonts, song->nameFont(),      tr("Title")     );
      fs2 = new FontSel(fonts, song->komponistFont(), tr("Author")    );
      fs3 = new FontSel(fonts, song->pageNoFont(),    tr("Page No.")  );
      fs4 = new FontSel(fonts, song->measureNoFont(), tr("Measure No"));
      fs5 = new FontSel(fonts, song->tracknameFont(), tr("Track Name"));
      fs6 = new FontSel(fonts, song->lyricsFont(),    tr("Lyrics"));

      QWidget* w6 = new QGroupBox(4, Horizontal, tr("Layout"), this);
      sb5 = new QSpinBox(1, 8, 1, w6);
      new QLabel(tr("Bars across the Page"), w6);
      sb5->setValue(barsPage);
      sb6 = new ScaleSpinBox(30, 500, 10, int(printScale*100.0), w6);
      new QLabel(tr("Scale"), w6);
      sb6->setValue(int(printScale*100.0));


      QWidget* w4 = new QGroupBox(1, Horizontal, tr("Flags"), this);
      cb1 = new QCheckBox(tr("show page no."), w4);
      cb2 = new QCheckBox(tr("show measure no."), w4);
      cb3 = new QCheckBox(tr("show track name"), w4);
      cb1->setChecked(song->showPageNo());
      cb2->setChecked(song->showMeasureNo());
      cb3->setChecked(song->showTrackname());

      le1->setText(song->name());
      le2->setText(song->komponist1());
      le3->setText(song->komponist2());

      layout->addWidget(g1);
      layout->addWidget(g2);
      layout->addWidget(w3);
      layout->addWidget(fonts);
      layout->addWidget(w6);
      layout->addWidget(w4);

      QBoxLayout* w5 = new QHBoxLayout;
      layout->addLayout(w5);

      QPushButton* okB     = new QPushButton(tr("Ok"), this);
      okB->setDefault(true);
      QPushButton* applyB  = new QPushButton(tr("Apply"), this);
      QPushButton* cancelB = new QPushButton(tr("Cancel"), this);
      okB->setFixedWidth(80);
      applyB->setFixedWidth(80);
      cancelB->setFixedWidth(80);
      w5->addWidget(okB);
      w5->addSpacing(12);
      w5->addWidget(applyB);
      w5->addSpacing(12);
      w5->addWidget(cancelB);
      w5->addStretch(1);

      connect(cancelB, SIGNAL(clicked()), SLOT(cancel()));
      connect(okB,     SIGNAL(clicked()), SLOT(ok()));
      connect(applyB,  SIGNAL(clicked()), SLOT(apply()));
      show();
      }

//---------------------------------------------------------
//   cancel
//---------------------------------------------------------

void PageSettings::cancel()
      {
      reject();
      }

//---------------------------------------------------------
//   ok
//---------------------------------------------------------

void PageSettings::ok()
      {
      apply();
      accept();
      }

//---------------------------------------------------------
//   apply
//---------------------------------------------------------

void PageSettings::apply()
      {
      song->setName(le1->text());
      song->setKomponist1(le2->text());
      song->setKomponist2(le3->text());
      if (paperSize == A4_SIZE) {
            paperWidth  = 210.0;
            paperHeight = 297.0;
            }
      else if (paperSize== USER_SIZE) {
            bool isOK1, isOK2;
            double w = u1->text().toDouble(&isOK1);
            double h = u1->text().toDouble(&isOK2);
            if (!isOK1 || !isOK2)
                  printf("bad papersize\n");
            else {
                  paperWidth  = w;
                  paperHeight = h;
                  }
            }
      leftMargin   = sb1->value() / 10.0;
      topMargin    = sb2->value() / 10.0;
      rightMargin  = sb3->value() / 10.0;
      bottomMargin = sb4->value() / 10.0;

      barsPage     = sb5->value();
      printScale   = sb6->value() / 100.0;

      song->setNameFont(fs1->font());
      song->setKomponistFont(fs2->font());
      song->setPageNoFont(fs3->font());
      song->setMeasureNoFont(fs4->font());
      song->setTracknameFont(fs5->font());
      song->setLyricsFont(fs6->font());

      song->setShowPageNo(cb1->isOn());
      song->setShowMeasureNo(cb2->isOn());
      song->setShowTrackname(cb3->isOn());
      song->update();
      }

//---------------------------------------------------------
//   selectSize
//---------------------------------------------------------

void PageSettings::selectSize(int id)
      {
      switch(id) {
            case A4_SIZE:
                  u1->setEnabled(false);
                  u2->setEnabled(false);
                  break;
            case USER_SIZE:
                  u1->setEnabled(true);
                  u2->setEnabled(true);
                  break;
            default:
                  assert(false);
                  break;
            }
      paperSize = id;
      }

