//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: prcanvas.h,v 1.1.1.1 2003/10/29 10:06:08 wschweer Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __PRCANVAS_H__
#define __PRCANVAS_H__

#include "ecanvas.h"
#include "pianoroll.h"

#define KH        13

//---------------------------------------------------------
//   NEvent
//    ''visual'' Note Event
//---------------------------------------------------------

class NEvent : public CItem {
   public:
      NEvent(Event* e, Part* p, int y);
      };

class ScrollScale;
class PianoRoll;
class QTextDrag;
class QRect;

//---------------------------------------------------------
//   PianoCanvas
//---------------------------------------------------------

class PianoCanvas : public EventCanvas {
      int cmdRange;
      int colorMode;
      int playedPitch;

      Q_OBJECT
      virtual void viewMouseDoubleClickEvent(QMouseEvent*);
      virtual void drawItem(QPainter&, const CItem*, const QRect&) const;
      virtual bool moveItem(CItem*, const QPoint&, DragType);
      virtual CItem* newItem(const QPoint&, int);
      virtual void resizeItem(CItem*, bool noSnap);
      virtual void newItem(CItem*, bool noSnap);
      virtual bool deleteItem(CItem*);
      virtual void startDrag(CItem* item, bool copymode);
      virtual void dragEnterEvent(QDragEnterEvent* event);
      virtual void dragMoveEvent(QDragMoveEvent*);
      virtual void dragLeaveEvent(QDragLeaveEvent*);
      virtual void viewDropEvent(QDropEvent* event);
      virtual void addItem(Part*, Event*);

      int y2pitch(int) const;
      int pitch2y(int) const;
      virtual void drawCanvas(QPainter&, const QRect&);
      void quantize(int, int, bool);
      void copy();
      void paste();
      void pasteAt(const QString& pt, int pos);
      QTextDrag* getTextDrag(QWidget*);
      virtual void itemPressed(const CItem*);
      virtual void itemReleased(const CItem*, const QPoint&);
      virtual void itemMoved(const CItem*, const QPoint&);
      virtual void curPartChanged();

   private slots:
      void midiNote(int pitch, int velo);

   signals:
      void quantChanged(int);
      void rasterChanged(int);

   public slots:
      void pianoCmd(int);
      void pianoPressed(int pitch, bool shift);
      void pianoReleased(int pitch, bool);

   public:
      enum {
         CMD_CUT, CMD_COPY, CMD_PASTE, CMD_DEL,
         CMD_OVER_QUANTIZE, CMD_ON_QUANTIZE, CMD_ONOFF_QUANTIZE,
         CMD_ITERATIVE_QUANTIZE,
         CMD_SELECT_ALL, CMD_SELECT_NONE, CMD_SELECT_INVERT,
         CMD_SELECT_ILOOP, CMD_SELECT_OLOOP,
         CMD_MODIFY_GATE_TIME, CMD_MODIFY_VELOCITY,
         CMD_CRESCENDO, CMD_TRANSPOSE, CMD_THIN_OUT, CMD_ERASE_EVENT,
         CMD_NOTE_SHIFT, CMD_MOVE_CLOCK, CMD_COPY_MEASURE,
         CMD_ERASE_MEASURE, CMD_DELETE_MEASURE, CMD_CREATE_MEASURE
         };

      PianoCanvas(MidiEditor*, QWidget*, int, int);
      void cmd(int, int, int, bool, int);
      void setColorMode(int mode) {
            colorMode = mode;
            redraw();
            }
      };
#endif

