/********************************************************************
 *                                                                  *
 * preferences.h                                                    *
 *                                                                  *
 ********************************************************************
 *                                                                  *
 * Authors:                                                         *
 *   Eirik A. Herskedal   <ehersked@cs.purdue.edu>                  *
 *                                                                  *
 ********************************************************************
 *                                                                  *
 * Declares a struct that contains the preferences parsed from      *
 * the configuration file.                                          *
 *                                                                  *
 ********************************************************************/

struct preferences {
  int debug;
  int certnumber;
  int pinnumber;
  char userpath[200];
  char certname[64];
  char rootcacert[200];
  char ldaphost[200];
  char ldappath[200];
  int authmode;
};

extern struct preferences pr;

#define USERCERT 0
#define ROOTCERT 1

#define DEBUGOFF 0
#define DEBUGON 1

/* Parse a configuration line */
void util_ParsePreference(char *buf, int buf_size);

/* Parse the configuration file */
int util_ReadPreferences();


