#ifndef MURRINE_TYPES_H
#define MURRINE_TYPES_H

typedef unsigned char boolean;
typedef unsigned char uint8;

typedef enum
{
	MRN_STATE_NORMAL,
	MRN_STATE_ACTIVE,
	MRN_STATE_SELECTED,
	MRN_STATE_INSENSITIVE
} MurrineStateType;

typedef enum
{
	MRN_CORNER_NONE        = 0,
	MRN_CORNER_TOPLEFT     = 1,
	MRN_CORNER_TOPRIGHT    = 2,
	MRN_CORNER_BOTTOMLEFT  = 4,
	MRN_CORNER_BOTTOMRIGHT = 8,
	MRN_CORNER_ALL         = 15
} MurrineCorners;

typedef enum
{
	MRN_JUNCTION_NONE      = 0,
	MRN_JUNCTION_BEGIN     = 1,
	MRN_JUNCTION_END       = 2
} MurrineJunction;

typedef enum
{
	MRN_STEPPER_UNKNOWN    = 0,
	MRN_STEPPER_A          = 1,
	MRN_STEPPER_B          = 2,
	MRN_STEPPER_C          = 4,
	MRN_STEPPER_D          = 8
} MurrineStepper;

typedef enum
{
	MRN_ORDER_FIRST,
	MRN_ORDER_MIDDLE,
	MRN_ORDER_LAST
} MurrineOrder;

typedef enum
{
	MRN_ORIENTATION_LEFT_TO_RIGHT,
	MRN_ORIENTATION_RIGHT_TO_LEFT,
	MRN_ORIENTATION_BOTTOM_TO_TOP,
	MRN_ORIENTATION_TOP_TO_BOTTOM
} MurrineOrientation;

typedef enum
{
	MRN_GAP_LEFT,
	MRN_GAP_RIGHT,
	MRN_GAP_TOP,
	MRN_GAP_BOTTOM
} MurrineGapSide;

typedef enum
{
	MRN_SHADOW_NONE,
	MRN_SHADOW_IN,
	MRN_SHADOW_OUT,
	MRN_SHADOW_ETCHED_IN,
	MRN_SHADOW_ETCHED_OUT,
	MRN_SHADOW_FLAT
} MurrineShadowType;

typedef enum
{
	MRN_HANDLE_TOOLBAR,
	MRN_HANDLE_SPLITTER
} MurrineHandleType;

typedef enum
{
	MRN_ARROW_NORMAL,
	MRN_ARROW_COMBO
} MurrineArrowType;

typedef enum
{
	MRN_DIRECTION_UP,
	MRN_DIRECTION_DOWN,
	MRN_DIRECTION_LEFT,
	MRN_DIRECTION_RIGHT
} MurrineDirection;

typedef enum
{
	MRN_PROGRESSBAR_CONTINUOUS,
	MRN_PROGRESSBAR_DISCRETE
} MurrineProgressBarStyle;

typedef enum
{
	MRN_WINDOW_EDGE_NORTH_WEST,
	MRN_WINDOW_EDGE_NORTH,
	MRN_WINDOW_EDGE_NORTH_EAST,
	MRN_WINDOW_EDGE_WEST,
	MRN_WINDOW_EDGE_EAST,
	MRN_WINDOW_EDGE_SOUTH_WEST,
	MRN_WINDOW_EDGE_SOUTH,
	MRN_WINDOW_EDGE_SOUTH_EAST  
} MurrineWindowEdge;

typedef struct
{
	double r;
	double g;
	double b;
} MurrineRGB;

typedef struct
{
	double x;
	double y;
	double width;
	double height;
} MurrineRectangle;

typedef struct
{
	MurrineRGB bg[5];
	MurrineRGB base[5];
	MurrineRGB text[5];
	
	MurrineRGB shade[9];
	MurrineRGB spot[3];
} MurrineColors;

typedef struct
{
	boolean active;
	boolean prelight;
	boolean disabled;
	boolean focus;
	boolean is_default;
	
	MurrineStateType state_type;
	
	int glazestyle;
	int roundness;
	double hilight_ratio;
	boolean gradients;
	
	uint8 corners;
	uint8 xthickness;
	uint8 ythickness;

	MurrineRGB parentbg;
} WidgetParameters;

typedef struct
{
	boolean inverted;
	int     fill_size;
	boolean horizontal;
} SliderParameters;

typedef struct
{
	MurrineOrientation orientation;
	MurrineProgressBarStyle style;
} ProgressBarParameters;

typedef struct
{
	int linepos;
} OptionMenuParameters;

typedef struct
{
	MurrineShadowType shadow;
	MurrineGapSide gap_side;
	int gap_x;
	int gap_width;
	MurrineRGB *border;
} FrameParameters;

typedef struct
{
	MurrineGapSide gap_side;
} TabParameters;

typedef struct
{
	MurrineCorners    corners;
	MurrineShadowType shadow;	
} ShadowParameters;

typedef struct
{
	boolean horizontal;
} SeparatorParameters;

typedef struct
{
	MurrineOrder   order;
	boolean        resizable;
	int 				   style;
} ListViewHeaderParameters;

typedef struct
{
	MurrineRGB         color;
	MurrineJunction 	 junction;       /* On which sides the slider junctions */
	MurrineStepper  	 steppers;       /* The visible steppers */
	boolean            horizontal;
	boolean            has_color;
	int								 style;
} ScrollBarParameters;

typedef struct
{
	MurrineHandleType type;
	boolean            horizontal; 
} HandleParameters;

typedef struct
{
	MurrineStepper stepper;         /* Which stepper to draw */
} ScrollBarStepperParameters;

typedef struct
{
	MurrineArrowType type;
	MurrineDirection direction;
} ArrowParameters;

typedef struct
{
	MurrineWindowEdge edge;
} ResizeGripParameters;

#define MURRINE_RECTANGLE_SET(rect, _x, _y, _w, _h) rect.x      = _x; \
                                                       rect.y      = _y; \
                                                       rect.width  = _w; \
                                                       rect.height = _h;

#endif /* MURRINE_TYPES_H */
