/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: sysfs.c,v 1.6 2004/09/12 07:58:16 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<string.h>
#include	<unistd.h>
#include	<limits.h>

#include	"murasaki.h"
#include	"murasaki_usb.h"

#define	WAIT_PROC_FILE	4

/*
 * We should observe the last created file on sysfs.
 * However, "bNumConfigurations" must be used for the old kernel.
 *
 * "iInterface" was modified to "bInterfaceProtocol" because
 *  "iInterface" was removed.
 *		Shun-ichi TAHARA <jado@flowernet.gr.jp>
 *		Takashi ISHIOKA <ishioka@ah.wakwak.com>
 */
int
get_sysfs_kind(mu_op_t *opp)
{
	char save_path[PATH_MAX+1], *path;
	int sleep_count;

	path = make_devpath(opp,"bNumConfigurations");
	strcpy(save_path,path);
	path = make_devpath(opp,"bInterfaceProtocol");
	for(sleep_count = 0;sleep_count < WAIT_PROC_FILE;sleep_count++) {
		if (access(save_path,R_OK) == 0)
			return MU_SYSFS_DEVICE;
		else if (access(path,R_OK) == 0)
			return MU_SYSFS_INTERFACE;
		else
			sleep(1);
	}
	return MU_SYSFS_INVALID;
}

int
get_sysfs_product(mu_op_t *opp)
{
	char *path;
	unsigned int value;
	MU_usb_config_t *config;

	config = (MU_usb_config_t *)opp->config;

	path = make_devpath(opp,"idVendor");
	if (SYSFS_VALUE16(path,&value,opp->msg_level) == INVALID)
		return INVALID;
	config->product.vendor = value;
	LOG_OPP_DESC("idVendor 0x%x",value);

	path = make_devpath(opp,"idProduct");
	if (SYSFS_VALUE16(path,&value,opp->msg_level) == INVALID)
		return INVALID;
	config->product.product = value;
	LOG_OPP_DESC("idProduct 0x%x",value);

	return GOOD;
}

int
get_sysfs_type(mu_op_t *opp)
{
	char *path;
	unsigned int value;
	MU_usb_config_t *config;

	config = (MU_usb_config_t *)opp->config;

	path = make_devpath(opp,"bDeviceClass");
	if (SYSFS_VALUE10(path,&value,opp->msg_level) == INVALID)
		return INVALID;
	config->device.class = value;
	LOG_OPP_DESC("bDeviceClass %d",value);

	path = make_devpath(opp,"bDeviceSubClass");
	if (SYSFS_VALUE10(path,&value,opp->msg_level) == INVALID)
		return INVALID;
	config->device.subclass = value;
	LOG_OPP_DESC("bDeviceSubClass %d",value);

	path = make_devpath(opp,"bDeviceProtocol");
	if (SYSFS_VALUE10(path,&value,opp->msg_level) == INVALID)
		return INVALID;
	config->device.protocol = value;
	LOG_OPP_DESC("bDeviceProtocol %d",value);

	return GOOD;
}

/*
 * Fix: "interface" member is used.
 *		Shun-ichi TAHARA <jado@flowernet.gr.jp>
 */
int
get_sysfs_interface(mu_op_t *opp)
{
	char *path;
	unsigned int value;
	MU_usb_config_t *config;

	config = (MU_usb_config_t *)opp->config;

	path = make_devpath(opp,"bInterfaceClass");
	if (SYSFS_VALUE10(path,&value,opp->msg_level) == INVALID)
		return INVALID;
	config->interface.class = value;
	LOG_OPP_DESC("bInterfaceClass %d",value);

	path = make_devpath(opp,"bInterfaceSubClass");
	if (SYSFS_VALUE10(path,&value,opp->msg_level) == INVALID)
		return INVALID;
	config->interface.subclass = value;
	LOG_OPP_DESC("bInterfaceSubClass %d",value);

	path = make_devpath(opp,"bInterfaceProtocol");
	if (SYSFS_VALUE10(path,&value,opp->msg_level) == INVALID)
		return INVALID;
	config->interface.protocol = value;
	LOG_OPP_DESC("bInterfaceProtocol %d",value);

	return GOOD;
}
