/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: op.c,v 3.10 2004/09/12 07:54:31 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_usb.h"

static MU_usb_config_t config;

static int
get_info_usb(mu_op_t *opp)
{
	if (FLAG_CHECK(opp->flag,FLAG_SYSFS) && opp->devpath != NULL) {
		switch(get_sysfs_kind(opp)) {
		case MU_SYSFS_DEVICE:
			if (get_sysfs_product(opp) == INVALID)
				return INVALID;
			if (get_sysfs_type(opp) == INVALID)
				return INVALID;
			break;	/* verbose */
		case MU_SYSFS_INTERFACE:
			if (get_sysfs_interface(opp) == INVALID)
				return INVALID;
			break;	/* verbose */
		default:
			return INVALID;
		} 
	} else {
		if (get_id_usb_type(opp) == INVALID)
			return INVALID;
		if (get_id_usb_product(opp) == INVALID)
			return INVALID;
	}

	return GOOD;
}

mu_op_t mu_op = {
	flag: FLAG_BEEP,
	msg_level: MU_MSG_STD,
	device: usb,
	device_name: MU_ARG_USB,
	command: MU_MURASAKI "." MU_ARG_USB,
	mappath: {MU_CONF_DIR "/" MU_USBMAP,MU_DEFAULT_USBMAP,NULL,NULL},
	action: ACTION_NONE,
	config: &config,
	sysfs: NULL,
	devpath: NULL,

	get_info: get_info_usb,
	get_list: create_modulelist,
	match_map: match_config,
	run: load_module,
	prepare: exec_script,
	end: exec_script,
};
