/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: socket.c,v 1.4 2004/09/12 08:12:11 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<fcntl.h>
#include	<ctype.h>
#include	<limits.h>

#include	"murasaki.h"
#include	"murasaki_pcmcia.h"

#ifdef	NEED_CLOSE_SOCKET
static void
close_socket(int unused,void *arg)
{
	close(*(int *)arg);
}
#endif	/* NEED_CLOSE_SOCKET */

int
make_socket(mu_op_t *opp)
{
	int socket_num;
	char *ptr;
	char socket_file[PATH_MAX];
	MU_pcmcia_config_t *config = opp->config;

	if (opp->devpath == NULL) {
		LOG_OPP_QUIET("DEVPATH is NULL");

		return INVALID;
	}

	for(ptr = strrchr(opp->devpath,'/');*ptr != '\0';ptr++) {
		if (isdigit(*ptr))
			break;
	}
	socket_num = atoi(ptr);

	sprintf(socket_file,"%s/%s.%d",MU_CONF_DIR,MU_ARG_PCMCIA,socket_num);
	/* Don't allow to use the same named file */
	if (access(socket_file,R_OK) == 0)
		unlink(socket_file);
	if (mknod(socket_file, S_IFCHR|S_IREAD|S_IWRITE, makedev(PCMCIA_MAJOR,socket_num)) != 0) {
		LOG_OPP_QUIET("%m");
		return INVALID;
	}
	config->fd = open(socket_file,O_RDWR);
	unlink(socket_file);
	if (config->fd == -1) {
		LOG_OPP_QUIET("open error \"%s\": %m",socket_file);
		return INVALID;
	}
#ifdef	NEED_CLOSE_SOCKET
	on_exit(close_socket,&socket_fd);
#endif	/* NEED_CLOSE_SOCKET */

	return GOOD;
}
