/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: resource.c,v 1.4 2004/09/12 08:11:38 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<unistd.h>
#include	<sys/types.h>
#include	<sys/ioctl.h>

#include	<pcmcia/cs_types.h>
#include	<pcmcia/cs.h>
#include	<pcmcia/cistpl.h>
#include	<pcmcia/ds.h>

#include	"murasaki.h"
#include	"murasaki_pcmcia.h"

static int msg_level = MU_MSG_STD;

static void
resource_io(int fd,int action)
{
	adjust_t adj;
	char *endp;
	ioaddr_t endport;
	int i,ret;
	list_t resource_list;

	if (init_list(&resource_list,LIST_MAX) == INVALID) {
		LOG(MU_MSG_QUIET,msg_level,"Memory allocation failed");
		return;
	}
	resource_list.list[resource_list.used++] = "io.allow";
	resource_list.list[resource_list.used] = NULL;

	if (get_resource(PCMCIA_RESOURCE_FILE,&resource_list,msg_level) == INVALID) {
#ifdef	KERNEL_JOB
		free_list(&resource_list);
#endif
		return;
	}
	memset(&adj,0x0,sizeof(adjust_t));
	adj.Resource = RES_IO_RANGE;
	if (action == RESOURCE_HOLD) {
		adj.Action = ADD_MANAGED_RESOURCE;
	} else {
		adj.Action = REMOVE_MANAGED_RESOURCE;
	}
	for(i = 1;i < resource_list.used;i++) {
		adj.resource.io.BasePort = (ioaddr_t)strtoul(resource_list.list[i],&endp,0);
		endport = (ioaddr_t)strtoul(endp+1,NULL,0);
		adj.resource.io.NumPorts = endport - adj.resource.io.BasePort + 1;
		ret = ioctl(fd,DS_ADJUST_RESOURCE_INFO, &adj);
		if (ret != 0) {
			LOG(MU_MSG_QUIET,msg_level,"could not adjust I/O resource: %#x-%#x: %m",adj.resource.io.BasePort, endport);
		}
		else {
			LOG(MU_MSG_TRACE,msg_level,"adjust I/O resource: %#x-%#x",adj.resource.io.BasePort, endport);
		}
	}
#ifdef	KERNEL_JOB
	free_list(&resource_list);
#endif

}

static void
resource_memory(int fd,int action)
{
	adjust_t adj;
	char *endp;
	u_long endmemory;
	int i,ret;
	list_t resource_list;

	if (init_list(&resource_list,LIST_MAX) == INVALID) {
		LOG(MU_MSG_QUIET,msg_level,"Memory allocation failed");
		return;
	}
	resource_list.list[resource_list.used++] = "memory.allow";
	resource_list.list[resource_list.used] = NULL;

	if (get_resource(PCMCIA_RESOURCE_FILE,&resource_list,msg_level) == INVALID) {
#ifdef	KERNEL_JOB
		free_list(&resource_list);
#endif
		return;
	}
	memset(&adj,0x0,sizeof(adjust_t));
	adj.Resource = RES_MEMORY_RANGE;
	if (action == RESOURCE_HOLD) {
		adj.Action = ADD_MANAGED_RESOURCE;
	} else {
		adj.Action = REMOVE_MANAGED_RESOURCE;
	}
	for(i = 1;i < resource_list.used;i++) {
		adj.resource.memory.Base = (u_long)strtoul(resource_list.list[i],&endp,0);
		endmemory = (u_long)strtoul(endp+1,NULL,0);
		adj.resource.memory.Size = endmemory - adj.resource.memory.Base + 1;
		ret = ioctl(fd,DS_ADJUST_RESOURCE_INFO, &adj);
		if (ret != 0) {
			LOG(MU_MSG_QUIET,msg_level,"could not adjust memory resource: %#lx-%#lx: %m",adj.resource.memory.Base, endmemory);
		}
		else {
			LOG(MU_MSG_TRACE,msg_level,"adjust memory resource: %#lx-%#lx",adj.resource.memory.Base, endmemory);
		}
	}
#ifdef	KERNEL_JOB
	free_list(&resource_list);
#endif

}

static void
resource_irq(int fd,int action)
{
	adjust_t adj;
	int i,ret;
	list_t resource_list;

	if (init_list(&resource_list,LIST_MAX) == INVALID) {
		LOG(MU_MSG_QUIET,msg_level,"Memory allocation failed");
		return;
	}
	resource_list.list[resource_list.used++] = "irq.allow";
	resource_list.list[resource_list.used] = NULL;

	if (get_resource(PCMCIA_RESOURCE_FILE,&resource_list,msg_level) == INVALID) {
#ifdef	KERNEL_JOB
		free_list(&resource_list);
#endif
		return;
	}
	memset(&adj,0x0,sizeof(adjust_t));
	adj.Resource = RES_IRQ;
	if (action == RESOURCE_HOLD) {
		adj.Action = REMOVE_MANAGED_RESOURCE;
	} else {
		adj.Action = ADD_MANAGED_RESOURCE;
	}
	for(i = 1;i < resource_list.used;i++) {
		adj.resource.irq.IRQ = atoi(resource_list.list[i]);
		ret = ioctl(fd,DS_ADJUST_RESOURCE_INFO, &adj);
		if (ret != 0) {
			LOG(MU_MSG_QUIET,msg_level,"could not adjust IRQ resource: %d: %m",adj.resource.irq.IRQ);
		}
		else {
			LOG(MU_MSG_TRACE,msg_level,"adjust IRQ resource: %d",adj.resource.irq.IRQ);
		}
	}
#ifdef	KERNEL_JOB
	free_list(&resource_list);
#endif

}

void
adjust_resources(int fd,int action)
{
	if (action == RESOURCE_HOLD) {
		LOG(MU_MSG_TRACE,msg_level,"hold resource");
	} else {
		LOG(MU_MSG_TRACE,msg_level,"free resource");
	}
	resource_io(fd,action);
	resource_memory(fd,action);
	resource_irq(fd,action);
}

