/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: print.c,v 1.3 2004/09/12 08:11:09 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>

#include	"murasaki.h"
#include	"murasaki_pcmcia.h"

void
print_config(mu_op_t *opp)
{
	MU_pcmcia_config_t *config = opp->config;
	
	if (config->manufacture.manf != 0)
		config->match_flags |= PCMCIA_MATCH_MANUFACTURE;
	if (config->version_1.ns > 0)
		config->match_flags |= config->version_1.ns << SHIFT_VERSION1;
	switch(config->version_1.ns) {
	case 0:
		LOG_OPP_STD("MODULE 0x%04x 0x%x 0x%x",
		config->match_flags,
		config->manufacture.manf,
		config->manufacture.card);
		break;
	case 1:
		LOG_OPP_STD("MODULE 0x%04x 0x%x 0x%x \"%s\"",
		config->match_flags,
		config->manufacture.manf,
		config->manufacture.card,
		config->version_1.str+config->version_1.ofs[0]);
		break;
	case 2:
		LOG_OPP_STD("MODULE 0x%04x 0x%x 0x%x \"%s\" \"%s\"",
		config->match_flags,
		config->manufacture.manf,
		config->manufacture.card,
		config->version_1.str+config->version_1.ofs[0],
		config->version_1.str+config->version_1.ofs[1]);
		break;
	case 3:
		LOG_OPP_STD("MODULE 0x%04x 0x%x 0x%x \"%s\" \"%s\" \"%s\"",
		config->match_flags,
		config->manufacture.manf,
		config->manufacture.card,
		config->version_1.str+config->version_1.ofs[0],
		config->version_1.str+config->version_1.ofs[1],
		config->version_1.str+config->version_1.ofs[2]);
		break;
	case 4:
		LOG_OPP_STD("MODULE 0x%04x 0x%x 0x%x \"%s\" \"%s\" \"%s\" \"%s\"",
		config->match_flags,
		config->manufacture.manf,
		config->manufacture.card,
		config->version_1.str+config->version_1.ofs[0],
		config->version_1.str+config->version_1.ofs[1],
		config->version_1.str+config->version_1.ofs[2],
		config->version_1.str+config->version_1.ofs[3]);
		break;
	}

}

void
inform_config(mu_op_t *opp)
{
	MU_pcmcia_config_t *config = opp->config;
	int i;

	if (config->manufacture.manf != 0) {
		LOG_OPP_STD("Manufacture: 0x%04x 0x%04x",
		config->manufacture.manf, config->manufacture.card);
	}
	if (config->function.func != 0xff) {
		LOG_OPP_STD("Function: 0x%04x", config->function.func);
	}
	if (config->version_1.ns > 0) {
		LOG_OPP_STD("Version 1");
		for (i = 0;i < config->version_1.ns;i++) {
			LOG_OPP_STD("\"%s\" ",
				config->version_1.str+config->version_1.ofs[i]);
		}
	}
}
