/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: match.c,v 1.7 2004/09/12 08:09:32 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_pcmcia.h"

#define		CHAR_COMMENT	'#'
#define		CHAR_RSEP	'\n'

#define		ST_COMMENT	255
#define		ST_MODULE	1
#define		ST_MATCH_FLAGS	(ST_MODULE+1)
#define		ST_MANU_1	(ST_MATCH_FLAGS+1)
#define		ST_MANU_2	(ST_MANU_1+1)
#define		ST_VER_1	(ST_MANU_2+1)
#define		ST_VER_2	(ST_VER_1+1)
#define		ST_VER_3	(ST_VER_2+1)
#define		ST_VER_4	(ST_VER_3+1)
#define		ST_FUNCTION	(ST_VER_4+1)

#define		ST_END		(ST_FUNCTION+1)


/*
 * manufacture | version1
 * function
 *
 * Version1: any matching: "*" 
 */
static int
real_match(MU_pcmcia_config_t *config, MU_pcmcia_config_t *map)
{
	int i;
	char *ptr;

	if (NUM_MANUFACTURE(map->match_flags) &&
		((config->manufacture.manf != map->manufacture.manf) ||
		(config->manufacture.card != map->manufacture.card)) ) {
		return INVALID;
	}
	if (NUM_VERSION1(map->match_flags)) {
		if (map->version_1.ns != config->version_1.ns)
			return INVALID;
		for(i = 0;i < map->version_1.ns;i++) {
			ptr = map->version_1.str + map->version_1.ofs[i];
			if (strcmp(ptr,"*")  == 0)
				continue;
			if (strcmp(config->version_1.str + config->version_1.ofs[i],ptr) != 0) {
				return INVALID;
			}
		}
	}
	/*
	 * function ID decides default settings.
	 * So, function configuration should be put on the last in a MAP file.
	 */
	if (NUM_FUNCTION(map->match_flags) &&
		config->function.func != map->function.func) {
		return INVALID;
	}

	return GOOD;
}

/*
 * called if msg_level >= MU_MSG_STD
 */
#define	VER_SIZE	4

static void
print_matching(MU_pcmcia_config_t *map,char *module)
{
	char *ver[VER_SIZE];
	int i;

	for(i = 0;i < VER_SIZE;i++) {
		if (i < map->version_1.ns)
			ver[i] = map->version_1.str + map->version_1.ofs[i];
		else
			ver[i] = "";
	}
	syslog(LOG_LEVEL,"MATCH(%s) -> match_flag:0x%x manufacture:0x%x 0x%x version1 \"%s\" \"%s\" \"%s\" \"%s\" function:0x%x",
		module,
		map->match_flags,
		map->manufacture.manf,
		map->manufacture.card,
		ver[0], ver[1], ver[2], ver[3],
		map->function.func
		);
}

static int
check_end(unsigned int flag,int bit)
{
	unsigned int mask = 1;

	for(mask <<= bit;bit < sizeof(flag)*8;bit++) {
		if(flag & mask)
			return 0;
		mask <<= 1;
	}
	return 1;
}

/*
 * start: start pointer on a mmapped file
 * end: end pointer on a mmapped file
 *
 * pcmcia_socketmap is murasaki original and tricky.
 */
int
match_config(mu_op_t *opp,char *start,char *end)
{
	MU_pcmcia_config_t *config = opp->config,map;
	char *ptr,*nextp,*module,*module_start,*ver_start,*ver_end;
	int status = ST_MODULE;
	u_int i,module_len=0,ver_len,ver_index=0,ver_sum = 0;

	for(module_start = ptr = start;ptr < end;ptr++) {
		if (status == ST_COMMENT) {
			while(*ptr != CHAR_RSEP) {
				if (ptr >= end)
					goto error_return;
				ptr++;
			}
			status = ST_MODULE;
			continue;
		} else if (*ptr == CHAR_COMMENT) {
			status = ST_COMMENT;
			continue;
		}
		if (status == ST_MODULE) {
			/* umm... */
			memset(&map,0x0,sizeof(MU_pcmcia_config_t));
			module_start = ptr;
			while (*ptr != ' ' && *ptr != '\t') {
				if (ptr >= end)
					goto error_return;
				ptr++;
			}
			/* ptr == next to module end */
			module_len = ptr - module_start;
			/*
			 * check excepted modules
			 */
			if ((i = find_mem_list(&(opp->except_list),module_start,ptr)) != NOT_FOUND) {
				status = ST_COMMENT;
				LOG_OPP_STD("%s was skipped in pcmcia_socketmap",opp->except_list.list[i]);
				continue;
			}
			status++;
			continue;	/* not to use 'else' */
		}
		/* skip */
		if (status == ST_MANU_1) {
			if (!NUM_MANUFACTURE(map.match_flags))
				status += 2;	/* after manufacture  */
		}
		if (status == ST_VER_1) {
			if ((ver_sum = NUM_VERSION1(map.match_flags)) == 0)
				status += 4;	/* after version_1 */
		}
		if (status == ST_FUNCTION) {
			if (!NUM_FUNCTION(map.match_flags))
				status++;	/* after function */
		}

		switch(status) {
		case ST_MATCH_FLAGS:
			map.match_flags = (u_int)strtoul(ptr,&nextp,0);
			ptr = nextp;
			break;
		case ST_MANU_1:
			map.manufacture.manf = (u_int)strtoul(ptr,&nextp,0);
			ptr = nextp;
			break;
		case ST_MANU_2:
			map.manufacture.card = (u_int)strtoul(ptr,&nextp,0);
			ptr = nextp;
			if (check_end(map.match_flags,SHIFT_VERSION1))
				status = ST_END - 1;
			break;
		case ST_VER_1:
			ver_index = 0;
		case ST_VER_2:
		case ST_VER_3:
		case ST_VER_4:
			while(*ptr != '\"') {
				if (*ptr == CHAR_RSEP)
					goto error_return;
				ptr++;
			}
			ptr++;	/* point to a content */
			ver_start = ptr;
			while(*ptr != '\"') {
				if (*ptr == CHAR_RSEP)
					goto error_return;
				ptr++;
			}
			ver_end = ptr;
			ver_len = ver_end - ver_start;
			if (ver_len != 0) {
				memcpy(&map.version_1.str[ver_index],ver_start,ver_len);
			}
			map.version_1.ofs[map.version_1.ns++] = ver_index;
			ver_index += ver_len;
			map.version_1.str[ver_index] = '\0';
			ver_index++;
			if (map.version_1.ns == ver_sum) {
				if (check_end(map.match_flags,SHIFT_FUNCTION))
					status = ST_END - 1;
				else
					status = ST_VER_4;	/* not used */
			}
			break;
		case ST_FUNCTION:
			map.function.func = (u_int)strtoul(ptr,&nextp,0);
			ptr = nextp;
			if (check_end(map.match_flags,SHIFT_FUNCTION))
				status = ST_END - 1;
			break;
		}
		status++;

		/* matching */
		if (status == ST_END) {
			if(real_match(config,&map) == GOOD) {
				module = alloc_module(module_start,module_len);
				if (module == NULL)
					goto error_return;
				if (opp->msg_level >= MU_MSG_STD)
					print_matching(&map,module);
				if (add_to_list(&(opp->module_list),module,opp->msg_level) == INVALID)
					goto error_return;
			}
			status = ST_COMMENT;
		}
	}

	return GOOD;

error_return:
	return INVALID;
}
