/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: sysfs.c,v 1.9 2004/09/12 07:50:40 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<mntent.h>
#include	<string.h>
#include	<stdlib.h>
#include	<limits.h>

#include	"murasaki.h"

#define	SYSFS_LEN	16

/*
 * if opp != NULL
 *	FLAG_SYSFS turn on
 *	return pointer of dirname
 * else
 *	return pointer of dirname
 */
char *
check_sysfs(mu_op_t *opp)
{
	FILE *fp;
	struct mntent *ent;
	static char sysfs[SYSFS_LEN+1];
	char *ret = NULL;
	int len;

	fp = setmntent(MOUNTED,"r");
	while((ent = getmntent(fp)) != NULL) {
		if (strcmp("sysfs",ent->mnt_type) == 0) {
			if (opp != NULL) {
				FLAG_ON(opp->flag,FLAG_SYSFS);
			}
			if ((len = strlen(ent->mnt_dir)) > SYSFS_LEN) {
				ret = (char *)malloc(len+1);
				if (ret == NULL)
					return NULL;
			} else {
				ret = sysfs;
			}
			strcpy(ret,ent->mnt_dir);
			break;
		}
	}
	endmntent(fp);

	return ret;
}

void
set_devpath(mu_op_t *opp)
{
	if(!FLAG_CHECK(opp->flag,FLAG_SYSFS))
		return;
	opp->devpath = getenv("DEVPATH");
	if (opp->devpath == NULL) {
		LOG_OPP_QUIET("DEVPATH is NULL");
		return;
	}
	LOG_OPP_TRACE("DEVPATH = \"%s\"",opp->devpath);
}

char *
make_devpath(mu_op_t *opp,char *fname)
{
	static char path[PATH_MAX+1],*base;
	static int first=1;

	if (first) {
		if (opp->action == ACTION_ADD)
			strcpy(path,opp->sysfs);
		else {
			strcpy(path,MU_CONF_DIR);
			strcat(path,opp->sysfs);
		}
		strcat(path,opp->devpath);
		strcat(path,"/");
		first = 0;
		base = strrchr(path,'/');
	}
	strcpy(base+1,fname);

	return path;
}

