/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: exec.c,v 1.5 2004/09/12 07:36:37 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<unistd.h>
#include	<sys/types.h>
#include	<sys/wait.h>
#include	<stdlib.h>	/* for putenv */
#include	<string.h>	/* strcat */

#include	"murasaki.h"

/*
 * called by load_module() and exec_script()
 * argv[0] is specified as a full path.
 */
void
executing(mu_op_t *opp,char **argv,int process)
{
	pid_t pid;
	char *path = argv[0];
	char hotplug_name[256] = "MURASAKI_HOTPLUG_NAME=";

	LOG_ARGS(MU_MSG_DESC,opp->msg_level,"Exec argv",argv);

	putenv("MURASAKI_CONF_DIR=" MU_CONF_DIR);
	putenv("MURASAKI_SCRIPT_DIR=" MU_SCRIPT_DIR);
	strcat(hotplug_name,opp->device_name);
	putenv(hotplug_name);
	if (process == FORK_ON) {
		pid = fork();
		switch(pid) {
		case -1:
			LOG_OPP_QUIET("fork error %m");
			break;
		case 0:	/* child */
			execv(path,argv);
			beep(INVALID,opp->flag);
			LOG_OPP_QUIET("exec error \"%s\": %m",path);
			break;
		default:	/* parent */
			wait(NULL);
			break;
		}
	} else {
		execv(path,argv);
		beep(INVALID,opp->flag);
		LOG_OPP_QUIET("exec error \"%s\": %m",path);
	}
}
