/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: murasaki_pcmcia.h,v 1.3 2004/02/06 00:23:29 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#ifndef	_MURASAKI_PCMCIA_H
#define	_MURASAKI_PCMCIA_H

#include	<pcmcia/cs_types.h>
#include	<pcmcia/cs.h>
#include	<pcmcia/cistpl.h>
#include	<pcmcia/ds.h>

#ifndef	PCMCIA_MAJOR
#define	PCMCIA_MAJOR	254
#endif

#define	RESOURCE_HOLD	1
#define	RESOURCE_FREE	2

/* 
 *   7 6 5 4  3 2 1 0
 *  |-------||-------|
 *   0 0 0 0  0 0 0 0
 *         |  | | | +- Manufucture ID
 *         |  + + +--- Version 1 ID (sum of version1 infos. max:4)
 *         +---------- Funcsion ID
 *
 */

#define	SHIFT_MANUFACTURE		0
#define	SHIFT_VERSION1			1
#define	SHIFT_FUNCTION			4
#define	PCMCIA_MATCH_MANUFACTURE	1
#define	PCMCIA_MATCH_VERSION1_1		(1 << SHIFT_VERSION1)
#define	PCMCIA_MATCH_VERSION1_2		(2 << SHIFT_VERSION1)
#define	PCMCIA_MATCH_VERSION1_3		(3 << SHIFT_VERSION1)
#define	PCMCIA_MATCH_VERSION1_4		(4 << SHIFT_VERSION1)
#define	PCMCIA_MATCH_VERSION1		(PCMCIA_MATCH_VERSION1_4|PCMCIA_MATCH_VERSION1_3)
#define	PCMCIA_MATCH_FUNCTION		(1 << SHIFT_FUNCTION)

#define	NUM_MANUFACTURE(flag)		(flag & PCMCIA_MATCH_MANUFACTURE)
#define	NUM_VERSION1(flag)		((flag & PCMCIA_MATCH_VERSION1) >> SHIFT_VERSION1)
#define	NUM_FUNCTION(flag)		((flag & PCMCIA_MATCH_FUNCTION) >> SHIFT_FUNCTION)

#define	PCMCIA_LOCKFILE	MU_CONF_DIR "/.pcmcia_socket.lock"
#define	PCMCIA_RESOURCE_FILE	MU_CONF_DIR "/pcmcia_resource"

typedef struct {
	int fd;
	u_int match_flags;
	cistpl_manfid_t	manufacture;
	cistpl_vers_1_t	version_1;
	cistpl_funcid_t	function;
} MU_pcmcia_config_t;

extern char *resource_list[LIST_MAX];
/* card.c */
extern int get_info_pcmcia(mu_op_t *);
extern void binding_module(mu_op_t *);
/* socket.c */
extern int make_socket(mu_op_t *);
/* resources.c */
extern void adjust_resources(int, int );
/* lock.c */
extern int lock_resource(char *);
extern int unlock_resource(char *);

#endif	/* _MURASAKI_PCMCIA_H */
