/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: datatype.h,v 3.14 2004/02/19 00:46:48 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#ifndef	_MURASASKI_DATATYPE_H
#define	_MURASASKI_DATATYPE_H

#include	<stdio.h>

#define	LIST_MAX		16
#define	CLEAR_LIST(lst)		(lst).list[0] = NULL;(lst).used = 0

enum hotplug_device {
	generic,
	usb,
	pci,
	ieee1394,
	pcmcia_socket,
	input
};

typedef struct {
	char **list;
	unsigned int used;	/* number of used items in list */
	unsigned int size;
} list_t;

typedef struct mu_op {
	int flag;
	int msg_level;
	enum hotplug_device device;
	char *device_name;
	char *command;
	char *mappath[4];
	int  action;
	void *config;
	char *sysfs;
	char *devpath;

	list_t module_list;
	list_t alias_list;
	list_t except_list;
	list_t script_list;

	int (*get_info)(struct mu_op *);
	int (*get_list)(struct mu_op *);
	int (*match_map)(struct mu_op *,char *,char *);
	int (*run)(struct mu_op *);
	void (*prepare)(struct mu_op *,int);
	void (*end)(struct mu_op *,int);
} mu_op_t;

#endif	/* _MURASASKI_DATATYPE_H */

