/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: op.c,v 1.9 2004/09/12 08:03:47 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_ieee1394.h"

MU_ieee1394_config_t config;

static int
get_info_ieee1394(mu_op_t *opp)
{
	if (get_id_ieee1394(opp) == INVALID)	/* always GOOD */
		return INVALID;

	return GOOD;
}

mu_op_t mu_op = {
	flag: FLAG_BEEP,
	msg_level: MU_MSG_STD,
	device: ieee1394,
	device_name: MU_ARG_IEEE1394,
	command: MU_MURASAKI "." MU_ARG_IEEE1394,
	mappath: {MU_CONF_DIR "/" MU_IEEE1394MAP,MU_DEFAULT_IEEE1394MAP,NULL,NULL},
	action: ACTION_NONE,
	config: &config,
	sysfs: NULL,
	devpath: NULL,

	get_info: get_info_ieee1394,
	get_list: create_modulelist,
	match_map: match_config,
	run: load_module,
	prepare: exec_script,
	end: exec_script,
};
