/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: hotplug.c,v 3.26 2004/09/13 14:25:54 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<syslog.h>
#include	<unistd.h>
#include	<limits.h>

#include	"murasaki.h"

#define	EXEC_PATH		MU_SCRIPT_DIR ":" MU_CONF_DIR ":" MU_BIN_DIR ":"
#define	HOTPLUG_MAX_ARGS	3

#define	MURASAKI_GENERIC	MU_MURASAKI "." MU_ARG_GENERIC
#define	AGENT_CMD(name)		{name, MU_MURASAKI "." name}

/*
 * 1st argument of hotplug VS runnable Agent program path
 */
struct arg_command {
	char *arg;
	char *cmd;
} cmd_table[] = {
	AGENT_CMD(MU_ARG_USB),
	AGENT_CMD(MU_ARG_PCI),
	AGENT_CMD(MU_ARG_IEEE1394),
	AGENT_CMD(MU_ARG_PCMCIA),
	AGENT_CMD(MU_ARG_INPUT),
	{NULL,NULL}
};

static void
usage(void)
{
	printf("Murasaki version: %s\n",MU_VERSION);
	printf("Please see http://www.dotaster.com/~shuu/linux/murasaki/\n");
	exit(1);
}

int
main(int argc,char **argv,char **env)
{
	char *cmd[HOTPLUG_MAX_ARGS];
	int idx;
	int msg_level;
	list_t generic_list;
	char cmd_path[PATH_MAX] = MU_BIN_DIR "/";

	if (argc == 1)
		usage();

	msg_level = get_msg_level();
	if (msg_level >= MU_MSG_DESC)
		openlog(HOTPLUG_NAME,LOG_PID|LOG_CONS,LOG_DAEMON);
	else
		openlog(HOTPLUG_NAME,LOG_PID,LOG_DAEMON);

	LOG_ARGS(MU_MSG_DESC,msg_level,"argv",argv);
	LOG_ARGS(MU_MSG_DESC,msg_level,"env",env);

	/* check device */
	if (check_config(argv[1],msg_level) == ARG_OFF)
		exit(0);

	cmd[0] = cmd_path;
	cmd[1] = NULL;
	cmd[2] = NULL;
	for (idx = 0;cmd_table[idx].arg != NULL;idx++) {
		if (strcmp(argv[1],cmd_table[idx].arg) == 0) {
			strcat(cmd[0],cmd_table[idx].cmd);
			break;
		}
	}
	/*
	 * search generic list if arg1 is not found
	 */
	if (cmd_table[idx].arg == NULL) {
		if (init_list(&generic_list,LIST_MAX) == INVALID) {
			LOG(MU_MSG_QUIET,msg_level,"Memory allocation failed");
			exit(1);
		}

		if (list_from_file(GENERICLIST_PATH,&generic_list) == INVALID) { 
			LOG(MU_MSG_QUIET,msg_level,"Memory allocation failed");
		}
		LOG_ARGS(MU_MSG_TRACE,msg_level,GENERICLIST_PATH,generic_list.list);
		if (generic_list.used > 0) {
			if (find_str_list(&generic_list,argv[1]) != NOT_FOUND) {
				strcat(cmd[0],MURASAKI_GENERIC);
				cmd[1] = argv[1];
			}
		}
#ifdef	KERNEL_JOB
		free_list(&generic_list);
#endif
		if (cmd[1] == NULL) {
			LOG(MU_MSG_STD,msg_level,"Unknown Hotplug name \"%s\"",argv[1]);
			LOG(MU_MSG_STD,msg_level,"Add \"%s\" into %s if you want",argv[1],GENERICLIST_PATH);
			exit(1);
		/* check device for generic device*/
		} else if (check_config(cmd[1],msg_level) == ARG_OFF) {
			exit(0);
		}
	}
	closelog();
	LOG_ARGS(MU_MSG_TRACE,msg_level,"cmd",cmd);
	execv(cmd[0],cmd);
	LOG(MU_MSG_QUIET,msg_level,"Exec error");

	/* not reached */
	return 0;
}
