C
C  This file is part of MUMPS 5.1.1, released
C  on Mon Mar 20 14:34:33 UTC 2017
C
C
C  Copyright 1991-2017 CERFACS, CNRS, ENS Lyon, INP Toulouse, Inria,
C  University of Bordeaux.
C
C  This version of MUMPS is provided to you free of charge. It is
C  released under the CeCILL-C license:
C  http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html
C
      MODULE SMUMPS_LR_DATA_M
      USE SMUMPS_LR_TYPE
      IMPLICIT NONE
      PRIVATE
      PUBLIC :: SMUMPS_BLR_END_FRONT,
     &  SMUMPS_BLR_INIT_MODULE, SMUMPS_BLR_END_MODULE,
     &  SMUMPS_BLR_INIT_FRONT,
     &  SMUMPS_BLR_SAVE_PANEL_LORU,
     &  SMUMPS_BLR_RETRIEVE_BEGS_BLR_L,
     &  SMUMPS_BLR_RETRIEVE_BEGS_BLR_C,
     &  SMUMPS_BLR_RETRIEVE_PANEL_L,
     &  SMUMPS_BLR_RETRIEVE_PANEL_LORU,
     &  SMUMPS_BLR_DEC_AND_TRYFREE_L,
     &  SMUMPS_BLR_TRY_FREE_PANEL, 
     &  SMUMPS_BLR_FREE_ALL_PANELS,
     &  SMUMPS_BLR_FREE_PANEL
      TYPE blr_panel_type
         integer                 :: NB_ACCESSES_LEFT
         type(lrb_type), pointer :: LRB_PANEL(:)
      END TYPE blr_panel_type
      TYPE BLR_STRUC_T
         LOGICAL   :: IsSYM, IsT2, IsSLAVE
         TYPE(blr_panel_type), DIMENSION (:), POINTER  :: PANELS_L 
         TYPE(blr_panel_type), DIMENSION (:), POINTER  :: PANELS_U
         INTEGER, DIMENSION(:), POINTER :: BEGS_BLR_L
         INTEGER, DIMENSION(:), POINTER :: BEGS_BLR_COL
         INTEGER :: NB_ACCESSES_INIT 
         INTEGER :: NB_PANELS 
      END TYPE BLR_STRUC_T
      type(BLR_STRUC_T), POINTER, DIMENSION(:), SAVE :: BLR_ARRAY
      INTEGER BLR_ARRAY_FREE, PANELS_NOTUSED, PANELS_FREED,
     &        NB_PANELS_NOTINIT
      PARAMETER (BLR_ARRAY_FREE=-9999, 
     &           PANELS_NOTUSED=-1111, PANELS_FREED=-2222, 
     &           NB_PANELS_NOTINIT=-3333)
      CONTAINS
      SUBROUTINE SMUMPS_BLR_INIT_MODULE(INITIAL_SIZE, INFO)
       INTEGER, INTENT(IN) :: INITIAL_SIZE
       INTEGER, INTENT(INOUT) :: INFO(2)
       INTEGER :: I, IERR
       ALLOCATE(BLR_ARRAY( INITIAL_SIZE ), stat=IERR)
       IF (IERR > 0 ) THEN
         INFO(1)=-13
         INFO(2)=INITIAL_SIZE
         RETURN
       ENDIF
       DO I=1, INITIAL_SIZE
         NULLIFY(BLR_ARRAY(I)%PANELS_L)
         NULLIFY(BLR_ARRAY(I)%PANELS_U)
         BLR_ARRAY(I)%NB_ACCESSES_INIT = BLR_ARRAY_FREE
         BLR_ARRAY(I)%NB_PANELS        = NB_PANELS_NOTINIT
         NULLIFY(BLR_ARRAY(I)%BEGS_BLR_L)
         NULLIFY(BLR_ARRAY(I)%BEGS_BLR_COL)
       ENDDO
       RETURN
       END SUBROUTINE SMUMPS_BLR_INIT_MODULE
       SUBROUTINE SMUMPS_BLR_END_MODULE(INFO1, KEEP8, IS_FACTOR)
       INTEGER, INTENT(IN) :: INFO1
       INTEGER(8) :: KEEP8(150)
       LOGICAL, INTENT(IN) :: IS_FACTOR
       INTEGER :: I, ILOOP
       IF (.NOT. associated(BLR_ARRAY)) THEN
         WRITE(*,*) "Internal error 1 in SMUMPS_BLR_END_MODULE"
         CALL MUMPS_ABORT()
       ENDIF
       ILOOP=0
       DO I=1, size(BLR_ARRAY)
         ILOOP= ILOOP+1
         IF (associated(BLR_ARRAY(I)%PANELS_L).OR.
     &       associated(BLR_ARRAY(I)%PANELS_U)) THEN
           IF (INFO1 .GE.0) THEN
               WRITE(*,*) "Internal error 2 in MUMPS_BLR_END_MODULE ",
     &       " IWHANDLER=", I
               CALL MUMPS_ABORT()
           ELSE
               CALL SMUMPS_BLR_END_FRONT(ILOOP, INFO1, KEEP8, IS_FACTOR)
           ENDIF
         ENDIF
       ENDDO
       DEALLOCATE(BLR_ARRAY)
       NULLIFY(BLR_ARRAY)
       RETURN
       END SUBROUTINE SMUMPS_BLR_END_MODULE
       SUBROUTINE SMUMPS_BLR_INIT_FRONT(IWHANDLER, 
     &                       IsSYM, IsT2, IsSLAVE, 
     &                       NB_PANELS,
     &                       BEGS_BLR_L, BEGS_BLR_COL, 
     &                       NB_ACCESSES_INIT, INFO)
       USE MUMPS_FRONT_DATA_MGT_M, ONLY : MUMPS_FDM_START_IDX
       LOGICAL, INTENT(IN) :: IsSYM, IsT2, IsSLAVE
       INTEGER, INTENT(IN) :: NB_PANELS 
       INTEGER, INTENT(INOUT) :: IWHANDLER, INFO(2)
       INTEGER, INTENT(IN) :: NB_ACCESSES_INIT 
       INTEGER, INTENT(IN), DIMENSION(:) :: BEGS_BLR_L
       INTEGER,  DIMENSION(:), POINTER :: BEGS_BLR_COL
       TYPE(BLR_STRUC_T), POINTER, DIMENSION(:) :: BLR_ARRAY_TMP
       INTEGER :: OLD_SIZE, NEW_SIZE
       INTEGER :: I
       INTEGER :: IERR
       IF (NB_PANELS.EQ.0) THEN
        WRITE(6,*) " Internal error in SMUMPS_BLR_INIT_FRONT ", 
     &    NB_PANELS
       ENDIF
       CALL MUMPS_FDM_START_IDX('F', 'INITF', IWHANDLER, INFO)
       IF (IWHANDLER > size(BLR_ARRAY)) THEN
         OLD_SIZE = size(BLR_ARRAY)
         NEW_SIZE = max( (OLD_SIZE * 3) / 2 + 1, IWHANDLER)
         ALLOCATE(BLR_ARRAY_TMP(NEW_SIZE),stat=IERR)
         IF (IERR.GT.0) THEN
           INFO(1)=-13
           INFO(2)=NEW_SIZE
           RETURN
         ENDIF
         DO I=1, OLD_SIZE
           BLR_ARRAY_TMP(I)=BLR_ARRAY(I)
         ENDDO
         DO I=OLD_SIZE+1, NEW_SIZE
           NULLIFY(BLR_ARRAY_TMP(I)%PANELS_L)
           NULLIFY(BLR_ARRAY_TMP(I)%PANELS_U)
         ENDDO
         DEALLOCATE(BLR_ARRAY)
         BLR_ARRAY => BLR_ARRAY_TMP
         NULLIFY(BLR_ARRAY_TMP)
       ENDIF
       IF (NB_ACCESSES_INIT.EQ.0) THEN
        NULLIFY(BLR_ARRAY(IWHANDLER)%PANELS_L)
        NULLIFY(BLR_ARRAY(IWHANDLER)%PANELS_U)
        IF (IsSYM.and.IsT2.and.IsSLAVE.and.
     &            associated(BEGS_BLR_COL)) THEN
         ALLOCATE(
     &          BLR_ARRAY(IWHANDLER)%BEGS_BLR_L(size(BEGS_BLR_L)),
     &          BLR_ARRAY(IWHANDLER)%BEGS_BLR_COL(size(BEGS_BLR_COL)),
     &          stat=IERR)
        ELSE 
         ALLOCATE(
     &          BLR_ARRAY(IWHANDLER)%BEGS_BLR_L(size(BEGS_BLR_L)),
     &          stat=IERR)
        ENDIF
        IF (IERR .GT. 0) THEN
           INFO(1)=-13
           IF (associated(BEGS_BLR_COL)) THEN
              INFO(2)=size(BEGS_BLR_L)+size(BEGS_BLR_COL)
           ELSE
              INFO(2)=size(BEGS_BLR_L)
           ENDIF
           RETURN
        ENDIF
       ELSE
        IF (IsSYM.and.IsT2.and.IsSLAVE.and.
     &            associated(BEGS_BLR_COL)) THEN
         ALLOCATE(BLR_ARRAY(IWHANDLER)%PANELS_L(NB_PANELS),
     &          BLR_ARRAY(IWHANDLER)%BEGS_BLR_L(size(BEGS_BLR_L)),
     &          BLR_ARRAY(IWHANDLER)%BEGS_BLR_COL(size(BEGS_BLR_COL)),
     &          stat=IERR)
        ELSE IF (IsSYM) THEN
         ALLOCATE(BLR_ARRAY(IWHANDLER)%PANELS_L(NB_PANELS),
     &          BLR_ARRAY(IWHANDLER)%BEGS_BLR_L(size(BEGS_BLR_L)),
     &          stat=IERR)
        ELSE 
         ALLOCATE(BLR_ARRAY(IWHANDLER)%PANELS_L(NB_PANELS),
     &          BLR_ARRAY(IWHANDLER)%PANELS_U(NB_PANELS),
     &          BLR_ARRAY(IWHANDLER)%BEGS_BLR_L(size(BEGS_BLR_L)),
     &          stat=IERR)
        ENDIF
        IF (IERR .GT. 0) THEN
           INFO(1)=-13
           IF (IsSYM.and.IsT2.and.IsSLAVE.and.
     &            associated(BEGS_BLR_COL)) THEN
              INFO(2)=NB_PANELS+size(BEGS_BLR_L)+size(BEGS_BLR_COL)
           ELSE IF (IsSYM) THEN
              INFO(2)=NB_PANELS+size(BEGS_BLR_L)
           ELSE
              INFO(2)=NB_PANELS+NB_PANELS+size(BEGS_BLR_L)
           ENDIF
           RETURN
        ENDIF
        DO I=1,NB_PANELS
           NULLIFY(BLR_ARRAY(IWHANDLER)%PANELS_L(I)%LRB_PANEL)
           IF (.NOT.IsSYM) THEN
            NULLIFY(BLR_ARRAY(IWHANDLER)%PANELS_U(I)%LRB_PANEL)
           ENDIF
        ENDDO
       ENDIF
       BLR_ARRAY(IWHANDLER)%IsSYM        = IsSYM
       BLR_ARRAY(IWHANDLER)%IsT2         = IsT2
       BLR_ARRAY(IWHANDLER)%IsSLAVE      = IsSLAVE
       BLR_ARRAY(IWHANDLER)%NB_PANELS    = NB_PANELS
       BLR_ARRAY(IWHANDLER)%BEGS_BLR_L   = BEGS_BLR_L
       IF (NB_ACCESSES_INIT.EQ.0) THEN
         BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT = PANELS_NOTUSED
       ELSE
         BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT = NB_ACCESSES_INIT
       ENDIF
       IF (associated(BEGS_BLR_COL)) THEN
          DO I=1,size(BEGS_BLR_COL)
             BLR_ARRAY(IWHANDLER)%BEGS_BLR_COL(I) = BEGS_BLR_COL(I)
          ENDDO
       ELSE
         NULLIFY( BLR_ARRAY(IWHANDLER)%BEGS_BLR_COL )
       ENDIF
       RETURN
       END SUBROUTINE SMUMPS_BLR_INIT_FRONT
       SUBROUTINE SMUMPS_BLR_END_FRONT(IWHANDLER, INFO1, 
     &           KEEP8, IS_FACTOR)
       USE MUMPS_FRONT_DATA_MGT_M, ONLY : MUMPS_FDM_END_IDX
       INTEGER, INTENT(INOUT) :: IWHANDLER
       INTEGER, INTENT(IN) :: INFO1
       INTEGER(8) :: KEEP8(150)
       LOGICAL, INTENT(IN) :: IS_FACTOR
       INTEGER :: IPANEL
       TYPE(blr_panel_type), POINTER  :: THEPANEL
       IF (IWHANDLER.LE.0) THEN 
        RETURN
       ENDIF
       IF (IWHANDLER .GT. size(BLR_ARRAY)) THEN
        RETURN
       END IF
       IF (BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT.EQ.BLR_ARRAY_FREE)
     &      RETURN  
       IF (BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT.NE.
     &      PANELS_NOTUSED) THEN
        DO IPANEL = 1, size(BLR_ARRAY(IWHANDLER)%PANELS_L)
           THEPANEL => BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)
           IF (associated(THEPANEL%LRB_PANEL)) THEN
            IF (INFO1 .GE. 0) THEN
             WRITE(*,*) " Internal Error 2 in MUMPS_BLR_END_FRONT ",
     &          IWHANDLER, "NB_ACCESSES_INIT=", 
     &          BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT, 
     &          "Pointer to panel number ",IPANEL," still associated",
     &          "NB_ACCESSES_LEFT= ",THEPANEL%NB_ACCESSES_LEFT
             CALL MUMPS_ABORT()
            ELSE
              CALL DEALLOC_BLR_PANEL(THEPANEL%LRB_PANEL,
     &          size(THEPANEL%LRB_PANEL), KEEP8, IS_FACTOR)
             THEPANEL%NB_ACCESSES_LEFT = PANELS_FREED
            ENDIF
           ENDIF
        ENDDO
        NULLIFY(THEPANEL%LRB_PANEL)
        IF (associated(BLR_ARRAY(IWHANDLER)%PANELS_L)) THEN
         DEALLOCATE(BLR_ARRAY(IWHANDLER)%PANELS_L)
         NULLIFY(BLR_ARRAY(IWHANDLER)%PANELS_L)
        ENDIF
        IF (.NOT.BLR_ARRAY(IWHANDLER)%IsSYM) THEN
         DO IPANEL = 1, size(BLR_ARRAY(IWHANDLER)%PANELS_U)
           THEPANEL => BLR_ARRAY(IWHANDLER)%PANELS_U(IPANEL)
           IF (associated(THEPANEL%LRB_PANEL)) THEN
            IF (INFO1 .GE. 0) THEN
             WRITE(*,*) " Internal Error 2 in MUMPS_BLR_END_FRONT ",
     &          IWHANDLER, "NB_ACCESSES_INIT=", 
     &          BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT, 
     &          "Pointer to panel number ",IPANEL," still associated"
             CALL MUMPS_ABORT()
            ELSE
              CALL DEALLOC_BLR_PANEL(THEPANEL%LRB_PANEL,
     &          size(THEPANEL%LRB_PANEL), KEEP8, IS_FACTOR)
             THEPANEL%NB_ACCESSES_LEFT = PANELS_FREED 
            ENDIF
           ENDIF
         ENDDO
         NULLIFY(THEPANEL%LRB_PANEL)
         IF (associated(BLR_ARRAY(IWHANDLER)%PANELS_U)) THEN
          DEALLOCATE(BLR_ARRAY(IWHANDLER)%PANELS_U)
          NULLIFY(BLR_ARRAY(IWHANDLER)%PANELS_U)
         ENDIF
        ENDIF   
       ENDIF  
       IF (.NOT. associated(BLR_ARRAY(IWHANDLER)%BEGS_BLR_L)) THEN
         WRITE(*,*) " Internal Error 3 in MUMPS_BLR_END_FRONT ",
     &              IWHANDLER
         CALL MUMPS_ABORT()
       ENDIF
       DEALLOCATE(BLR_ARRAY(IWHANDLER)%BEGS_BLR_L)
       NULLIFY(BLR_ARRAY(IWHANDLER)%BEGS_BLR_L)
       IF (associated(BLR_ARRAY(IWHANDLER)%BEGS_BLR_COL)) THEN
          DEALLOCATE(BLR_ARRAY(IWHANDLER)%BEGS_BLR_COL)
          NULLIFY(BLR_ARRAY(IWHANDLER)%BEGS_BLR_COL)
       ENDIF
       BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT = BLR_ARRAY_FREE
       BLR_ARRAY(IWHANDLER)%NB_PANELS        = NB_PANELS_NOTINIT
       CALL MUMPS_FDM_END_IDX('F', 'ENDF', IWHANDLER)
       RETURN
       END SUBROUTINE SMUMPS_BLR_END_FRONT
       SUBROUTINE SMUMPS_BLR_SAVE_PANEL_LORU (
     &    IWHANDLER, LORU, IPANEL, LRB_PANEL )
       type(lrb_type), DIMENSION(:), pointer  :: LRB_PANEL
       INTEGER, INTENT(IN) :: IWHANDLER, IPANEL
       INTEGER, INTENT(IN) :: LORU
       TYPE(blr_panel_type), POINTER  :: THEPANEL
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) "Internal error 1 in SMUMPS_BLR_SAVE_PANEL_LORU"
         CALL MUMPS_ABORT()
       ENDIF
       IF ( BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT.LT.0) THEN
         WRITE(*,*) "Internal error 2 in SMUMPS_BLR_SAVE_PANEL_LORU"
         CALL MUMPS_ABORT()
       ENDIF
       IF (LORU.EQ.0) THEN
         THEPANEL => BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)
       ELSE 
         THEPANEL => BLR_ARRAY(IWHANDLER)%PANELS_U(IPANEL)
       ENDIF
       THEPANEL%NB_ACCESSES_LEFT = 
     &           BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT
       THEPANEL%LRB_PANEL => LRB_PANEL
       RETURN
       END SUBROUTINE SMUMPS_BLR_SAVE_PANEL_LORU
       SUBROUTINE SMUMPS_BLR_RETRIEVE_BEGS_BLR_L 
     &            ( IWHANDLER, BEGS_BLR_L )
       INTEGER, INTENT(IN) :: IWHANDLER
#if defined(MUMPS_F2003)
       INTEGER, POINTER, DIMENSION(:), INTENT(OUT) :: BEGS_BLR_L
#else
       INTEGER, POINTER, DIMENSION(:) :: BEGS_BLR_L
#endif
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) 
     &       "Internal error 1 in SMUMPS_BLR_RETRIEVE_BEGS_BLR_L"
         CALL MUMPS_ABORT()
       ENDIF
       BEGS_BLR_L => BLR_ARRAY(IWHANDLER)%BEGS_BLR_L
       RETURN
       END SUBROUTINE SMUMPS_BLR_RETRIEVE_BEGS_BLR_L
       SUBROUTINE SMUMPS_BLR_RETRIEVE_BEGS_BLR_C
     &            ( IWHANDLER, BEGS_BLR_COL, NB_PANELS )
       INTEGER, INTENT(IN)  :: IWHANDLER
       INTEGER, INTENT(OUT) :: NB_PANELS
#if defined(MUMPS_F2003)
       INTEGER, POINTER, DIMENSION(:), INTENT(OUT) :: BEGS_BLR_COL
#else
       INTEGER, POINTER, DIMENSION(:) :: BEGS_BLR_COL
#endif
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) 
     &   "Internal error 1 in  SMUMPS_BLR_RETRIEVE_BEGS_BLR_C"
         CALL MUMPS_ABORT()
       ENDIF
       BEGS_BLR_COL => BLR_ARRAY(IWHANDLER)%BEGS_BLR_COL
       NB_PANELS     = BLR_ARRAY(IWHANDLER)%NB_PANELS
       RETURN
       END SUBROUTINE SMUMPS_BLR_RETRIEVE_BEGS_BLR_C
       SUBROUTINE SMUMPS_BLR_RETRIEVE_PANEL_L(IWHANDLER, IPANEL,
     &                                      BEGS_BLR_L, THELRBPANEL)
       INTEGER, INTENT(IN) :: IWHANDLER
       INTEGER, INTENT(IN) :: IPANEL
#if defined(MUMPS_F2003)
       INTEGER, POINTER, DIMENSION(:), INTENT(OUT) :: BEGS_BLR_L
       TYPE(LRB_TYPE), INTENT(OUT), DIMENSION(:), POINTER :: THELRBPANEL
#else
       INTEGER, POINTER, DIMENSION(:) :: BEGS_BLR_L
       TYPE(LRB_TYPE), POINTER, DIMENSION(:) :: THELRBPANEL
#endif
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) "Internal error 1 in SMUMPS_BLR_RETRIEVE_PANEL_L",
     &    "IPANEL=", IPANEL
         CALL MUMPS_ABORT()
       ENDIF
       IF ( .NOT. associated(BLR_ARRAY(IWHANDLER)%PANELS_L)) THEN
         WRITE(*,*) "Internal error 2 in SMUMPS_BLR_RETRIEVE_PANEL_L",
     &    "IPANEL=", IPANEL
         CALL MUMPS_ABORT()
       ENDIF
       IF ( .NOT.
     & associated(BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)%LRB_PANEL) )
     & THEN
         WRITE(*,*) "Internal error 3 in SMUMPS_BLR_RETRIEVE_PANEL_L",
     &    "IPANEL=", IPANEL
         CALL MUMPS_ABORT()
       ENDIF
       CALL SMUMPS_BLR_RETRIEVE_BEGS_BLR_L( IWHANDLER, BEGS_BLR_L )
       THELRBPANEL =>
     &        BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)%LRB_PANEL
       BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)%NB_ACCESSES_LEFT = 
     & BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)%NB_ACCESSES_LEFT - 1
       RETURN
       END SUBROUTINE SMUMPS_BLR_RETRIEVE_PANEL_L
       SUBROUTINE SMUMPS_BLR_RETRIEVE_PANEL_LORU
     &                          (IWHANDLER, LORU, IPANEL,
     &                           THELRBPANEL)
       INTEGER, INTENT(IN) :: IWHANDLER
       INTEGER, INTENT(IN) :: LORU 
       INTEGER, INTENT(IN) :: IPANEL
#if defined(MUMPS_F2003)
       TYPE(LRB_TYPE), INTENT(OUT), DIMENSION(:), POINTER :: THELRBPANEL
#else
       TYPE(LRB_TYPE), POINTER, DIMENSION(:) :: THELRBPANEL
#endif
       IF ( IWHANDLER .GT. size(BLR_ARRAY) .OR. IWHANDLER .LE. 0 ) THEN
         WRITE(*,*) 
     &    "Internal error 1 in SMUMPS_BLR_RETRIEVE_PANEL_LORU",
     &    "IPANEL=", IPANEL
         CALL MUMPS_ABORT()
       ENDIF
       IF (LORU.EQ.0) THEN
        IF ( .NOT. associated(BLR_ARRAY(IWHANDLER)%PANELS_L)) THEN
         WRITE(*,*) 
     &    "Internal error 2 in SMUMPS_BLR_RETRIEVE_PANEL_LORU",
     &    "IPANEL=", IPANEL
         CALL MUMPS_ABORT()
        ENDIF
        IF ( .NOT.
     &  associated(BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)%LRB_PANEL) )
     &  THEN
         WRITE(*,*) 
     &    "Internal error 3 in SMUMPS_BLR_RETRIEVE_PANEL_LORU",
     &    "IPANEL=", IPANEL
         CALL MUMPS_ABORT()
        ENDIF
        THELRBPANEL =>
     &        BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)%LRB_PANEL
        BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)%NB_ACCESSES_LEFT = 
     &  BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)%NB_ACCESSES_LEFT - 1
       ELSE
        IF ( .NOT. associated(BLR_ARRAY(IWHANDLER)%PANELS_U)) THEN
         WRITE(*,*) 
     &    "Internal error 2 in SMUMPS_BLR_RETRIEVE_PANEL_LORU",
     &    "IPANEL=", IPANEL
         CALL MUMPS_ABORT()
        ENDIF
        IF ( .NOT.
     &  associated(BLR_ARRAY(IWHANDLER)%PANELS_U(IPANEL)%LRB_PANEL) )
     &  THEN
         WRITE(*,*) 
     &    "Internal error 3 in SMUMPS_BLR_RETRIEVE_PANEL_LORU",
     &    "IPANEL=", IPANEL
         CALL MUMPS_ABORT()
        ENDIF
        THELRBPANEL =>
     &        BLR_ARRAY(IWHANDLER)%PANELS_U(IPANEL)%LRB_PANEL
        BLR_ARRAY(IWHANDLER)%PANELS_U(IPANEL)%NB_ACCESSES_LEFT = 
     &  BLR_ARRAY(IWHANDLER)%PANELS_U(IPANEL)%NB_ACCESSES_LEFT - 1
       ENDIF
       RETURN
       END SUBROUTINE SMUMPS_BLR_RETRIEVE_PANEL_LORU
       SUBROUTINE SMUMPS_BLR_DEC_AND_TRYFREE_L( IWHANDLER, IPANEL,
     &                            KEEP8, IS_FACTOR)      
       IMPLICIT NONE
       INTEGER, INTENT(IN) :: IWHANDLER, IPANEL
       INTEGER(8) :: KEEP8(150)
       LOGICAL, INTENT(IN) :: IS_FACTOR
       IF (IWHANDLER.LE.0) RETURN
       IF ( BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT.LT.0)
     &    RETURN
       BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)%NB_ACCESSES_LEFT = 
     & BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)%NB_ACCESSES_LEFT - 1
       CALL SMUMPS_BLR_TRY_FREE_PANEL (IWHANDLER, IPANEL,
     &                   KEEP8, IS_FACTOR)
       RETURN
       END SUBROUTINE SMUMPS_BLR_DEC_AND_TRYFREE_L
       SUBROUTINE SMUMPS_BLR_TRY_FREE_PANEL( IWHANDLER, IPANEL, 
     &           KEEP8, IS_FACTOR )
       IMPLICIT NONE
       INTEGER, INTENT(IN) :: IWHANDLER, IPANEL
       INTEGER(8) :: KEEP8(150)
       LOGICAL, INTENT(IN) :: IS_FACTOR
       TYPE(blr_panel_type), POINTER  :: THEPANEL
       IF (IWHANDLER.LE.0) RETURN
       IF ( BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT.LT.0)
     &    RETURN
       THEPANEL => BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)
       IF ( THEPANEL%NB_ACCESSES_LEFT .EQ. 0 ) THEN
         IF (associated(THEPANEL%LRB_PANEL)) THEN
          IF (size(THEPANEL%LRB_PANEL) .GT.0) THEN
           CALL DEALLOC_BLR_PANEL(THEPANEL%LRB_PANEL,
     &        size(THEPANEL%LRB_PANEL), KEEP8, IS_FACTOR)
           DEALLOCATE(THEPANEL%LRB_PANEL)
           NULLIFY(THEPANEL%LRB_PANEL)
          ENDIF
         ENDIF
         THEPANEL%NB_ACCESSES_LEFT = PANELS_FREED 
       ENDIF
       RETURN
       END SUBROUTINE SMUMPS_BLR_TRY_FREE_PANEL
       SUBROUTINE SMUMPS_BLR_FREE_ALL_PANELS ( IWHANDLER, 
     &         KEEP8, IS_FACTOR )
       IMPLICIT NONE
       INTEGER, INTENT(IN) :: IWHANDLER
       INTEGER(8) :: KEEP8(150)
       LOGICAL, INTENT(IN) :: IS_FACTOR
       INTEGER             :: IPANEL
       TYPE(blr_panel_type), POINTER  :: THEPANEL
       IF (IWHANDLER.LE.0) RETURN
       IF (BLR_ARRAY(IWHANDLER)%NB_ACCESSES_INIT.EQ.
     &      PANELS_NOTUSED) RETURN
       DO IPANEL = 1, size(BLR_ARRAY(IWHANDLER)%PANELS_L)
       THEPANEL => BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)
         IF (associated(THEPANEL%LRB_PANEL)) THEN
          IF (size(THEPANEL%LRB_PANEL) .GT.0) THEN
           CALL DEALLOC_BLR_PANEL(THEPANEL%LRB_PANEL,
     &        size(THEPANEL%LRB_PANEL), KEEP8, IS_FACTOR)
           DEALLOCATE(THEPANEL%LRB_PANEL)
          ENDIF
          NULLIFY(THEPANEL%LRB_PANEL)
         ENDIF
         THEPANEL%NB_ACCESSES_LEFT = PANELS_FREED 
       ENDDO
       IF (.NOT.BLR_ARRAY(IWHANDLER)%IsSYM) THEN
         DO IPANEL = 1, size(BLR_ARRAY(IWHANDLER)%PANELS_U)
           THEPANEL => BLR_ARRAY(IWHANDLER)%PANELS_U(IPANEL)
          IF (associated(THEPANEL%LRB_PANEL)) THEN
           IF (size(THEPANEL%LRB_PANEL) .GT.0) THEN
            CALL DEALLOC_BLR_PANEL(THEPANEL%LRB_PANEL,
     &        size(THEPANEL%LRB_PANEL), KEEP8, IS_FACTOR)
            DEALLOCATE(THEPANEL%LRB_PANEL)
           ENDIF
           NULLIFY(THEPANEL%LRB_PANEL)
          ENDIF
          THEPANEL%NB_ACCESSES_LEFT = PANELS_FREED 
         ENDDO
       ENDIF
       RETURN
       END SUBROUTINE SMUMPS_BLR_FREE_ALL_PANELS
       SUBROUTINE SMUMPS_BLR_FREE_PANEL( IWHANDLER, LORU, IPANEL,
     &                 KEEP8, IS_FACTOR )
       IMPLICIT NONE
       INTEGER, INTENT(IN) :: IWHANDLER, IPANEL
       INTEGER, INTENT(IN) :: LORU
       INTEGER(8) :: KEEP8(150)
       LOGICAL, INTENT(IN) :: IS_FACTOR
       TYPE(blr_panel_type), POINTER  :: THEPANEL
       IF (IWHANDLER.LE.0) RETURN
       IF (LORU.EQ.0.or.LORU.EQ.1) THEN
        IF (LORU.EQ.0) THEN
         THEPANEL => BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)
        ELSE 
         THEPANEL => BLR_ARRAY(IWHANDLER)%PANELS_U(IPANEL)
        ENDIF
         IF (associated(THEPANEL%LRB_PANEL)) THEN
          IF (size(THEPANEL%LRB_PANEL) .GT.0) THEN
            CALL DEALLOC_BLR_PANEL(THEPANEL%LRB_PANEL,
     &        size(THEPANEL%LRB_PANEL), KEEP8, IS_FACTOR)
            DEALLOCATE(THEPANEL%LRB_PANEL)
          ENDIF
          NULLIFY(THEPANEL%LRB_PANEL)
         ENDIF
         THEPANEL%NB_ACCESSES_LEFT = PANELS_FREED 
       ELSE
         THEPANEL => BLR_ARRAY(IWHANDLER)%PANELS_L(IPANEL)
         IF (associated(THEPANEL%LRB_PANEL)) THEN
           IF (size(THEPANEL%LRB_PANEL) .GT.0) THEN
             CALL DEALLOC_BLR_PANEL(THEPANEL%LRB_PANEL,
     &        size(THEPANEL%LRB_PANEL), KEEP8, IS_FACTOR)
             DEALLOCATE(THEPANEL%LRB_PANEL)
           ENDIF
           NULLIFY(THEPANEL%LRB_PANEL)
         ENDIF
         THEPANEL%NB_ACCESSES_LEFT = PANELS_FREED 
         THEPANEL => BLR_ARRAY(IWHANDLER)%PANELS_U(IPANEL)
         IF (associated(THEPANEL%LRB_PANEL)) THEN
           IF (size(THEPANEL%LRB_PANEL) .GT.0) THEN
             CALL DEALLOC_BLR_PANEL(THEPANEL%LRB_PANEL,
     &        size(THEPANEL%LRB_PANEL), KEEP8, IS_FACTOR)
             DEALLOCATE(THEPANEL%LRB_PANEL)
           ENDIF
           NULLIFY(THEPANEL%LRB_PANEL)
         ENDIF
         THEPANEL%NB_ACCESSES_LEFT = PANELS_FREED 
        ENDIF
       RETURN
       END SUBROUTINE SMUMPS_BLR_FREE_PANEL
      END MODULE SMUMPS_LR_DATA_M
