import os.path, shutil
import zope.interface

from multibuild.builder.hooks import interfaces, register, support

class Hook(support.Hook):
    zope.interface.implements(interfaces.IHookBuildResult)

    name = "copy-changes"
    default_priority = 60

    def result(self, build):
        changes = self.filename_changes(build)
        path = os.path.join(build.environment.build_path, changes)
        out = os.path.join(os.path.expanduser(build.extra.get('result-dir', "~/build")), changes)
        f1 = file(path)
        f2 = file(out, 'w')
        for i in f1:
            if i.startswith("Distribution:"):
                f2.write("Distribution: %s\n" % build.environment.dist)
            else:
                f2.write(i)
        f1.close()
        f2.close()

register(Hook)
