/*
 * Decompiled with CFR 0.152.
 */
package org.petzall.daapapplet;

import org.cdavies.itunes.Track;
import org.petzall.daapapplet.PlayerThread;
import org.petzall.daapapplet.gui.GUI;
import org.petzall.daapapplet.tracklist.TrackList;

public class DAAPControls {
    private GUI _gui;
    private TrackList _trackList;
    private PlayerThread _thread;
    private int _playIndex;
    private boolean _playing;
    private boolean _contPlay;

    public DAAPControls(TrackList trackList, GUI gUI) {
        this._gui = gUI;
        this._trackList = trackList;
        this._playIndex = -1;
        this._thread = new PlayerThread(this._gui, this);
        this._thread.start();
        this._playing = false;
    }

    public int getCurrentTrackLength() {
        if (!this._playing) {
            return -1;
        }
        return this._thread.getLength();
    }

    public int getCurrentTrackPosition() {
        if (!this._playing) {
            return -1;
        }
        return this._thread.getPosition();
    }

    public synchronized void noNextTrack() {
        this._contPlay = false;
    }

    public synchronized boolean isPlaying() {
        return this._playing;
    }

    public synchronized void stopped() {
        this._gui.setPlayState(0);
        this._playing = false;
    }

    public Track getNextTrack() {
        if (this._playIndex == -1) {
            return null;
        }
        if (this._playIndex == this._trackList.getRowCount() - 1) {
            this._contPlay = false;
        }
        return this._trackList.getTrack(this._playIndex++);
    }

    public void playingTrack(Track track) {
        this._gui.setTrack(track);
    }

    public synchronized boolean continuePlaying() {
        return this._contPlay;
    }

    public boolean closeDownMode() {
        return false;
    }

    public synchronized void playSelectedTrack() {
        this.stopTrack();
        this._gui.setPlayState(1);
        this._playIndex = this._gui.getSelectedTrack();
        this._contPlay = true;
        this._playing = true;
    }

    public synchronized void stopTrack() {
        if (!this._playing) {
            return;
        }
        this._playing = false;
        this._contPlay = false;
        this._thread.stopTrack();
    }

    public synchronized void playNextTrack() {
        if (this._playIndex == this._trackList.getRowCount() - 1) {
            return;
        }
        this.stopTrack();
        this._gui.setPlayState(1);
        this._contPlay = true;
        this._playing = true;
    }

    public synchronized void playPreviousTrack() {
        if (this._playIndex == 0) {
            return;
        }
        this.stopTrack();
        this._gui.setPlayState(1);
        this._playIndex -= 2;
        if (this._playIndex < 0) {
            this._playIndex = 0;
        }
        this._contPlay = true;
        this._playing = true;
    }
}

