/*
 * Decompiled with CFR 0.152.
 */
package org.cdavies.itunes.hash;

import com.twmacinta.util.MD5;
import org.cdavies.itunes.hash.ItunesHash;
import org.cdavies.itunes.utils.HexString;

public class Itunes45Hash
implements ItunesHash {
    public static int HASH_SIZE = 32;
    private String _staticHash = null;
    private static String _appleCopyright = "Copyright 2003 Apple Computer, Inc.";

    public Itunes45Hash() {
        this.calculateStaticHash();
    }

    private void calculateStaticHash() {
        StringBuffer stringBuffer = new StringBuffer(8192);
        for (int i = 0; i < 256; ++i) {
            MD5 mD5 = new MD5();
            if ((i & 0x40) != 0) {
                mD5.Update("eqwsdxcqwesdc".getBytes());
            } else {
                mD5.Update("op[;lm,piojkmn".getBytes());
            }
            if ((i & 0x20) != 0) {
                mD5.Update("876trfvb 34rtgbvc".getBytes());
            } else {
                mD5.Update("=-0ol.,m3ewrdfv".getBytes());
            }
            if ((i & 0x10) != 0) {
                mD5.Update("87654323e4rgbv ".getBytes());
            } else {
                mD5.Update("1535753690868867974342659792".getBytes());
            }
            if ((i & 8) != 0) {
                mD5.Update("Song Name".getBytes());
            } else {
                mD5.Update("DAAP-CLIENT-ID:".getBytes());
            }
            if ((i & 4) != 0) {
                mD5.Update("111222333444555".getBytes());
            } else {
                mD5.Update("4089961010".getBytes());
            }
            if ((i & 2) != 0) {
                mD5.Update("playlist-item-spec".getBytes());
            } else {
                mD5.Update("revision-number".getBytes());
            }
            if ((i & 1) != 0) {
                mD5.Update("session-id".getBytes());
            } else {
                mD5.Update("content-codes".getBytes());
            }
            if ((i & 0x80) != 0) {
                mD5.Update("IUYHGFDCXWEDFGHN".getBytes());
            } else {
                mD5.Update("iuytgfdxwerfghjm".getBytes());
            }
            stringBuffer.append(HexString.bytesToHexString(mD5.Final()));
        }
        this._staticHash = stringBuffer.toString();
    }

    public String generateHash(String string, int n, int n2) {
        if (this._staticHash == null) {
            return null;
        }
        MD5 mD5 = new MD5();
        int n3 = HASH_SIZE * n;
        int n4 = n3 + HASH_SIZE;
        mD5.Update(string.getBytes());
        mD5.Update(_appleCopyright.getBytes());
        mD5.Update(this._staticHash.substring(n3, n4).getBytes());
        if (n2 != -1) {
            mD5.Update(new Integer(n2).toString().getBytes());
        }
        return HexString.bytesToHexString(mD5.Final());
    }
}

