#ifndef INOTIFY_WATCHERBASE_H
#define INOTIFY_WATCHERBASE_H

#include <stdint.h>

#include "compat.h"
#include "watcher.h"
#include "state.h"

// Watches the root of a Maildir++ tree or Maildir for sub-Maildir creations
class watcher_base : public watcher
{
  public:
	watcher_base(struct inotify_state* state);
	virtual ~watcher_base();

	virtual void process_event(const struct inotify_event& event);

	// watcher_base uses its own inotify fd so that it does not
	// clash with Maildir watcher tracked by state
	const int inotify_fd;

  private:
	static const uint32_t notify = IN_CREATE | IN_MOVE | IN_DELETE_SELF;

	struct inotify_state* state;
	int wd;
};

#endif // INOTIFY_WATCHERBASE_H
