/* Time-stamp: <2007-10-05 01:59:22 poser> */
/*
 * Copyright (C) 1993-2007 William J. Poser.
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 3 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * or go to the web page:  http://www.gnu.org/licenses/gpl.txt.
 *	 
 */

#include "config.h"
#include "compdefs.h"

#include <stdlib.h>
#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif
#include <wchar.h>
#ifdef HAVE_UNINUM_UNICODE_H
#include <uninum/unicode.h>
#else
#include "unicode.h"
#endif
#include "exitcode.h"
#include "retcodes.h"
#define  DSTR
#include "dstr.h"

/* Initialize a dynamic string */

void
InitializeDynamicString (struct dstr *s) {
  s->s = NULL;
  s->c = s->l = 0;
}

void
FreeDynamicString(struct dstr *d) {
  if (d) {
    if (d->s != NULL) free( (void *) (d->s));
    free ( (void *) d);
  }
}

/* 
 * Create a dynamic wide string and copy into it an existing regular wide string.
 */

struct dstr *MakeDynamicString(wchar_t *s) {
  struct dstr *new;
  int length;

  new = (struct dstr *) malloc(sizeof(struct dstr));
  if(new == NULL) exit(OUTOFMEMORY);
  length = wcslen(s);
  new->s = (wchar_t *) malloc((length + 1) * sizeof(wchar_t));
  if(new->s == NULL) exit(OUTOFMEMORY);
  wcscpy(new->s,s);
  new->c = new->l = length;
  return(new);
} 

/* 
 * Insert an existing wide string into a dynamic string.
 */

int
FillDynamicString(struct dstr *tgt, wchar_t *src) {
  int length;

  length = wcslen(src);
  if (length > tgt->c) {
    if(tgt->s != NULL) free( (void *) tgt->s);
    tgt->s = (wchar_t *) malloc((length + 1) * sizeof(wchar_t));
    if(tgt->s == NULL) return(ERROR);
    tgt->c = length;
  }
  wcscpy(tgt->s,src);
  tgt->l = length;
  return(SUCCESS);
} 

/* Append a wide string to a dynamic wide string */
int
AppendToDynamicString(struct dstr *tgt, wchar_t *src) {
  int SrcLength;
  int NewLength;

  SrcLength = wcslen(src);
  NewLength = SrcLength + tgt->l;

  if (NewLength > tgt->c) {
    tgt->s = (wchar_t *) realloc(tgt->s,(NewLength + 1) * sizeof(wchar_t));
    if(tgt->s == NULL) return(ERROR);
    tgt->c = NewLength;
  }
  wcscpy(tgt->s+tgt->l,src);
  tgt->l = NewLength;
  return(SUCCESS);
} 
