/*
 * conffile.h
 *
 * This file is part of msmtp, an SMTP client.
 *
 * Copyright (C) 2000, 2003, 2004
 * Martin Lambers <marlam@users.sourceforge.net>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   msmtp is released under the GPL with the additional exemption that
 *   compiling, linking, and/or using OpenSSL is allowed.
 */

#ifndef CONFFILE_H
#define CONFFILE_H

#include "list.h"

#define CONFFILE_ENOMEM		1	/* Cannot allocate memory */
#define CONFFILE_EIO		2	/* Input/output error */
#define CONFFILE_EPARSE		3	/* Parse error */
#define CONFFILE_ESYNTAX	4	/* Syntax error */

typedef struct
{
    char *id;			/* name of this account */
    char *host;			/* hostname of SMTP server */
    int port;			/* port number */
    char *domain;		/* argument to EHLO command */
    char *from;			/* envelope from address */
    char *auth_mech;		/* authentication mechanism */
    char *username;		/* username for authentication */
    char *password;		/* password for authentication */
    int tls;			/* flag: use TLS? */
    char *tls_key_file;		/* file in PEM format */
    char *tls_cert_file;	/* file in PEM format */
    char *tls_trust_file;	/* file in PEM format */
    int tls_nocertcheck;	/* flag: do not check certificate? */
    int tls_nostarttls;		/* flag: start TLS immediatly (without STARTTLS command)? */
    char *dsn_return;		/* DSN return request */
    char *dsn_notify;		/* DSN notify request */
    int keepbcc;		/* flag: keep the Bcc header in the mail? */
    char *logfile;		/* logfile */
} account_t;

/*
 * get_conf()
 * 
 * Read 'conffile' and store all account data in 'acc_list'.
 * Used error codes: CONFFILE_ENOMEM, CONFFILE_EIO, 
 *                   CONFFILE_EPARSE, CONFFILE_ESYNTAX
 */
merror_t get_conf(char *conffile, list_t **acc_list);

/* 
 * account_free()
 * 
 * Free an account_t.
 */
void account_free(void *a);

/*
 * find_account()
 * 
 * Find an account in a list of accounts by its id.
 * Returns the account or NULL.
 */
account_t *find_account(list_t *acc_list, char *id);

#endif
