from typing import Any, ClassVar, List

from typing import overload
import mrpt.pymrpt.mrpt.config
import mrpt.pymrpt.mrpt.img
import mrpt.pymrpt.mrpt.math
import mrpt.pymrpt.mrpt.obs
import mrpt.pymrpt.mrpt.obs.CObservationVelodyneScan
import mrpt.pymrpt.mrpt.poses
import mrpt.pymrpt.std
import mrpt.pymrpt.std.chrono
CAMERA_CV_AUTODETECT: TCameraType
CAMERA_CV_DC1394: TCameraType
CAMERA_CV_DSHOW: TCameraType
CAMERA_CV_MIL: TCameraType
CAMERA_CV_VFL: TCameraType
CAMERA_CV_VFW: TCameraType
EZ1: SensorType
INCREMENTAL_ANGLE: GYRO_MODE
INTEGRATED_ANGLE: GYRO_MODE
RATE: GYRO_MODE
SHARP_30cm: SensorType
SHARP_80cm: SensorType
UNPLUGGED: SensorType

class C2DRangeFinderAbstract(CGenericSensor):
    def __init__(self) -> None: ...
    def bindIO(self, *args, **kwargs) -> Any: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doProcessSimple(self, outThereIsObservation: bool, outObservation: mrpt.pymrpt.mrpt.obs.CObservation2DRangeScan, hardwareError: bool) -> None: ...
    @overload
    def getEstimatedScanPeriod(self) -> float: ...
    @overload
    def getEstimatedScanPeriod() -> double: ...
    def getObservation(self, outThereIsObservation: bool, outObservation: mrpt.pymrpt.mrpt.obs.CObservation2DRangeScan, hardwareError: bool) -> None: ...
    @overload
    def showPreview(self) -> None: ...
    @overload
    def showPreview(self, enable: bool) -> None: ...
    @overload
    def showPreview(bool) -> void: ...
    @overload
    def turnOff(self) -> bool: ...
    @overload
    def turnOff() -> bool: ...
    @overload
    def turnOn(self) -> bool: ...
    @overload
    def turnOn() -> bool: ...

class CBoardENoses(CGenericSensor):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    def getObservation(self, *args, **kwargs) -> Any: ...
    def getSerialPort(self) -> str: ...
    @overload
    def getSerialPortBaud(self) -> int: ...
    @overload
    def getSerialPortBaud() -> unsignedint: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    @overload
    def queryFirmwareVersion(self, out_firmwareVersion: str) -> bool: ...
    @overload
    def queryFirmwareVersion(std) -> bool: ...
    @overload
    def setActiveChamber(self, chamber: int) -> bool: ...
    @overload
    def setActiveChamber(unsignedchar) -> bool: ...
    @overload
    def setSerialPort(self, port: str) -> None: ...
    @overload
    def setSerialPort(conststd) -> void: ...
    @overload
    def setSerialPortBaud(self, baud: int) -> None: ...
    @overload
    def setSerialPortBaud(unsignedint) -> void: ...

class CCANBusReader(CGenericSensor):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doProcessSimple(self, outThereIsObservation: bool, outObservation: mrpt.pymrpt.mrpt.obs.CObservationCANBusJ1939, hardwareError: bool) -> None: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def getBaudRate(self) -> int: ...
    @overload
    def getBaudRate() -> int: ...
    @overload
    def getCANReaderSpeed(self) -> int: ...
    @overload
    def getCANReaderSpeed() -> unsignedint: ...
    @overload
    def getCANReaderTimeStamping(self) -> bool: ...
    @overload
    def getCANReaderTimeStamping() -> bool: ...
    @overload
    def getCurrentConnectTry(self) -> int: ...
    @overload
    def getCurrentConnectTry() -> unsignedint: ...
    def getSerialPort(self) -> str: ...
    def initialize(self, *args, **kwargs) -> Any: ...
    @overload
    def setBaudRate(self, baud: int) -> None: ...
    @overload
    def setBaudRate(int) -> void: ...
    @overload
    def setCANReaderSpeed(self, speed: int) -> None: ...
    @overload
    def setCANReaderSpeed(constunsignedint) -> void: ...
    @overload
    def setCANReaderTimeStamping(self) -> None: ...
    @overload
    def setCANReaderTimeStamping(self, setTimestamp: bool) -> None: ...
    @overload
    def setCANReaderTimeStamping(bool) -> void: ...
    @overload
    def setSerialPort(self, port: str) -> None: ...
    @overload
    def setSerialPort(conststd) -> void: ...

class CCameraSensor(CGenericSensor):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    def addPreSaveHook(self, user_function, user_ptr: capsule) -> None: ...
    @overload
    def close(self) -> None: ...
    @overload
    def close() -> void: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def enableLaunchOwnThreadForSavingImages(self) -> None: ...
    @overload
    def enableLaunchOwnThreadForSavingImages(self, enable: bool) -> None: ...
    @overload
    def enableLaunchOwnThreadForSavingImages(bool) -> void: ...
    def getNextFrame(self) -> mrpt.pymrpt.mrpt.obs.CObservation: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    def setPathForExternalImages(self, *args, **kwargs) -> Any: ...
    @overload
    def setSoftwareTriggerLevel(self, level: bool) -> None: ...
    @overload
    def setSoftwareTriggerLevel(bool) -> void: ...

class CEnoseModular(CGenericSensor):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    def getObservation(self, *args, **kwargs) -> Any: ...
    def getSerialPort(self) -> str: ...
    @overload
    def getSerialPortBaud(self) -> int: ...
    @overload
    def getSerialPortBaud() -> unsignedint: ...
    @overload
    def setSerialPort(self, port: str) -> None: ...
    @overload
    def setSerialPort(conststd) -> void: ...
    @overload
    def setSerialPortBaud(self, baud: int) -> None: ...
    @overload
    def setSerialPortBaud(unsignedint) -> void: ...

class CFFMPEG_InputStream:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CFFMPEG_InputStream) -> None: ...
    def assign(self) -> CFFMPEG_InputStream: ...
    @overload
    def close(self) -> None: ...
    @overload
    def close() -> void: ...
    @overload
    def getVideoFPS(self) -> float: ...
    @overload
    def getVideoFPS() -> double: ...
    @overload
    def isOpen(self) -> bool: ...
    @overload
    def isOpen() -> bool: ...
    def openURL(self, *args, **kwargs) -> Any: ...
    def retrieveFrame(self, *args, **kwargs) -> Any: ...

class CGPSInterface(CGenericSensor):
    class PARSERS:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        AUTO: ClassVar[CGPSInterface.PARSERS] = ...
        NMEA: ClassVar[CGPSInterface.PARSERS] = ...
        NONE: ClassVar[CGPSInterface.PARSERS] = ...
        NOVATEL_OEM6: ClassVar[CGPSInterface.PARSERS] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    AUTO: ClassVar[CGPSInterface.PARSERS] = ...
    NMEA: ClassVar[CGPSInterface.PARSERS] = ...
    NONE: ClassVar[CGPSInterface.PARSERS] = ...
    NOVATEL_OEM6: ClassVar[CGPSInterface.PARSERS] = ...
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def enableAppendMsgTypeToSensorLabel(self, enable: bool) -> None: ...
    @overload
    def enableAppendMsgTypeToSensorLabel(bool) -> void: ...
    @overload
    def enableSetupCommandsAppendCRLF(self, enable: bool) -> None: ...
    @overload
    def enableSetupCommandsAppendCRLF(constbool) -> void: ...
    @overload
    def getLastGGA(self) -> str: ...
    @overload
    def getLastGGA(self, reset: bool) -> str: ...
    def getParser(self) -> CGPSInterface.PARSERS: ...
    def getRawDumpFilePrefix(self) -> str: ...
    def getSerialPortName(self) -> str: ...
    def getSetupCommands(self) -> List[str]: ...
    @overload
    def getSetupCommandsDelay(self) -> float: ...
    @overload
    def getSetupCommandsDelay() -> double: ...
    def getShutdownCommands(self) -> List[str]: ...
    def implement_parser_NMEA(self, *args, **kwargs) -> Any: ...
    def implement_parser_NOVATEL_OEM6(self, out_minimum_rx_buf_to_decide: int) -> bool: ...
    @overload
    def isAIMConfigured(self) -> bool: ...
    @overload
    def isAIMConfigured() -> bool: ...
    @overload
    def isEnabledSetupCommandsAppendCRLF(self) -> bool: ...
    @overload
    def isEnabledSetupCommandsAppendCRLF() -> bool: ...
    @overload
    def isGPS_connected(self) -> bool: ...
    @overload
    def isGPS_connected() -> bool: ...
    def parse_NMEA(self, *args, **kwargs) -> Any: ...
    def sendCustomCommand(self, *args, **kwargs) -> Any: ...
    @overload
    def setParser(self, parser: CGPSInterface.PARSERS) -> None: ...
    @overload
    def setParser(enummrpt) -> void: ...
    @overload
    def setRawDumpFilePrefix(self, filePrefix: str) -> None: ...
    @overload
    def setRawDumpFilePrefix(conststd) -> void: ...
    def setSerialPortName(self, COM_port: str) -> None: ...
    @overload
    def setSetupCommands(self, cmds: List[str]) -> None: ...
    @overload
    def setSetupCommands(constclassstd) -> void: ...
    @overload
    def setSetupCommandsDelay(self, delay_secs: float) -> None: ...
    @overload
    def setSetupCommandsDelay(constdouble) -> void: ...
    @overload
    def setShutdownCommands(self, cmds: List[str]) -> None: ...
    @overload
    def setShutdownCommands(constclassstd) -> void: ...
    @overload
    def useExternalStream(self) -> bool: ...
    @overload
    def useExternalStream() -> bool: ...

class CGPS_NTRIP(CGenericSensor):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...

class CGenericSensor:
    class TSensorState:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        ssError: ClassVar[CGenericSensor.TSensorState] = ...
        ssInitializing: ClassVar[CGenericSensor.TSensorState] = ...
        ssUninitialized: ClassVar[CGenericSensor.TSensorState] = ...
        ssWorking: ClassVar[CGenericSensor.TSensorState] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    ssError: ClassVar[CGenericSensor.TSensorState] = ...
    ssInitializing: ClassVar[CGenericSensor.TSensorState] = ...
    ssUninitialized: ClassVar[CGenericSensor.TSensorState] = ...
    ssWorking: ClassVar[CGenericSensor.TSensorState] = ...
    def __init__(self) -> None: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    def createSensor(self, *args, **kwargs) -> Any: ...
    def createSensorPtr(self, *args, **kwargs) -> Any: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    @overload
    def enableVerbose(self) -> None: ...
    @overload
    def enableVerbose(self, enabled: bool) -> None: ...
    @overload
    def enableVerbose(bool) -> void: ...
    @overload
    def getExternalImageJPEGQuality(self) -> int: ...
    @overload
    def getExternalImageJPEGQuality() -> unsignedint: ...
    def getObservations(self) -> mrpt.pymrpt.std.multimap_std_chrono_time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_std_shared_ptr_mrpt_serialization_CSerializable_t: ...
    @overload
    def getProcessRate(self) -> float: ...
    @overload
    def getProcessRate() -> double: ...
    def getSensorLabel(self) -> str: ...
    def getState(self) -> CGenericSensor.TSensorState: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    @overload
    def isVerboseEnabled(self) -> bool: ...
    @overload
    def isVerboseEnabled() -> bool: ...
    @overload
    def loadConfig(self, configSource: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
    @overload
    def loadConfig(constclassmrpt, conststd) -> void: ...
    def registerClass(self, *args, **kwargs) -> Any: ...
    @overload
    def setExternalImageFormat(self, ext: str) -> None: ...
    @overload
    def setExternalImageFormat(conststd) -> void: ...
    @overload
    def setExternalImageJPEGQuality(self, quality: int) -> None: ...
    @overload
    def setExternalImageJPEGQuality(constunsignedint) -> void: ...
    def setPathForExternalImages(self, *args, **kwargs) -> Any: ...
    @overload
    def setSensorLabel(self, sensorLabel: str) -> None: ...
    @overload
    def setSensorLabel(conststd) -> void: ...

class CGillAnemometer(CGenericSensor):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def loadConfig_sensorSpecific(self, configSource: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
    @overload
    def loadConfig_sensorSpecific(constclassmrpt, conststd) -> void: ...

class CGyroKVHDSP3000(CGenericSensor):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def changeMode(self, _newMode: GYRO_MODE) -> None: ...
    @overload
    def changeMode(enummrpt) -> void: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    @overload
    def loadConfig_sensorSpecific(self, configSource: mrpt.pymrpt.mrpt.config.CConfigFileBase, iniSection: str) -> None: ...
    @overload
    def loadConfig_sensorSpecific(constclassmrpt, conststd) -> void: ...
    @overload
    def resetIncrementalAngle(self) -> None: ...
    @overload
    def resetIncrementalAngle() -> void: ...

class CHokuyoURG(C2DRangeFinderAbstract):
    class TSensorInfo:
        d_max: float
        d_min: float
        model: str
        motor_speed_rpm: int
        scan_first: int
        scan_front: int
        scan_last: int
        scans_per_360deg: int
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CHokuyoURG.TSensorInfo) -> None: ...
        def assign(self) -> CHokuyoURG.TSensorInfo: ...
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    def doProcessSimple(self, outThereIsObservation: bool, outObservation: mrpt.pymrpt.mrpt.obs.CObservation2DRangeScan, hardwareError: bool) -> None: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def getScanInterval(self) -> int: ...
    @overload
    def getScanInterval() -> unsignedint: ...
    def getSerialPort(self) -> str: ...
    @overload
    def purgeBuffers(self) -> None: ...
    @overload
    def purgeBuffers() -> void: ...
    def sendCmd(self, str: str) -> None: ...
    @overload
    def setHighSensitivityMode(self, enabled: bool) -> bool: ...
    @overload
    def setHighSensitivityMode(bool) -> bool: ...
    def setIPandPort(self, ip: str, port: int) -> None: ...
    @overload
    def setIntensityMode(self, enabled: bool) -> bool: ...
    @overload
    def setIntensityMode(bool) -> bool: ...
    @overload
    def setReducedFOV(self, fov: float) -> None: ...
    @overload
    def setReducedFOV(constdouble) -> void: ...
    @overload
    def setScanInterval(self, skipScanCount: int) -> None: ...
    @overload
    def setScanInterval(unsignedint) -> void: ...
    @overload
    def setSerialPort(self, port_name: str) -> None: ...
    @overload
    def setSerialPort(conststd) -> void: ...
    @overload
    def turnOff(self) -> bool: ...
    @overload
    def turnOff() -> bool: ...
    @overload
    def turnOn(self) -> bool: ...
    @overload
    def turnOn() -> bool: ...

class CIMUIntersense(CGenericSensor):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...

class CIMUXSens_MT4(CGenericSensor):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def close(self) -> None: ...
    @overload
    def close() -> void: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...

class CIbeoLuxETH(CGenericSensor):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: str) -> None: ...
    @overload
    def __init__(self, _ip: str, _port: int) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    def makeCommandHeader(self, buffer: int) -> None: ...
    def makeStartCommand(self, buffer: int) -> None: ...
    def makeStopCommand(self, buffer: int) -> None: ...
    def makeTypeCommand(self, buffer: int) -> None: ...

class CImageGrabber_FlyCapture2:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, options: TCaptureOptions_FlyCapture2) -> None: ...
    @overload
    def close(self) -> None: ...
    @overload
    def close() -> void: ...
    def getCameraOptions(self) -> TCaptureOptions_FlyCapture2: ...
    def getFC2version(self, *args, **kwargs) -> Any: ...
    @overload
    def getObservation(self, out_observation: mrpt.pymrpt.mrpt.obs.CObservationImage) -> bool: ...
    @overload
    def getObservation(classmrpt) -> bool: ...
    @overload
    def getObservation(self, out_observation: mrpt.pymrpt.mrpt.obs.CObservationStereoImages) -> bool: ...
    @overload
    def getObservation(classmrpt) -> bool: ...
    @overload
    def isStereo(self) -> bool: ...
    @overload
    def isStereo() -> bool: ...
    @overload
    def open(self, options: TCaptureOptions_FlyCapture2) -> None: ...
    @overload
    def open(self, options: TCaptureOptions_FlyCapture2, startCapture: bool) -> None: ...
    @overload
    def open(conststructmrpt, constbool) -> void: ...
    @overload
    def startCapture(self) -> None: ...
    @overload
    def startCapture() -> void: ...
    @overload
    def stopCapture(self) -> None: ...
    @overload
    def stopCapture() -> void: ...

class CImageGrabber_OpenCV:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, cameraIndex: int) -> None: ...
    @overload
    def __init__(self, cameraIndex: int, cameraType: TCameraType) -> None: ...
    @overload
    def __init__(self, cameraIndex: int, cameraType: TCameraType, options: TCaptureCVOptions) -> None: ...
    @overload
    def __init__(self, AVI_fileName: str) -> None: ...
    @overload
    def __init__(self, arg0: CImageGrabber_OpenCV) -> None: ...
    def assign(self) -> CImageGrabber_OpenCV: ...
    @overload
    def getObservation(self, out_observation: mrpt.pymrpt.mrpt.obs.CObservationImage) -> bool: ...
    @overload
    def getObservation(classmrpt) -> bool: ...
    @overload
    def isOpen(self) -> bool: ...
    @overload
    def isOpen() -> bool: ...

class CImageGrabber_dc1394:
    class TCameraInfo:
        PIO_control_csr: int
        SIO_control_csr: int
        advanced_features_csr: int
        bmode_capable: bool
        can_switch_on_off: bool
        command_registers_base: int
        guid: int
        has_feature_error_status: bool
        has_vmode_error_status: bool
        iidc_version: int
        max_mem_channel: int
        model: str
        model_id: int
        multi_shot_capable: bool
        one_shot_capable: bool
        strobe_control_csr: int
        unit: int
        unit_dependent_directory: int
        unit_directory: int
        unit_spec_ID: int
        unit_sub_sw_version: int
        unit_sw_version: int
        vendor: str
        vendor_id: int
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CImageGrabber_dc1394.TCameraInfo) -> None: ...
        def assign(self) -> CImageGrabber_dc1394.TCameraInfo: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, cameraGUID: int) -> None: ...
    @overload
    def __init__(self, cameraGUID: int, cameraUnit: int) -> None: ...
    @overload
    def __init__(self, cameraGUID: int, cameraUnit: int, options: TCaptureOptions_dc1394) -> None: ...
    @overload
    def __init__(self, cameraGUID: int, cameraUnit: int, options: TCaptureOptions_dc1394, verbose: bool) -> None: ...
    def assign(self) -> CImageGrabber_dc1394: ...
    @overload
    def changeCaptureOptions(self, options: TCaptureOptions_dc1394) -> bool: ...
    @overload
    def changeCaptureOptions(conststructmrpt) -> bool: ...
    @overload
    def getObservation(self, out_observation: mrpt.pymrpt.mrpt.obs.CObservationImage) -> bool: ...
    @overload
    def getObservation() -> Any: ...
    @overload
    def getObservation(classmrpt) -> bool: ...
    @overload
    def getObservation(self, out_observation: mrpt.pymrpt.mrpt.obs.CObservationStereoImages) -> bool: ...
    @overload
    def getObservation(classmrpt) -> bool: ...
    @overload
    def isOpen(self) -> bool: ...
    @overload
    def isOpen() -> bool: ...
    @overload
    def setSoftwareTriggerLevel(self, level: bool) -> bool: ...
    @overload
    def setSoftwareTriggerLevel(bool) -> bool: ...

class CImpinjRFID(CGenericSensor):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def closeReader(self) -> None: ...
    @overload
    def closeReader() -> void: ...
    @overload
    def connect(self) -> None: ...
    @overload
    def connect() -> void: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def getObservation(self, obs: mrpt.pymrpt.mrpt.obs.CObservationRFID) -> bool: ...
    @overload
    def getObservation(classmrpt) -> bool: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    @overload
    def loadConfig_sensorSpecific(self, configSource: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
    @overload
    def loadConfig_sensorSpecific(constclassmrpt, conststd) -> void: ...

class CJoystick:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CJoystick) -> None: ...
    def assign(self) -> CJoystick: ...
    def getJoysticksCount(self, *args, **kwargs) -> Any: ...
    @overload
    def setLimits(self) -> None: ...
    @overload
    def setLimits(self, x_min: int) -> None: ...
    @overload
    def setLimits(self, x_min: int, x_max: int) -> None: ...
    @overload
    def setLimits(self, x_min: int, x_max: int, y_min: int) -> None: ...
    @overload
    def setLimits(self, x_min: int, x_max: int, y_min: int, y_max: int) -> None: ...
    @overload
    def setLimits(self, x_min: int, x_max: int, y_min: int, y_max: int, z_min: int) -> None: ...
    @overload
    def setLimits(self, x_min: int, x_max: int, y_min: int, y_max: int, z_min: int, z_max: int) -> None: ...

class CKinect(CGenericSensor):
    class TVideoChannel:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        VIDEO_CHANNEL_IR: ClassVar[CKinect.TVideoChannel] = ...
        VIDEO_CHANNEL_RGB: ClassVar[CKinect.TVideoChannel] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    VIDEO_CHANNEL_IR: ClassVar[CKinect.TVideoChannel] = ...
    VIDEO_CHANNEL_RGB: ClassVar[CKinect.TVideoChannel] = ...
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def close(self) -> None: ...
    @overload
    def close() -> void: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> size_t: ...
    @overload
    def disablePreviewRGB(self) -> None: ...
    @overload
    def disablePreviewRGB() -> void: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def enableGrab3DPoints(self) -> None: ...
    @overload
    def enableGrab3DPoints(self, enable: bool) -> None: ...
    @overload
    def enableGrab3DPoints(bool) -> void: ...
    @overload
    def enableGrabAccelerometers(self) -> None: ...
    @overload
    def enableGrabAccelerometers(self, enable: bool) -> None: ...
    @overload
    def enableGrabAccelerometers(bool) -> void: ...
    @overload
    def enableGrabDepth(self) -> None: ...
    @overload
    def enableGrabDepth(self, enable: bool) -> None: ...
    @overload
    def enableGrabDepth(bool) -> void: ...
    @overload
    def enableGrabRGB(self) -> None: ...
    @overload
    def enableGrabRGB(self, enable: bool) -> None: ...
    @overload
    def enableGrabRGB(bool) -> void: ...
    @overload
    def enablePreviewRGB(self) -> None: ...
    @overload
    def enablePreviewRGB(self, enable: bool) -> None: ...
    @overload
    def enablePreviewRGB(bool) -> void: ...
    def getCameraParamsDepth(self) -> mrpt.pymrpt.mrpt.img.TCamera: ...
    def getCameraParamsIntensity(self) -> mrpt.pymrpt.mrpt.img.TCamera: ...
    @overload
    def getDeviceIndexToOpen(self) -> int: ...
    @overload
    def getDeviceIndexToOpen() -> int: ...
    @overload
    def getMaxRange(self) -> float: ...
    @overload
    def getMaxRange() -> double: ...
    @overload
    def getNextObservation(self, out_obs: mrpt.pymrpt.mrpt.obs.CObservation3DRangeScan, there_is_obs: bool, hardware_error: bool) -> None: ...
    @overload
    def getNextObservation(self, out_obs: mrpt.pymrpt.mrpt.obs.CObservation3DRangeScan, out_obs_imu: mrpt.pymrpt.mrpt.obs.CObservationIMU, there_is_obs: bool, hardware_error: bool) -> None: ...
    @overload
    def getPreviewDecimation(self) -> int: ...
    @overload
    def getPreviewDecimation() -> size_t: ...
    def getRelativePoseIntensityWrtDepth(self) -> mrpt.pymrpt.mrpt.poses.CPose3D: ...
    @overload
    def getTiltAngleDegrees(self) -> float: ...
    @overload
    def getTiltAngleDegrees() -> double: ...
    def getVideoChannel(self) -> CKinect.TVideoChannel: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    @overload
    def isGrab3DPointsEnabled(self) -> bool: ...
    @overload
    def isGrab3DPointsEnabled() -> bool: ...
    @overload
    def isGrabAccelerometersEnabled(self) -> bool: ...
    @overload
    def isGrabAccelerometersEnabled() -> bool: ...
    @overload
    def isGrabDepthEnabled(self) -> bool: ...
    @overload
    def isGrabDepthEnabled() -> bool: ...
    @overload
    def isGrabRGBEnabled(self) -> bool: ...
    @overload
    def isGrabRGBEnabled() -> bool: ...
    @overload
    def isOpen(self) -> bool: ...
    @overload
    def isOpen() -> bool: ...
    @overload
    def isPreviewRGBEnabled(self) -> bool: ...
    @overload
    def isPreviewRGBEnabled() -> bool: ...
    @overload
    def open(self) -> None: ...
    @overload
    def open() -> void: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> size_t: ...
    @overload
    def setCameraParamsDepth(self, p: mrpt.pymrpt.mrpt.img.TCamera) -> None: ...
    @overload
    def setCameraParamsDepth(constclassmrpt) -> void: ...
    @overload
    def setCameraParamsIntensity(self, p: mrpt.pymrpt.mrpt.img.TCamera) -> None: ...
    @overload
    def setCameraParamsIntensity(constclassmrpt) -> void: ...
    @overload
    def setDeviceIndexToOpen(self, index: int) -> None: ...
    @overload
    def setDeviceIndexToOpen(int) -> void: ...
    def setPathForExternalImages(self, *args, **kwargs) -> Any: ...
    @overload
    def setPreviewDecimation(self, decimation_factor: int) -> None: ...
    @overload
    def setPreviewDecimation(size_t) -> void: ...
    @overload
    def setRelativePoseIntensityWrtDepth(self, p: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setRelativePoseIntensityWrtDepth(constclassmrpt) -> void: ...
    @overload
    def setTiltAngleDegrees(self, angle: float) -> None: ...
    @overload
    def setTiltAngleDegrees(double) -> void: ...
    @overload
    def setVideoChannel(self, vch: CKinect.TVideoChannel) -> None: ...
    @overload
    def setVideoChannel(constenummrpt) -> void: ...

class CLMS100Eth(C2DRangeFinderAbstract):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: str) -> None: ...
    @overload
    def __init__(self, _ip: str, _port: int) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doProcessSimple(self, outThereIsObservation: bool, outObservation: mrpt.pymrpt.mrpt.obs.CObservation2DRangeScan, hardwareError: bool) -> None: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    @overload
    def setSensorPose(self, _pose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...
    @overload
    def turnOff(self) -> bool: ...
    @overload
    def turnOff() -> bool: ...
    @overload
    def turnOn(self) -> bool: ...
    @overload
    def turnOn() -> bool: ...

class CMyntEyeCamera:
    @overload
    def __init__(self, params: TMyntEyeCameraParameters) -> None: ...
    @overload
    def __init__(self, arg0: CMyntEyeCamera) -> None: ...
    def assign(self) -> CMyntEyeCamera: ...
    @overload
    def getObservation(self, out: mrpt.pymrpt.mrpt.obs.CObservation3DRangeScan) -> bool: ...
    @overload
    def getObservation(classmrpt) -> bool: ...
    @overload
    def isOpen(self) -> bool: ...
    @overload
    def isOpen() -> bool: ...

class CNTRIPClient:
    class NTRIPArgs:
        mountpoint: str
        password: str
        port: int
        server: str
        user: str
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CNTRIPClient.NTRIPArgs) -> None: ...
        def assign(self) -> CNTRIPClient.NTRIPArgs: ...

    class TMountPoint:
        authentication: str
        carrier: int
        compr_encryp: str
        country_code: str
        extra_info: str
        format: str
        format_details: str
        generator_model: str
        id: str
        latitude: float
        longitude: float
        mountpoint_name: str
        nav_system: str
        needs_nmea: bool
        net_ref_stations: bool
        network: str
        pay_service: bool
        stream_bitspersec: int
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CNTRIPClient.TMountPoint) -> None: ...
        def assign(self) -> CNTRIPClient.TMountPoint: ...
    def __init__(self) -> None: ...
    @overload
    def close(self) -> None: ...
    @overload
    def close() -> void: ...
    @overload
    def open(self, params, out_errmsg: str) -> bool: ...
    @overload
    def open(conststructmrpt, std) -> bool: ...
    @overload
    def sendBackToServer(self, data: str) -> None: ...
    @overload
    def sendBackToServer(conststd) -> void: ...

class CNTRIPEmitter(CGenericSensor):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    def getNTRIPClient(self) -> CNTRIPClient: ...
    def getOutputSerialPort(self) -> str: ...
    def getRawOutputFilePrefix(self) -> str: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    @overload
    def setOutputSerialPort(self, port: str) -> None: ...
    @overload
    def setOutputSerialPort(conststd) -> void: ...
    @overload
    def setRawOutputFilePrefix(self, outfile: str) -> None: ...
    @overload
    def setRawOutputFilePrefix(conststd) -> void: ...

class CNationalInstrumentsDAQ(CGenericSensor):
    class TaskDescription:
        class desc_ai_t:
            maxVal: float
            minVal: float
            physicalChannel: str
            physicalChannelCount: int
            terminalConfig: str
            @overload
            def __init__(self) -> None: ...
            @overload
            def __init__(self, arg0: CNationalInstrumentsDAQ.TaskDescription.desc_ai_t) -> None: ...
            def assign(self) -> CNationalInstrumentsDAQ.TaskDescription.desc_ai_t: ...
    
        class desc_ao_t:
            maxVal: float
            minVal: float
            physicalChannel: str
            physicalChannelCount: int
            @overload
            def __init__(self) -> None: ...
            @overload
            def __init__(self, arg0: CNationalInstrumentsDAQ.TaskDescription.desc_ao_t) -> None: ...
            def assign(self) -> CNationalInstrumentsDAQ.TaskDescription.desc_ao_t: ...
    
        class desc_ci_ang_encoder_t:
            ZidxEnable: bool
            ZidxPhase: str
            ZidxVal: float
            counter: str
            decimate: int
            decimate_cnt: int
            decodingType: str
            initialAngle: float
            pulsesPerRev: int
            units: str
            @overload
            def __init__(self) -> None: ...
            @overload
            def __init__(self, arg0: CNationalInstrumentsDAQ.TaskDescription.desc_ci_ang_encoder_t) -> None: ...
            def assign(self) -> CNationalInstrumentsDAQ.TaskDescription.desc_ci_ang_encoder_t: ...
    
        class desc_ci_count_edges_t:
            countDirection: str
            counter: str
            edge: str
            initialCount: int
            @overload
            def __init__(self) -> None: ...
            @overload
            def __init__(self, arg0: CNationalInstrumentsDAQ.TaskDescription.desc_ci_count_edges_t) -> None: ...
            def assign(self) -> CNationalInstrumentsDAQ.TaskDescription.desc_ci_count_edges_t: ...
    
        class desc_ci_lin_encoder_t:
            ZidxEnable: bool
            ZidxPhase: str
            ZidxVal: float
            counter: str
            decodingType: str
            distPerPulse: float
            initialPos: float
            units: str
            @overload
            def __init__(self) -> None: ...
            @overload
            def __init__(self, arg0: CNationalInstrumentsDAQ.TaskDescription.desc_ci_lin_encoder_t) -> None: ...
            def assign(self) -> CNationalInstrumentsDAQ.TaskDescription.desc_ci_lin_encoder_t: ...
    
        class desc_ci_period_t:
            counter: str
            divisor: int
            edge: str
            maxVal: float
            measTime: float
            minVal: float
            units: str
            @overload
            def __init__(self) -> None: ...
            @overload
            def __init__(self, arg0: CNationalInstrumentsDAQ.TaskDescription.desc_ci_period_t) -> None: ...
            def assign(self) -> CNationalInstrumentsDAQ.TaskDescription.desc_ci_period_t: ...
    
        class desc_ci_pulse_width_t:
            counter: str
            maxVal: float
            minVal: float
            startingEdge: str
            units: str
            @overload
            def __init__(self) -> None: ...
            @overload
            def __init__(self, arg0: CNationalInstrumentsDAQ.TaskDescription.desc_ci_pulse_width_t) -> None: ...
            def assign(self) -> CNationalInstrumentsDAQ.TaskDescription.desc_ci_pulse_width_t: ...
    
        class desc_co_pulses_t:
            counter: str
            dutyCycle: float
            freq: float
            idleState: str
            initialDelay: float
            @overload
            def __init__(self) -> None: ...
            @overload
            def __init__(self, arg0: CNationalInstrumentsDAQ.TaskDescription.desc_co_pulses_t) -> None: ...
            def assign(self) -> CNationalInstrumentsDAQ.TaskDescription.desc_co_pulses_t: ...
    
        class desc_di_t:
            line: str
            @overload
            def __init__(self) -> None: ...
            @overload
            def __init__(self, arg0: CNationalInstrumentsDAQ.TaskDescription.desc_di_t) -> None: ...
            def assign(self) -> CNationalInstrumentsDAQ.TaskDescription.desc_di_t: ...
    
        class desc_do_t:
            line: str
            @overload
            def __init__(self) -> None: ...
            @overload
            def __init__(self, arg0: CNationalInstrumentsDAQ.TaskDescription.desc_do_t) -> None: ...
            def assign(self) -> CNationalInstrumentsDAQ.TaskDescription.desc_do_t: ...
        ai: Any
        ao: Any
        bufferSamplesPerChannel: int
        ci_ang_encoder: Any
        ci_count_edges: Any
        ci_lin_encoder: Any
        ci_period: Any
        ci_pulse_width: Any
        co_pulses: Any
        di: Any
        douts: Any
        has_ai: bool
        has_ao: bool
        has_ci_ang_encoder: bool
        has_ci_count_edges: bool
        has_ci_lin_encoder: bool
        has_ci_period: bool
        has_ci_pulse_width: bool
        has_co_pulses: bool
        has_di: bool
        has_do: bool
        sampleClkSource: str
        samplesPerChannelToRead: int
        samplesPerSecond: float
        taskLabel: str
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CNationalInstrumentsDAQ.TaskDescription) -> None: ...
        def assign(self) -> CNationalInstrumentsDAQ.TaskDescription: ...
    task_definitions: Any
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def checkDAQIsWorking(self) -> bool: ...
    @overload
    def checkDAQIsWorking() -> bool: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    @overload
    def stop(self) -> None: ...
    @overload
    def stop() -> void: ...
    def writeAnalogOutputTask(self, task_index: int, nSamplesPerChannel: int, volt_values: float, timeout: float, groupedByChannel: bool) -> None: ...
    @overload
    def writeDigitalOutputTask(self, task_index: int, line_value: bool, timeout: float) -> None: ...
    @overload
    def writeDigitalOutputTask(size_t, bool, double) -> void: ...

class COpenNI2Generic:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, fps: float) -> None: ...
    @overload
    def __init__(self, width: int, height: int, fps: float, open_streams_now: bool) -> None: ...
    @overload
    def __init__(self, arg0: COpenNI2Generic) -> None: ...
    def assign(self) -> COpenNI2Generic: ...
    @overload
    def close(self) -> None: ...
    @overload
    def close(self, sensor_id: int) -> None: ...
    @overload
    def getColorSensorParam(self, param: mrpt.pymrpt.mrpt.img.TCamera) -> bool: ...
    @overload
    def getColorSensorParam(self, param: mrpt.pymrpt.mrpt.img.TCamera, sensor_id: int) -> bool: ...
    @overload
    def getColorSensorParam(classmrpt, unsignedint) -> bool: ...
    @overload
    def getConnectedDevices(self) -> int: ...
    @overload
    def getConnectedDevices() -> int: ...
    @overload
    def getDepthSensorParam(self, param: mrpt.pymrpt.mrpt.img.TCamera) -> bool: ...
    @overload
    def getDepthSensorParam(self, param: mrpt.pymrpt.mrpt.img.TCamera, sensor_id: int) -> bool: ...
    @overload
    def getDepthSensorParam(classmrpt, unsignedint) -> bool: ...
    def getDeviceIDFromSerialNum(self, SerialRequired: int, sensor_id: int) -> bool: ...
    @overload
    def getNextFrameD(self, depth_img_mm: mrpt.pymrpt.mrpt.math.CMatrixDynamic_unsigned_short_t, timestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, there_is_obs: bool, hardware_error: bool) -> None: ...
    @overload
    def getNextFrameD(self, depth_img_mm: mrpt.pymrpt.mrpt.math.CMatrixDynamic_unsigned_short_t, timestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, there_is_obs: bool, hardware_error: bool, sensor_id: int) -> None: ...
    @overload
    def getNextFrameRGB(self, rgb_img: mrpt.pymrpt.mrpt.img.CImage, timestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, there_is_obs: bool, hardware_error: bool) -> None: ...
    @overload
    def getNextFrameRGB(self, rgb_img: mrpt.pymrpt.mrpt.img.CImage, timestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, there_is_obs: bool, hardware_error: bool, sensor_id: int) -> None: ...
    @overload
    def getNextFrameRGBD(self, out_obs: mrpt.pymrpt.mrpt.obs.CObservation3DRangeScan, there_is_obs: bool, hardware_error: bool) -> None: ...
    @overload
    def getNextFrameRGBD(self, out_obs: mrpt.pymrpt.mrpt.obs.CObservation3DRangeScan, there_is_obs: bool, hardware_error: bool, sensor_id: int) -> None: ...
    @overload
    def getNumDevices(self) -> int: ...
    @overload
    def getNumDevices() -> int: ...
    def getNumInstances(self, *args, **kwargs) -> Any: ...
    @overload
    def isOpen(self, sensor_id: int) -> bool: ...
    @overload
    def isOpen(constunsignedint) -> bool: ...
    @overload
    def isVerbose(self) -> bool: ...
    @overload
    def isVerbose() -> bool: ...
    @overload
    def kill(self) -> None: ...
    @overload
    def kill() -> void: ...
    @overload
    def open(self) -> None: ...
    @overload
    def open(self, sensor_id: int) -> None: ...
    @overload
    def openDeviceBySerial(self, SerialRequired: int) -> int: ...
    @overload
    def openDeviceBySerial(constunsignedint) -> unsignedint: ...
    @overload
    def setVerbose(self, verbose: bool) -> None: ...
    @overload
    def setVerbose(bool) -> void: ...
    @overload
    def start(self) -> bool: ...
    @overload
    def start() -> bool: ...

class COpenNI2Sensor(CGenericSensor, COpenNI2Generic):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> size_t: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def enableGrab3DPoints(self) -> None: ...
    @overload
    def enableGrab3DPoints(self, enable: bool) -> None: ...
    @overload
    def enableGrab3DPoints(bool) -> void: ...
    @overload
    def enableGrabDepth(self) -> None: ...
    @overload
    def enableGrabDepth(self, enable: bool) -> None: ...
    @overload
    def enableGrabDepth(bool) -> void: ...
    @overload
    def enableGrabRGB(self) -> None: ...
    @overload
    def enableGrabRGB(self, enable: bool) -> None: ...
    @overload
    def enableGrabRGB(bool) -> void: ...
    def getCameraParamsDepth(self) -> mrpt.pymrpt.mrpt.img.TCamera: ...
    def getCameraParamsIntensity(self) -> mrpt.pymrpt.mrpt.img.TCamera: ...
    @overload
    def getMaxRange(self) -> float: ...
    @overload
    def getMaxRange() -> double: ...
    def getNextObservation(self, out_obs: mrpt.pymrpt.mrpt.obs.CObservation3DRangeScan, there_is_obs: bool, hardware_error: bool) -> None: ...
    def getRelativePoseIntensityWrtDepth(self) -> mrpt.pymrpt.mrpt.poses.CPose3D: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    @overload
    def isGrab3DPointsEnabled(self) -> bool: ...
    @overload
    def isGrab3DPointsEnabled() -> bool: ...
    @overload
    def isGrabDepthEnabled(self) -> bool: ...
    @overload
    def isGrabDepthEnabled() -> bool: ...
    @overload
    def isGrabRGBEnabled(self) -> bool: ...
    @overload
    def isGrabRGBEnabled() -> bool: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> size_t: ...
    @overload
    def setCameraParamsDepth(self, p: mrpt.pymrpt.mrpt.img.TCamera) -> None: ...
    @overload
    def setCameraParamsDepth(constclassmrpt) -> void: ...
    @overload
    def setCameraParamsIntensity(self, p: mrpt.pymrpt.mrpt.img.TCamera) -> None: ...
    @overload
    def setCameraParamsIntensity(constclassmrpt) -> void: ...
    def setPathForExternalImages(self, *args, **kwargs) -> Any: ...
    @overload
    def setRelativePoseIntensityWrtDepth(self, p: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setRelativePoseIntensityWrtDepth(constclassmrpt) -> void: ...
    @overload
    def setSensorIDToOpen(self, sensor_id: int) -> None: ...
    @overload
    def setSensorIDToOpen(constunsignedint) -> void: ...
    @overload
    def setSerialToOpen(self, serial: int) -> None: ...
    @overload
    def setSerialToOpen(constunsignedint) -> void: ...

class COpenNI2_RGBD360(CGenericSensor, COpenNI2Generic):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def enableGrab3DPoints(self) -> None: ...
    @overload
    def enableGrab3DPoints(self, enable: bool) -> None: ...
    @overload
    def enableGrab3DPoints(bool) -> void: ...
    @overload
    def enableGrabDepth(self) -> None: ...
    @overload
    def enableGrabDepth(self, enable: bool) -> None: ...
    @overload
    def enableGrabDepth(bool) -> void: ...
    @overload
    def enableGrabRGB(self) -> None: ...
    @overload
    def enableGrabRGB(self, enable: bool) -> None: ...
    @overload
    def enableGrabRGB(bool) -> void: ...
    @overload
    def getMaxRange(self) -> float: ...
    @overload
    def getMaxRange() -> double: ...
    def getNextObservation(self, out_obs: mrpt.pymrpt.mrpt.obs.CObservationRGBD360, there_is_obs: bool, hardware_error: bool) -> None: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    @overload
    def isGrab3DPointsEnabled(self) -> bool: ...
    @overload
    def isGrab3DPointsEnabled() -> bool: ...
    @overload
    def isGrabDepthEnabled(self) -> bool: ...
    @overload
    def isGrabDepthEnabled() -> bool: ...
    @overload
    def isGrabRGBEnabled(self) -> bool: ...
    @overload
    def isGrabRGBEnabled() -> bool: ...
    def setPathForExternalImages(self, *args, **kwargs) -> Any: ...

class CPhidgetInterfaceKitProximitySensors(CGenericSensor):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def getObservation(self, outObservation: mrpt.pymrpt.mrpt.obs.CObservationRange) -> None: ...
    @overload
    def getObservation(classmrpt) -> void: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...

class CPtuBase:
    panResolution: float
    tiltResolution: float
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def aWait(self) -> bool: ...
    @overload
    def aWait() -> bool: ...
    def absPosQ(self, axis: str, nRad: float) -> bool: ...
    @overload
    def aceleration(self, axis: str, RadSec2: float) -> bool: ...
    @overload
    def aceleration(char, double) -> bool: ...
    def acelerationQ(self, axis: str, RadSec2: float) -> bool: ...
    def assign(self) -> CPtuBase: ...
    @overload
    def baseSpeed(self, axis: str, RadSec: float) -> bool: ...
    @overload
    def baseSpeed(char, double) -> bool: ...
    def baseSpeedQ(self, axis: str, RadSec: float) -> bool: ...
    @overload
    def changeMotionDir(self) -> bool: ...
    @overload
    def changeMotionDir() -> bool: ...
    @overload
    def checkErrors(self) -> int: ...
    @overload
    def checkErrors() -> int: ...
    @overload
    def clearErrors(self) -> None: ...
    @overload
    def clearErrors() -> void: ...
    @overload
    def close(self) -> None: ...
    @overload
    def close() -> void: ...
    @overload
    def echoMode(self, mode: bool) -> bool: ...
    @overload
    def echoMode(bool) -> bool: ...
    def echoModeQ(self, mode: bool) -> bool: ...
    @overload
    def enableLimits(self, set: bool) -> bool: ...
    @overload
    def enableLimits(bool) -> bool: ...
    def enableLimitsQ(self, enable: bool) -> bool: ...
    @overload
    def halt(self, axis: str) -> bool: ...
    @overload
    def halt(char) -> bool: ...
    @overload
    def haltAll(self) -> bool: ...
    @overload
    def haltAll() -> bool: ...
    @overload
    def init(self, port: str) -> bool: ...
    @overload
    def init(conststd) -> bool: ...
    @overload
    def inmediateExecution(self, set: bool) -> bool: ...
    @overload
    def inmediateExecution(bool) -> bool: ...
    @overload
    def lowerSpeed(self, axis: str, RadSec: float) -> bool: ...
    @overload
    def lowerSpeed(char, double) -> bool: ...
    def lowerSpeedQ(self, axis: str, RadSec: float) -> bool: ...
    def maxPosQ(self, axis: str, nRad: float) -> bool: ...
    def minPosQ(self, axis: str, nRad: float) -> bool: ...
    @overload
    def moveToAbsPos(self, axis: str, nRad: float) -> bool: ...
    @overload
    def moveToAbsPos(char, double) -> bool: ...
    @overload
    def moveToOffPos(self, axis: str, nRad: float) -> bool: ...
    @overload
    def moveToOffPos(char, double) -> bool: ...
    def nversion(self, nVersion: float) -> None: ...
    def offPosQ(self, axis: str, nRad: float) -> bool: ...
    @overload
    def posToRad(self, axis: str, nPos: int) -> float: ...
    @overload
    def posToRad(char, long) -> double: ...
    @overload
    def powerMode(self, transit: bool, mode: str) -> bool: ...
    @overload
    def powerMode(bool, char) -> bool: ...
    def powerModeQ(self, transit: bool, mode: str) -> bool: ...
    @overload
    def radError(self, axis: str, nRadMoved: float) -> float: ...
    @overload
    def radError(char, double) -> double: ...
    @overload
    def radToPos(self, axis: str, nRad: float) -> int: ...
    @overload
    def radToPos(char, double) -> long: ...
    @overload
    def rangeMeasure(self) -> bool: ...
    @overload
    def rangeMeasure() -> bool: ...
    @overload
    def reset(self) -> bool: ...
    @overload
    def reset() -> bool: ...
    @overload
    def resolution(self) -> bool: ...
    @overload
    def resolution() -> bool: ...
    @overload
    def restoreDefaults(self) -> bool: ...
    @overload
    def restoreDefaults() -> bool: ...
    @overload
    def restoreFactoryDefaults(self) -> bool: ...
    @overload
    def restoreFactoryDefaults() -> bool: ...
    @overload
    def save(self) -> bool: ...
    @overload
    def save() -> bool: ...
    def scan(self, axis: str, wait: int, initial: float, final: float, RadPre: float) -> bool: ...
    def setLimits(self, axis: str, l: float, u: float) -> bool: ...
    @overload
    def speed(self, axis: str, RadSec: float) -> bool: ...
    @overload
    def speed(char, double) -> bool: ...
    def speedQ(self, axis: str, RadSec: float) -> bool: ...
    def status(self, rad: float) -> float: ...
    @overload
    def upperSpeed(self, axis: str, RadSec: float) -> bool: ...
    @overload
    def upperSpeed(char, double) -> bool: ...
    def upperSpeedQ(self, axis: str, RadSec: float) -> bool: ...
    @overload
    def verbose(self, set: bool) -> bool: ...
    @overload
    def verbose(bool) -> bool: ...
    def verboseQ(self, modo: bool) -> bool: ...
    def version(self, nVersion: str) -> bool: ...

class CPtuDPerception(CPtuBase):
    nError: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CPtuDPerception) -> None: ...
    @overload
    def __init__(self, arg0: CPtuDPerception) -> None: ...
    @overload
    def aWait(self) -> bool: ...
    @overload
    def aWait() -> bool: ...
    def absPosQ(self, axis: str, nRad: float) -> bool: ...
    @overload
    def aceleration(self, axis: str, radSec2: float) -> bool: ...
    @overload
    def aceleration(char, double) -> bool: ...
    def acelerationQ(self, axis: str, radSec2: float) -> bool: ...
    def assign(self) -> CPtuDPerception: ...
    @overload
    def baseSpeed(self, axis: str, radSec: float) -> bool: ...
    @overload
    def baseSpeed(char, double) -> bool: ...
    def baseSpeedQ(self, axis: str, radSec: float) -> bool: ...
    @overload
    def changeMotionDir(self) -> bool: ...
    @overload
    def changeMotionDir() -> bool: ...
    @overload
    def checkErrors(self) -> int: ...
    @overload
    def checkErrors() -> int: ...
    @overload
    def clearErrors(self) -> None: ...
    @overload
    def clearErrors() -> void: ...
    @overload
    def close(self) -> None: ...
    @overload
    def close() -> void: ...
    @overload
    def comError(self) -> bool: ...
    @overload
    def comError() -> bool: ...
    @overload
    def echoMode(self, mode: bool) -> bool: ...
    @overload
    def echoMode(bool) -> bool: ...
    def echoModeQ(self, mode: bool) -> bool: ...
    @overload
    def enableLimits(self, set: bool) -> bool: ...
    @overload
    def enableLimits(bool) -> bool: ...
    def enableLimitsQ(self, enable: bool) -> bool: ...
    @overload
    def halt(self, axis: str) -> bool: ...
    @overload
    def halt(char) -> bool: ...
    @overload
    def haltAll(self) -> bool: ...
    @overload
    def haltAll() -> bool: ...
    @overload
    def illegalCommandError(self) -> bool: ...
    @overload
    def illegalCommandError() -> bool: ...
    @overload
    def init(self, port: str) -> bool: ...
    @overload
    def init(conststd) -> bool: ...
    @overload
    def initError(self) -> bool: ...
    @overload
    def initError() -> bool: ...
    @overload
    def inmediateExecution(self, set: bool) -> bool: ...
    @overload
    def inmediateExecution(bool) -> bool: ...
    @overload
    def lowerSpeed(self, axis: str, radSec: float) -> bool: ...
    @overload
    def lowerSpeed(char, double) -> bool: ...
    def lowerSpeedQ(self, axis: str, radSec: float) -> bool: ...
    @overload
    def maxLimitError(self) -> bool: ...
    @overload
    def maxLimitError() -> bool: ...
    def maxPosQ(self, axis: str, nRad: float) -> bool: ...
    @overload
    def minLimitError(self) -> bool: ...
    @overload
    def minLimitError() -> bool: ...
    def minPosQ(self, axis: str, nRad: float) -> bool: ...
    @overload
    def moveToAbsPos(self, axis: str, nRad: float) -> bool: ...
    @overload
    def moveToAbsPos(char, double) -> bool: ...
    @overload
    def moveToOffPos(self, axis: str, nRad: float) -> bool: ...
    @overload
    def moveToOffPos(char, double) -> bool: ...
    @overload
    def noError(self) -> bool: ...
    @overload
    def noError() -> bool: ...
    def nversion(self, nVersion: float) -> None: ...
    def offPosQ(self, axis: str, nRad: float) -> bool: ...
    @overload
    def outOfRange(self) -> bool: ...
    @overload
    def outOfRange() -> bool: ...
    @overload
    def panHitError(self) -> bool: ...
    @overload
    def panHitError() -> bool: ...
    @overload
    def panTiltHitError(self) -> bool: ...
    @overload
    def panTiltHitError() -> bool: ...
    @overload
    def posToRad(self, axis: str, nPos: int) -> float: ...
    @overload
    def posToRad(char, long) -> double: ...
    @overload
    def powerMode(self, transit: bool, mode: str) -> bool: ...
    @overload
    def powerMode(bool, char) -> bool: ...
    def powerModeQ(self, transit: bool, mode: str) -> bool: ...
    @overload
    def radError(self, axis: str, nRadMoved: float) -> float: ...
    @overload
    def radError(char, double) -> double: ...
    @overload
    def radToPos(self, axis: str, nRad: float) -> int: ...
    @overload
    def radToPos(char, double) -> long: ...
    @overload
    def rangeMeasure(self) -> bool: ...
    @overload
    def rangeMeasure() -> bool: ...
    @overload
    def reset(self) -> bool: ...
    @overload
    def reset() -> bool: ...
    @overload
    def resolution(self) -> bool: ...
    @overload
    def resolution() -> bool: ...
    @overload
    def restoreDefaults(self) -> bool: ...
    @overload
    def restoreDefaults() -> bool: ...
    @overload
    def restoreFactoryDefaults(self) -> bool: ...
    @overload
    def restoreFactoryDefaults() -> bool: ...
    @overload
    def save(self) -> bool: ...
    @overload
    def save() -> bool: ...
    def scan(self, axis: str, wait: int, initial: float, final: float, radPre: float) -> bool: ...
    def setLimits(self, axis: str, l: float, u: float) -> bool: ...
    @overload
    def speed(self, axis: str, radSec: float) -> bool: ...
    @overload
    def speed(char, double) -> bool: ...
    def speedQ(self, axis: str, radSec: float) -> bool: ...
    def status(self, rad: float) -> float: ...
    @overload
    def tiltHitError(self) -> bool: ...
    @overload
    def tiltHitError() -> bool: ...
    @overload
    def timeoutError(self) -> bool: ...
    @overload
    def timeoutError() -> bool: ...
    @overload
    def unExpectedError(self) -> bool: ...
    @overload
    def unExpectedError() -> bool: ...
    @overload
    def upperSpeed(self, axis: str, radSec: float) -> bool: ...
    @overload
    def upperSpeed(char, double) -> bool: ...
    def upperSpeedQ(self, axis: str, radSec: float) -> bool: ...
    @overload
    def verbose(self, set: bool) -> bool: ...
    @overload
    def verbose(bool) -> bool: ...
    def verboseQ(self, modo: bool) -> bool: ...
    def version(self, nVersion: str) -> bool: ...

class CRaePID(CGenericSensor):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def errorStatus(self, errorString: str) -> bool: ...
    @overload
    def errorStatus(std) -> bool: ...
    def getFirmware(self) -> str: ...
    def getFullInfo(self) -> mrpt.pymrpt.mrpt.obs.CObservationGasSensors: ...
    def getLimits(self, min: float, max: float) -> None: ...
    def getModel(self) -> str: ...
    def getName(self) -> str: ...
    def getSerialNumber(self) -> str: ...
    @overload
    def loadConfig_sensorSpecific(self, configSource: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
    @overload
    def loadConfig_sensorSpecific(constclassmrpt, conststd) -> void: ...
    @overload
    def switchPower(self) -> bool: ...
    @overload
    def switchPower() -> bool: ...

class CRoboPeakLidar(C2DRangeFinderAbstract):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def disconnect(self) -> None: ...
    @overload
    def disconnect() -> void: ...
    def doProcessSimple(self, outThereIsObservation: bool, outObservation: mrpt.pymrpt.mrpt.obs.CObservation2DRangeScan, hardwareError: bool) -> None: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def getDeviceHealth(self) -> bool: ...
    @overload
    def getDeviceHealth() -> bool: ...
    def getSerialPort(self) -> str: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    @overload
    def setSerialPort(self, port_name: str) -> None: ...
    @overload
    def setSerialPort(conststd) -> void: ...
    @overload
    def turnOff(self) -> bool: ...
    @overload
    def turnOff() -> bool: ...
    @overload
    def turnOn(self) -> bool: ...
    @overload
    def turnOn() -> bool: ...

class CSICKTim561Eth(C2DRangeFinderAbstract):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: str) -> None: ...
    @overload
    def __init__(self, _ip: str, _port: int) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doProcessSimple(self, outThereIsObservation: bool, outObservation: mrpt.pymrpt.mrpt.obs.CObservation2DRangeScan, hardwareError: bool) -> None: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    @overload
    def rebootDev(self) -> bool: ...
    @overload
    def rebootDev() -> bool: ...
    @overload
    def setSensorPose(self, _pose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...
    @overload
    def turnOff(self) -> bool: ...
    @overload
    def turnOff() -> bool: ...
    @overload
    def turnOn(self) -> bool: ...
    @overload
    def turnOn() -> bool: ...

class CSickLaserSerial(C2DRangeFinderAbstract):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    def doProcessSimple(self, outThereIsObservation: bool, outObservation: mrpt.pymrpt.mrpt.obs.CObservation2DRangeScan, hardwareError: bool) -> None: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def getBaudRate(self) -> int: ...
    @overload
    def getBaudRate() -> int: ...
    @overload
    def getCurrentConnectTry(self) -> int: ...
    @overload
    def getCurrentConnectTry() -> unsignedint: ...
    @overload
    def getScanFOV(self) -> int: ...
    @overload
    def getScanFOV() -> int: ...
    @overload
    def getScanResolution(self) -> int: ...
    @overload
    def getScanResolution() -> int: ...
    def getSerialPort(self) -> str: ...
    def initialize(self, *args, **kwargs) -> Any: ...
    @overload
    def setBaudRate(self, baud: int) -> None: ...
    @overload
    def setBaudRate(int) -> void: ...
    @overload
    def setMillimeterMode(self) -> None: ...
    @overload
    def setMillimeterMode(self, mm_mode: bool) -> None: ...
    @overload
    def setMillimeterMode(bool) -> void: ...
    @overload
    def setScanFOV(self, fov_degrees: int) -> None: ...
    @overload
    def setScanFOV(int) -> void: ...
    @overload
    def setScanResolution(self, res_1_100th_degree: int) -> None: ...
    @overload
    def setScanResolution(int) -> void: ...
    @overload
    def setSerialPort(self, port: str) -> None: ...
    @overload
    def setSerialPort(conststd) -> void: ...
    @overload
    def turnOff(self) -> bool: ...
    @overload
    def turnOff() -> bool: ...
    @overload
    def turnOn(self) -> bool: ...
    @overload
    def turnOn() -> bool: ...

class CSickLaserUSB(C2DRangeFinderAbstract):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    def doProcessSimple(self, outThereIsObservation: bool, outObservation: mrpt.pymrpt.mrpt.obs.CObservation2DRangeScan, hardwareError: bool) -> None: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def setDeviceSerialNumber(self, deviceSerialNumber: str) -> None: ...
    @overload
    def setDeviceSerialNumber(conststd) -> void: ...
    @overload
    def turnOff(self) -> bool: ...
    @overload
    def turnOff() -> bool: ...
    @overload
    def turnOn(self) -> bool: ...
    @overload
    def turnOn() -> bool: ...

class CSkeletonTracker(CGenericSensor):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    @overload
    def setPreview(self) -> None: ...
    @overload
    def setPreview(self, setPreview: bool) -> None: ...
    @overload
    def setPreview(constbool) -> void: ...

class CStereoGrabber_Bumblebee_libdc1394:
    def __init__(self, cameraGUID: int, cameraUnit: int, frameRate: float) -> None: ...
    @overload
    def getStereoObservation(self, out_observation: mrpt.pymrpt.mrpt.obs.CObservationStereoImages) -> bool: ...
    @overload
    def getStereoObservation(classmrpt) -> bool: ...

class CStereoGrabber_SVS:
    m_options: TCaptureOptions_SVS
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, cameraIndex: int) -> None: ...
    @overload
    def __init__(self, cameraIndex: int, options: TCaptureOptions_SVS) -> None: ...
    @overload
    def getStereoObservation(self, out_observation: mrpt.pymrpt.mrpt.obs.CObservationStereoImages) -> bool: ...
    @overload
    def getStereoObservation(classmrpt) -> bool: ...

class CSwissRanger3DCamera(CGenericSensor):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def close(self) -> None: ...
    @overload
    def close() -> void: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> size_t: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def enableConvGray(self, enable: bool) -> None: ...
    @overload
    def enableConvGray(bool) -> void: ...
    @overload
    def enableDenoiseANF(self, enable: bool) -> None: ...
    @overload
    def enableDenoiseANF(bool) -> void: ...
    @overload
    def enableImageHistEqualization(self, enable: bool) -> None: ...
    @overload
    def enableImageHistEqualization(bool) -> void: ...
    @overload
    def enableMedianCrossFilter(self, enable: bool) -> None: ...
    @overload
    def enableMedianCrossFilter(bool) -> void: ...
    @overload
    def enableMedianFilter(self, enable: bool) -> None: ...
    @overload
    def enableMedianFilter(bool) -> void: ...
    @overload
    def enablePreviewWindow(self) -> None: ...
    @overload
    def enablePreviewWindow(self, enable: bool) -> None: ...
    @overload
    def enablePreviewWindow(bool) -> void: ...
    @overload
    def getCameraSerialNumber(self) -> int: ...
    @overload
    def getCameraSerialNumber() -> unsignedint: ...
    @overload
    def getMaxRange(self) -> float: ...
    @overload
    def getMaxRange() -> double: ...
    @overload
    def getMesaLibVersion(self, out_version: str) -> bool: ...
    @overload
    def getMesaLibVersion(std) -> bool: ...
    def getNextObservation(self, out_obs: mrpt.pymrpt.mrpt.obs.CObservation3DRangeScan, there_is_obs: bool, hardware_error: bool) -> None: ...
    @overload
    def getOpenFromUSBMode(self) -> bool: ...
    @overload
    def getOpenFromUSBMode() -> bool: ...
    def getOpenIPAddress(self) -> str: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    @overload
    def isEnabledConvGray(self) -> bool: ...
    @overload
    def isEnabledConvGray() -> bool: ...
    @overload
    def isEnabledDenoiseANF(self) -> bool: ...
    @overload
    def isEnabledDenoiseANF() -> bool: ...
    @overload
    def isEnabledImageHistEqualization(self) -> bool: ...
    @overload
    def isEnabledImageHistEqualization() -> bool: ...
    @overload
    def isEnabledMedianCrossFilter(self) -> bool: ...
    @overload
    def isEnabledMedianCrossFilter() -> bool: ...
    @overload
    def isEnabledMedianFilter(self) -> bool: ...
    @overload
    def isEnabledMedianFilter() -> bool: ...
    @overload
    def isEnabledPreviewWindow(self) -> bool: ...
    @overload
    def isEnabledPreviewWindow() -> bool: ...
    @overload
    def isOpen(self) -> bool: ...
    @overload
    def isOpen() -> bool: ...
    @overload
    def open(self) -> bool: ...
    @overload
    def open() -> bool: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> size_t: ...
    @overload
    def setOpenFromUSB(self, USB: bool) -> None: ...
    @overload
    def setOpenFromUSB(bool) -> void: ...
    @overload
    def setOpenIPAddress(self, IP: str) -> None: ...
    @overload
    def setOpenIPAddress(conststd) -> void: ...
    def setPathForExternalImages(self, *args, **kwargs) -> Any: ...
    @overload
    def setSave3D(self, save: bool) -> None: ...
    @overload
    def setSave3D(bool) -> void: ...
    @overload
    def setSaveConfidenceImage(self, save: bool) -> None: ...
    @overload
    def setSaveConfidenceImage(bool) -> void: ...
    @overload
    def setSaveIntensityImage(self, save: bool) -> None: ...
    @overload
    def setSaveIntensityImage(bool) -> void: ...
    @overload
    def setSaveRangeImage(self, save: bool) -> None: ...
    @overload
    def setSaveRangeImage(bool) -> void: ...

class CTaoboticsIMU(CGenericSensor):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    @overload
    def loadConfig_sensorSpecific(self, configSource: mrpt.pymrpt.mrpt.config.CConfigFileBase, iniSection: str) -> None: ...
    @overload
    def loadConfig_sensorSpecific(constclassmrpt, conststd) -> void: ...
    @overload
    def setSerialBaudRate(self, rate: int) -> None: ...
    @overload
    def setSerialBaudRate(int) -> void: ...
    @overload
    def setSerialPort(self, serialPort: str) -> None: ...
    @overload
    def setSerialPort(conststd) -> void: ...

class CTuMicos(CPtuBase):
    axis_index: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CTuMicos) -> None: ...
    @overload
    def __init__(self, arg0: CTuMicos) -> None: ...
    @overload
    def aWait(self) -> bool: ...
    @overload
    def aWait() -> bool: ...
    def absPosQ(self, axis: str, nRad: float) -> bool: ...
    @overload
    def aceleration(self, axis: str, radSec2: float) -> bool: ...
    @overload
    def aceleration(char, double) -> bool: ...
    def acelerationQ(self, axis: str, radSec2: float) -> bool: ...
    def assign(self) -> CTuMicos: ...
    @overload
    def baseSpeed(self, axis: str, radSec: float) -> bool: ...
    @overload
    def baseSpeed(char, double) -> bool: ...
    def baseSpeedQ(self, axis: str, radSec: float) -> bool: ...
    @overload
    def changeMotionDir(self) -> bool: ...
    @overload
    def changeMotionDir() -> bool: ...
    @overload
    def checkErrors(self) -> int: ...
    @overload
    def checkErrors() -> int: ...
    @overload
    def clear(self) -> bool: ...
    @overload
    def clear() -> bool: ...
    @overload
    def clearErrors(self) -> None: ...
    @overload
    def clearErrors() -> void: ...
    @overload
    def close(self) -> None: ...
    @overload
    def close() -> void: ...
    @overload
    def echoMode(self, mode: bool) -> bool: ...
    @overload
    def echoMode(bool) -> bool: ...
    def echoModeQ(self, mode: bool) -> bool: ...
    @overload
    def enableLimits(self, set: bool) -> bool: ...
    @overload
    def enableLimits(bool) -> bool: ...
    def enableLimitsQ(self, enable: bool) -> bool: ...
    @overload
    def halt(self, axis: str) -> bool: ...
    @overload
    def halt(char) -> bool: ...
    @overload
    def haltAll(self) -> bool: ...
    @overload
    def haltAll() -> bool: ...
    @overload
    def init(self, port: str) -> bool: ...
    @overload
    def init(conststd) -> bool: ...
    @overload
    def inmediateExecution(self, set: bool) -> bool: ...
    @overload
    def inmediateExecution(bool) -> bool: ...
    @overload
    def lowerSpeed(self, axis: str, radSec: float) -> bool: ...
    @overload
    def lowerSpeed(char, double) -> bool: ...
    def lowerSpeedQ(self, axis: str, radSec: float) -> bool: ...
    def maxPosQ(self, axis: str, nRad: float) -> bool: ...
    def minPosQ(self, axis: str, nRad: float) -> bool: ...
    @overload
    def moveToAbsPos(self, axis: str, nRad: float) -> bool: ...
    @overload
    def moveToAbsPos(char, double) -> bool: ...
    @overload
    def moveToOffPos(self, axis: str, nRad: float) -> bool: ...
    @overload
    def moveToOffPos(char, double) -> bool: ...
    def nversion(self, nVersion: float) -> None: ...
    def offPosQ(self, axis: str, nRad: float) -> bool: ...
    @overload
    def posToRad(self, axis: str, nPos: int) -> float: ...
    @overload
    def posToRad(char, long) -> double: ...
    @overload
    def powerMode(self, transit: bool, mode: str) -> bool: ...
    @overload
    def powerMode(bool, char) -> bool: ...
    def powerModeQ(self, transit: bool, mode: str) -> bool: ...
    @overload
    def radError(self, axis: str, nRadMoved: float) -> float: ...
    @overload
    def radError(char, double) -> double: ...
    @overload
    def radToPos(self, axis: str, nRad: float) -> int: ...
    @overload
    def radToPos(char, double) -> long: ...
    @overload
    def rangeMeasure(self) -> bool: ...
    @overload
    def rangeMeasure() -> bool: ...
    @overload
    def reset(self) -> bool: ...
    @overload
    def reset() -> bool: ...
    @overload
    def resolution(self) -> bool: ...
    @overload
    def resolution() -> bool: ...
    @overload
    def restoreDefaults(self) -> bool: ...
    @overload
    def restoreDefaults() -> bool: ...
    @overload
    def restoreFactoryDefaults(self) -> bool: ...
    @overload
    def restoreFactoryDefaults() -> bool: ...
    @overload
    def save(self) -> bool: ...
    @overload
    def save() -> bool: ...
    def scan(self, axis: str, wait: int, initial: float, final: float, radPre: float) -> bool: ...
    def setLimits(self, axis: str, l: float, u: float) -> bool: ...
    @overload
    def speed(self, axis: str, radSec: float) -> bool: ...
    @overload
    def speed(char, double) -> bool: ...
    def speedQ(self, axis: str, radSec: float) -> bool: ...
    def status(self, rad: float) -> float: ...
    @overload
    def upperSpeed(self, axis: str, radSec: float) -> bool: ...
    @overload
    def upperSpeed(char, double) -> bool: ...
    def upperSpeedQ(self, axis: str, radSec: float) -> bool: ...
    @overload
    def verbose(self, set: bool) -> bool: ...
    @overload
    def verbose(bool) -> bool: ...
    def verboseQ(self, modo: bool) -> bool: ...
    def version(self, nVersion: str) -> bool: ...

class CVelodyneScanner(CGenericSensor):
    class TModelProperties:
        maxRange: float
        def __init__(self) -> None: ...

    class TModelPropertiesFactory:
        def __init__(self) -> None: ...
        def getListKnownModels(self, *args, **kwargs) -> Any: ...

    class model_t:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        HDL32: ClassVar[CVelodyneScanner.model_t] = ...
        HDL64: ClassVar[CVelodyneScanner.model_t] = ...
        VLP16: ClassVar[CVelodyneScanner.model_t] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class return_type_t:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        DUAL: ClassVar[CVelodyneScanner.return_type_t] = ...
        LAST: ClassVar[CVelodyneScanner.return_type_t] = ...
        STRONGEST: ClassVar[CVelodyneScanner.return_type_t] = ...
        UNCHANGED: ClassVar[CVelodyneScanner.return_type_t] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    DUAL: ClassVar[CVelodyneScanner.return_type_t] = ...
    HDL32: ClassVar[CVelodyneScanner.model_t] = ...
    HDL64: ClassVar[CVelodyneScanner.model_t] = ...
    LAST: ClassVar[CVelodyneScanner.return_type_t] = ...
    STRONGEST: ClassVar[CVelodyneScanner.return_type_t] = ...
    UNCHANGED: ClassVar[CVelodyneScanner.return_type_t] = ...
    VLP16: ClassVar[CVelodyneScanner.model_t] = ...
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    @overload
    def close(self) -> None: ...
    @overload
    def close() -> void: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    def getCalibration(self) -> mrpt.pymrpt.mrpt.obs.VelodyneCalibration: ...
    def getDeviceIP(self) -> str: ...
    def getModelName(self) -> CVelodyneScanner.model_t: ...
    def getNextObservation(self, outScan: mrpt.pymrpt.mrpt.obs.CObservationVelodyneScan, outGPS: mrpt.pymrpt.mrpt.obs.CObservationGPS) -> bool: ...
    def getPCAPInputFile(self) -> str: ...
    @overload
    def getPCAPInputFileReadOnce(self) -> bool: ...
    @overload
    def getPCAPInputFileReadOnce() -> bool: ...
    def getPCAPOutputFile(self) -> str: ...
    @overload
    def getPosPacketsMinPeriod(self) -> float: ...
    @overload
    def getPosPacketsMinPeriod() -> double: ...
    @overload
    def getPosPacketsTimingTimeout(self) -> float: ...
    @overload
    def getPosPacketsTimingTimeout() -> double: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    @overload
    def loadCalibrationFile(self, velodyne_xml_calib_file_path: str) -> bool: ...
    @overload
    def loadCalibrationFile(conststd) -> bool: ...
    def receivePackets(self, data_pkt_timestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, out_data_pkt: mrpt.pymrpt.mrpt.obs.CObservationVelodyneScan.TVelodyneRawPacket, pos_pkt_timestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, out_pos_pkt: mrpt.pymrpt.mrpt.obs.CObservationVelodyneScan.TVelodynePositionPacket) -> bool: ...
    @overload
    def setCalibration(self, calib: mrpt.pymrpt.mrpt.obs.VelodyneCalibration) -> None: ...
    @overload
    def setCalibration(conststructmrpt) -> void: ...
    @overload
    def setDeviceIP(self, ip: str) -> None: ...
    @overload
    def setDeviceIP(conststd) -> void: ...
    @overload
    def setFramePublishing(self, on: bool) -> None: ...
    @overload
    def setFramePublishing(bool) -> void: ...
    @overload
    def setLidarOnOff(self, on: bool) -> bool: ...
    @overload
    def setLidarOnOff(bool) -> bool: ...
    @overload
    def setLidarRPM(self, rpm: int) -> bool: ...
    @overload
    def setLidarRPM(int) -> bool: ...
    @overload
    def setLidarReturnType(self, ret_type: CVelodyneScanner.return_type_t) -> bool: ...
    @overload
    def setLidarReturnType(enummrpt) -> bool: ...
    def setModelName(self, model: CVelodyneScanner.model_t) -> None: ...
    @overload
    def setPCAPInputFile(self, pcap_file: str) -> None: ...
    @overload
    def setPCAPInputFile(conststd) -> void: ...
    @overload
    def setPCAPInputFileReadOnce(self, read_once: bool) -> None: ...
    @overload
    def setPCAPInputFileReadOnce(bool) -> void: ...
    @overload
    def setPCAPOutputFile(self, out_pcap_file: str) -> None: ...
    @overload
    def setPCAPOutputFile(conststd) -> void: ...
    @overload
    def setPCAPVerbosity(self, verbose: bool) -> None: ...
    @overload
    def setPCAPVerbosity(constbool) -> void: ...
    @overload
    def setPosPacketsMinPeriod(self, period_seconds: float) -> None: ...
    @overload
    def setPosPacketsMinPeriod(double) -> void: ...
    @overload
    def setPosPacketsTimingTimeout(self, timeout: float) -> None: ...
    @overload
    def setPosPacketsTimingTimeout(double) -> void: ...

class CWirelessPower(CGenericSensor):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    @overload
    def GetPower(self) -> int: ...
    @overload
    def GetPower() -> int: ...
    def GetRuntimeClass(self) -> TSensorClassId: ...
    def ListInterfaces(self) -> List[str]: ...
    def ListNetworks(self) -> List[str]: ...
    @overload
    def doProcess(self) -> None: ...
    @overload
    def doProcess() -> void: ...
    def doRegister(self, *args, **kwargs) -> Any: ...
    @overload
    def getObservation(self, outObservation: mrpt.pymrpt.mrpt.obs.CObservationWirelessPower) -> bool: ...
    @overload
    def getObservation(classmrpt) -> bool: ...
    @overload
    def loadConfig_sensorSpecific(self, configSource: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
    @overload
    def loadConfig_sensorSpecific(constclassmrpt, conststd) -> void: ...
    def setNet(self, ssid: str, guid: str) -> None: ...

class GYRO_MODE:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    INCREMENTAL_ANGLE: ClassVar[GYRO_MODE] = ...
    INTEGRATED_ANGLE: ClassVar[GYRO_MODE] = ...
    RATE: ClassVar[GYRO_MODE] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SensorType:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    EZ1: ClassVar[SensorType] = ...
    SHARP_30cm: ClassVar[SensorType] = ...
    SHARP_80cm: ClassVar[SensorType] = ...
    UNPLUGGED: ClassVar[SensorType] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TCameraType:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    CAMERA_CV_AUTODETECT: ClassVar[TCameraType] = ...
    CAMERA_CV_DC1394: ClassVar[TCameraType] = ...
    CAMERA_CV_DSHOW: ClassVar[TCameraType] = ...
    CAMERA_CV_MIL: ClassVar[TCameraType] = ...
    CAMERA_CV_VFL: ClassVar[TCameraType] = ...
    CAMERA_CV_VFW: ClassVar[TCameraType] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TCaptureCVOptions:
    frame_height: int
    frame_width: int
    gain: float
    ieee1394_fps: float
    ieee1394_grayscale: bool
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TCaptureCVOptions) -> None: ...

class TCaptureOptions_DUO3D:
    class TYMLReadResult:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        yrr_EMPTY: ClassVar[TCaptureOptions_DUO3D.TYMLReadResult] = ...
        yrr_NAME_NON_CONSISTENT: ClassVar[TCaptureOptions_DUO3D.TYMLReadResult] = ...
        yrr_OK: ClassVar[TCaptureOptions_DUO3D.TYMLReadResult] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    yrr_EMPTY: ClassVar[TCaptureOptions_DUO3D.TYMLReadResult] = ...
    yrr_NAME_NON_CONSISTENT: ClassVar[TCaptureOptions_DUO3D.TYMLReadResult] = ...
    yrr_OK: ClassVar[TCaptureOptions_DUO3D.TYMLReadResult] = ...
    m_calibration_from_file: bool
    m_capture_imu: bool
    m_capture_rectified: bool
    m_exposure: float
    m_extrinsic_filename: str
    m_fps: float
    m_gain: float
    m_img_height: int
    m_img_width: int
    m_intrinsic_filename: str
    m_led: float
    m_rectify_map_filename: str
    m_stereo_camera: mrpt.pymrpt.mrpt.img.TStereoCamera
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TCaptureOptions_DUO3D) -> None: ...
    def assign(self) -> TCaptureOptions_DUO3D: ...
    @overload
    def loadOptionsFrom(self, configSource: mrpt.pymrpt.mrpt.config.CConfigFileBase, sectionName: str) -> None: ...
    @overload
    def loadOptionsFrom(self, configSource: mrpt.pymrpt.mrpt.config.CConfigFileBase, sectionName: str, prefix: str) -> None: ...
    @overload
    def m_camera_ext_params_from_yml(self) -> TCaptureOptions_DUO3D.TYMLReadResult: ...
    @overload
    def m_camera_ext_params_from_yml(self, _file_name: str) -> TCaptureOptions_DUO3D.TYMLReadResult: ...
    @overload
    def m_camera_int_params_from_yml(self) -> TCaptureOptions_DUO3D.TYMLReadResult: ...
    @overload
    def m_camera_int_params_from_yml(self, _file_name: str) -> TCaptureOptions_DUO3D.TYMLReadResult: ...
    @overload
    def m_rectify_map_from_yml(self) -> TCaptureOptions_DUO3D.TYMLReadResult: ...
    @overload
    def m_rectify_map_from_yml(self, _file_name: str) -> TCaptureOptions_DUO3D.TYMLReadResult: ...

class TCaptureOptions_FlyCapture2:
    autoexposure_EV: float
    autoexposure_abs: bool
    autoexposure_auto: bool
    autoexposure_onOff: bool
    camera_index: int
    framerate: str
    gain_abs: bool
    gain_auto: bool
    gain_dB: float
    grabTimeout: int
    grabmode: str
    numBuffers: int
    open_by_guid: bool
    rect_height: int
    rect_width: int
    shutter_abs: bool
    shutter_auto: bool
    shutter_time_ms: float
    stereo_mode: bool
    strobe_delay: float
    strobe_duration: float
    strobe_enabled: bool
    strobe_polarity: int
    strobe_source: int
    trigger_enabled: bool
    trigger_mode: int
    trigger_polarity: int
    trigger_source: int
    videomode: str
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TCaptureOptions_FlyCapture2) -> None: ...
    def assign(self) -> TCaptureOptions_FlyCapture2: ...
    @overload
    def loadOptionsFrom(self, configSource: mrpt.pymrpt.mrpt.config.CConfigFileBase, sectionName: str) -> None: ...
    @overload
    def loadOptionsFrom(self, configSource: mrpt.pymrpt.mrpt.config.CConfigFileBase, sectionName: str, prefix: str) -> None: ...

class TCaptureOptions_SVS:
    frame_height: int
    frame_width: int
    framerate: float
    getRectified: bool
    m_Corrsize: int
    m_Horopter: int
    m_LR: int
    m_NDisp: int
    m_SpeckleSize: int
    m_Thresh: int
    m_Unique: int
    m_calDisparity: bool
    m_procesOnChip: bool
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, _frame_width: int) -> None: ...
    @overload
    def __init__(self, _frame_width: int, _frame_height: int) -> None: ...
    @overload
    def __init__(self, _frame_width: int, _frame_height: int, _framerate: float) -> None: ...
    @overload
    def __init__(self, _frame_width: int, _frame_height: int, _framerate: float, _NDisp: int) -> None: ...
    @overload
    def __init__(self, _frame_width: int, _frame_height: int, _framerate: float, _NDisp: int, _Corrsize: int) -> None: ...
    @overload
    def __init__(self, _frame_width: int, _frame_height: int, _framerate: float, _NDisp: int, _Corrsize: int, _LR: int) -> None: ...
    @overload
    def __init__(self, _frame_width: int, _frame_height: int, _framerate: float, _NDisp: int, _Corrsize: int, _LR: int, _Thresh: int) -> None: ...
    @overload
    def __init__(self, _frame_width: int, _frame_height: int, _framerate: float, _NDisp: int, _Corrsize: int, _LR: int, _Thresh: int, _Unique: int) -> None: ...
    @overload
    def __init__(self, _frame_width: int, _frame_height: int, _framerate: float, _NDisp: int, _Corrsize: int, _LR: int, _Thresh: int, _Unique: int, _Horopter: int) -> None: ...
    @overload
    def __init__(self, _frame_width: int, _frame_height: int, _framerate: float, _NDisp: int, _Corrsize: int, _LR: int, _Thresh: int, _Unique: int, _Horopter: int, _SpeckleSize: int) -> None: ...
    @overload
    def __init__(self, _frame_width: int, _frame_height: int, _framerate: float, _NDisp: int, _Corrsize: int, _LR: int, _Thresh: int, _Unique: int, _Horopter: int, _SpeckleSize: int, _procesOnChip: bool) -> None: ...
    @overload
    def __init__(self, _frame_width: int, _frame_height: int, _framerate: float, _NDisp: int, _Corrsize: int, _LR: int, _Thresh: int, _Unique: int, _Horopter: int, _SpeckleSize: int, _procesOnChip: bool, _calDisparity: bool) -> None: ...
    @overload
    def __init__(self, arg0: TCaptureOptions_SVS) -> None: ...
    def assign(self) -> TCaptureOptions_SVS: ...

class TCaptureOptions_dc1394:
    brightness: int
    brightness_mode: int
    color_coding: Any
    deinterlace_stereo: bool
    exposure: int
    exposure_mode: int
    frame_height: int
    frame_width: int
    framerate: Any
    gain: int
    gain_mode: int
    gamma: int
    gamma_mode: int
    mode7: int
    ring_buffer_size: int
    sharpness: int
    sharpness_mode: int
    shutter: int
    shutter_mode: int
    trigger_mode: int
    trigger_polarity: int
    trigger_power: int
    trigger_source: int
    white_balance: int
    white_balance_mode: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TCaptureOptions_dc1394) -> None: ...
    def assign(self) -> TCaptureOptions_dc1394: ...

class TMyntEyeCameraParameters(mrpt.pymrpt.mrpt.config.CLoadableOptions):
    ir_intensity: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TMyntEyeCameraParameters) -> None: ...
    @overload
    def __init__(self, arg0: TMyntEyeCameraParameters) -> None: ...
    def assign(self) -> TMyntEyeCameraParameters: ...
    @overload
    def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
    @overload
    def loadFromConfigFile(constclassmrpt, conststd) -> void: ...

class TSensorClassId:
    def __init__(self) -> None: ...

def prepareVideoSourceFromPanel(panel: capsule) -> CCameraSensor: ...
def prepareVideoSourceFromUserSelection() -> CCameraSensor: ...
def readConfigIntoVideoSourcePanel(panel: capsule, in_cfgfile_section_name: str, in_cfgfile: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
def writeConfigFromVideoSourcePanel(panel: capsule, in_cfgfile_section_name: str, out_cfgfile: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
