/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2010  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#ifndef CROVIO_H
#define CROVIO_H

#include <mrpt/core.h>
#include <mrpt/utils/utils_defs.h>
#include <mrpt/hwdrivers/link_pragmas.h>
#include <mrpt/synch/CCriticalSection.h>
#include <mrpt/synch/CThreadSafeVariable.h>
#include <mrpt/slam/CObservationImage.h>

namespace mrpt
{
	namespace hwdrivers
	{
		using namespace std;
		
		class HWDLLIMPEXP CRovio
		{
		private:
			mrpt::synch::CThreadSafeVariable<bool> newFrame;
			mrpt::synch::CThreadSafeVariable<bool> camerathread;
			mrpt::system::TThreadHandle cam_hd;
			mrpt::slam::CObservationImagePtr buffer_img;
			mrpt::synch::CCriticalSection buffer_img_cs;
			mrpt::math::CMatrix intrinsic_matrix;
			std::vector<double> distortion;

		public:
			//bool camerathread;
			struct TParam
			{
				string IP;
				string user;
				string password;
			} TOptions;
			string response, errormsg;

			CRovio();
			virtual ~CRovio();
			void Initialize(string &errormsg_out, string url_out="150.214.109.134", string user_out="admin", string password_out="admin");
			void Moving(int, int, int, string &, string &);
			static void StartCamera(void* ref);
			static void StartCamera2(void* ref);
			void getLastImage(mrpt::slam::CObservationImagePtr& lastImage );
			void getLastImage2(mrpt::slam::CObservationImagePtr& lastImage );
			void captureImage(mrpt::utils::CImage & picture);
			void loadCameraParam();
			void captureImageRect(mrpt::utils::CImage & picture);
			int* getEncoders();
			mrpt::math::TPose2D getPosition();

		};	// End of class

	} // End of namespace

} // End of namespace

#endif
