/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2010  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#ifndef MONO_SLAMMAIN_H
#define MONO_SLAMMAIN_H


#define  MONOSLAM_VERSION    "0.1 (experimental)"

//(*Headers(mono_slamDialog)
#include <wx/sizer.h>
#include <wx/textctrl.h>
#include <wx/checkbox.h>
#include "MyGLCanvas.h"
#include <wx/panel.h>
#include <wx/button.h>
#include <wx/dialog.h>
#include <mrpt/gui/WxUtils.h>
#include <wx/timer.h>
//*)

#include <mrpt/core.h>
#include <mrpt/gui/WxUtils.h>
#include <mrpt/monoslam/CMonoSlam.h>

#include "../wx-common/CMyRedirector.h"

class mono_slamDialog: public wxDialog
{
    public:

        mono_slamDialog(wxWindow* parent,wxWindowID id = -1);
        virtual ~mono_slamDialog();

		// The source of video is in "m_monoslam.m_camera"
		// Create m_video. Return true on success.
		bool prepareVideoSource();

    public:

        //(*Handlers(mono_slamDialog)
        void OnAbout(wxCommandEvent& event);
        void OnbtnQuitClick(wxCommandEvent& event);
        void Onm_realtime2DviewResize(wxSizeEvent& event);
        void OnbtnRunClick(wxCommandEvent& event);
        void OnbtnGoOneStepClick(wxCommandEvent& event);
        void OnbtnStopClick(wxCommandEvent& event);
        void OnbtnResetClick(wxCommandEvent& event);
        void OntimDoOneStepTrigger(wxTimerEvent& event);
        void OnbtnEditCalibClick(wxCommandEvent& event);
        void OnbtnCalibWizardClick(wxCommandEvent& event);
        void OnbtnHelpClick(wxCommandEvent& event);
        void OnbtnLoadParamsClick(wxCommandEvent& event);
        void OnbtnSaveParamsClick(wxCommandEvent& event);
        void OnbtnParamsMonoslamClick(wxCommandEvent& event);
        void OnbtnMotionParamsClick(wxCommandEvent& event);
        void OnbtnParamsKFClick(wxCommandEvent& event);
        //*)

        //(*Identifiers(mono_slamDialog)
        static const long ID_CUSTOM1;
        static const long ID_XY_GLCANVAS;
        static const long ID_CHECKBOX1;
        static const long ID_BUTTON3;
        static const long ID_BUTTON4;
        static const long ID_BUTTON6;
        static const long ID_BUTTON5;
        static const long ID_CUSTOM2;
        static const long ID_BUTTON11;
        static const long ID_PANEL1;
        static const long ID_BUTTON7;
        static const long ID_BUTTON8;
        static const long ID_BUTTON9;
        static const long ID_BUTTON10;
        static const long ID_BUTTON13;
        static const long ID_BUTTON14;
        static const long ID_PANEL2;
        static const long ID_CHECKBOX3;
        static const long ID_TEXTCTRL5;
        static const long ID_TEXTCTRL4;
        static const long ID_BUTTON12;
        static const long ID_BUTTON1;
        static const long ID_BUTTON2;
        static const long ID_TIMER1;
        //*)

        //(*Declarations(mono_slamDialog)
        wxStaticBoxSizer* boxParams;
        wxPanel* panCamParams;
        wxButton* btnStop;
        CMyGLCanvas* m_realtime3Dview;
        wxButton* btnAbout;
        wxButton* btnEditCalib;
        wxButton* btnQuit;
        wxCheckBox* cbSaveLogFile;
        wxButton* btnGoOneStep;
        wxButton* btnLoadParams;
        mrpt::gui::wxMRPTImageControl* m_realtime2Dview;
        wxButton* btnHelp;
        wxButton* btnCalibWizard;
        wxButton* btnMotionParams;
        wxButton* btnRun;
        wxTextCtrl* edLog;
        wxButton* btnParamsKF;
        wxButton* btnReset;
        wxPanel* panParams;
        wxTimer timDoOneStep;
        wxStaticBoxSizer* boxVideo;
        wxTextCtrl* edLogFile;
        wxFlexGridSizer* FlexGridSizer1;
        wxCheckBox* cbStepByStep;
        wxButton* btnSaveParams;
        wxButton* btnParamsMonoslam;
        mrpt::gui::CPanelCameraSelection* m_panelCamera;
        //*)


		// The mono-slam object
		mrpt::monoslam::CMonoSlam	m_monoslam;

        // Update the 3D scene from the Mono-slam internal status
        void update3DView(bool refresh = true);

        CMyRedirector *m_myRedirector;


        DECLARE_EVENT_TABLE()
};


#endif // MONO_SLAMMAIN_H
